/*
 * Decompiled with CFR 0.152.
 */
package org.walluck.oscar.handlers.icq;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ICQSMSMessage {
    private static final Logger LOG = Logger.getLogger((String)(class$org$walluck$oscar$handlers$icq$ICQSMSMessage == null ? (class$org$walluck$oscar$handlers$icq$ICQSMSMessage = ICQSMSMessage.class$("org.walluck.oscar.handlers.icq.ICQSMSMessage")) : class$org$walluck$oscar$handlers$icq$ICQSMSMessage).getName());
    private String destination;
    private String text;
    private String codepage;
    private String sendersUIN;
    private String sendersName;
    private boolean wantDeliveryReceipt;
    private long time;
    static /* synthetic */ Class class$org$walluck$oscar$handlers$icq$ICQSMSMessage;

    public ICQSMSMessage() {
        this.time = System.currentTimeMillis();
    }

    public ICQSMSMessage(String s) {
        if (s == null) {
            throw new NullPointerException();
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        dbf.setIgnoringElementContentWhitespace(true);
        DocumentBuilder parser = null;
        try {
            parser = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException pce) {
            LOG.error((Object)"ParserConfigurationException", (Throwable)pce);
        }
        parser.setErrorHandler(new ErrorHandler(){

            public void warning(SAXParseException spe) {
                LOG.warn((Object)("warning: " + spe));
            }

            public void error(SAXParseException spe) {
                LOG.error((Object)"SAXParseException", (Throwable)spe);
            }

            public void fatalError(SAXParseException spe) {
                LOG.error((Object)"SAXParseException", (Throwable)spe);
            }
        });
        Document document = null;
        try {
            document = parser.parse(new ByteArrayInputStream(s.getBytes()));
        }
        catch (SAXException se) {
            LOG.error((Object)"SAXException", (Throwable)se);
        }
        catch (IOException ioe) {
            LOG.error((Object)"IOException", (Throwable)ioe);
        }
        Element root = document.getDocumentElement();
        if (!root.equals("icq_sms_message")) {
            LOG.error((Object)("Unknown root element: " + root));
            return;
        }
        NodeList children = root.getChildNodes();
        int childCount = children.getLength();
        for (int i = 0; i < childCount; ++i) {
            Node child = children.item(i);
            String tagName = child.getNodeName();
            String tagValue = child.getFirstChild().getNodeValue();
            if (tagName.equals("destination")) {
                this.destination = tagValue;
                continue;
            }
            if (tagName.equals("text")) {
                this.text = tagValue;
                continue;
            }
            if (tagName.equals("codepage")) {
                this.codepage = tagValue;
                continue;
            }
            if (tagName.equals("senders_UIN")) {
                this.sendersUIN = tagValue;
                continue;
            }
            if (tagName.equals("senders_name")) {
                this.sendersName = tagValue;
                continue;
            }
            if (tagName.equals("delivery_receipt")) {
                this.wantDeliveryReceipt = tagValue != null && tagValue.equals("Yes");
                continue;
            }
            if (!tagName.equals("time")) continue;
            SimpleDateFormat sdf = new SimpleDateFormat();
            sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
            sdf.applyPattern("EEE, dd MMM yyyy hh:mm:ss z");
            Date date = sdf.parse(tagValue, new ParsePosition(0));
            this.time = date.getTime();
        }
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getCodepage() {
        return this.codepage;
    }

    public void setCodepage(String codepage) {
        this.codepage = codepage;
    }

    public String getSendersUIN() {
        return this.sendersUIN;
    }

    public void setSendersUIN(String sendersUIN) {
        this.sendersUIN = sendersUIN;
    }

    public String getSendersName() {
        return this.sendersName;
    }

    public void setSendersName(String sendersName) {
        this.sendersName = sendersName;
    }

    public boolean wantDeliveryReceipt() {
        return this.wantDeliveryReceipt;
    }

    public void setWantDeliveryReceipt(boolean wantDeliveryReceipt) {
        this.wantDeliveryReceipt = wantDeliveryReceipt;
    }

    public long getTime() {
        return this.time;
    }

    public String toString() {
        SimpleDateFormat sdf = new SimpleDateFormat();
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        sdf.applyPattern("EEE, dd MMM yyyy hh:mm:ss z");
        String s = sdf.format(new Date(this.time));
        StringBuffer sb = new StringBuffer();
        sb.append("<icq_sms_message><destination>");
        sb.append(this.destination);
        sb.append("</destination><text>");
        sb.append(this.text);
        sb.append("</text><codepage>");
        sb.append(this.codepage);
        sb.append("</codepage><senders_UIN>");
        sb.append(this.sendersUIN);
        sb.append("</senders_UIN><senders_name>");
        sb.append(this.sendersName);
        sb.append("</senders_name><delivery_receipt>");
        sb.append(this.wantDeliveryReceipt ? "Yes" : "No");
        sb.append("</delivery_receipt><time>");
        sb.append(s);
        sb.append("</time></icq_sms_message>");
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

