/*
 * Decompiled with CFR 0.152.
 */
package jodd.db.oom.sqlgen;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jodd.db.DbSqlException;
import jodd.db.oom.ColumnData;
import jodd.db.oom.DbEntityColumnDescriptor;
import jodd.db.oom.DbEntityDescriptor;
import jodd.db.oom.DbOomManager;
import jodd.db.oom.DbSqlGenerator;
import jodd.db.oom.sqlgen.ParameterValue;
import jodd.introspector.ClassDescriptor;
import jodd.introspector.ClassIntrospector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbEntitySearcher
implements DbSqlGenerator {
    protected final Object entity;
    protected final ClassDescriptor entityClassDescriptor;
    protected final DbOomManager dbOomManager;
    protected final DbEntityDescriptor ded;
    protected Map<String, ParameterValue> queryParameters = new HashMap<String, ParameterValue>();

    public DbEntitySearcher(Object entity) {
        this.entity = entity;
        this.dbOomManager = DbOomManager.getInstance();
        this.ded = this.dbOomManager.lookupType(entity.getClass());
        if (this.ded == null) {
            throw new DbSqlException("Type '" + entity.getClass() + "' is not an database entity.");
        }
        this.entityClassDescriptor = ClassIntrospector.lookup(entity.getClass());
    }

    @Override
    public String generateQuery() {
        StringBuilder query = new StringBuilder("select * from ");
        query.append(this.ded.getTableName());
        Field[] fields = this.entityClassDescriptor.getAllFields(true);
        boolean firstCondition = true;
        boolean hasCondition = false;
        for (Field field : fields) {
            Object value;
            try {
                value = field.get(this.entity);
            }
            catch (IllegalAccessException iaex) {
                throw new DbSqlException("Unable to read value of property: " + field.getName(), iaex);
            }
            if (value == null) continue;
            if (firstCondition) {
                query.append(" where ");
                firstCondition = false;
            }
            if (hasCondition) {
                query.append(" and ");
            }
            hasCondition = this.forEachField(query, field, value);
        }
        return query.toString();
    }

    protected boolean forEachField(StringBuilder query, Field field, Object value) {
        String columnName = this.ded.getColumnName(field.getName());
        DbEntityColumnDescriptor dec = this.ded.findByColumnName(columnName);
        if (value instanceof String) {
            query.append(columnName).append(" like :").append(columnName);
            this.queryParameters.put(columnName, new ParameterValue('%' + (String)value + '%', dec));
            return true;
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            if (collection.isEmpty()) {
                return false;
            }
            Iterator iterator = collection.iterator();
            query.append(columnName).append(" in (");
            int c = 0;
            while (iterator.hasNext()) {
                value = iterator.next();
                if (c != 0) {
                    query.append(',');
                }
                String name = columnName + c;
                query.append(':').append(name);
                this.queryParameters.put(name, new ParameterValue(value, dec));
                ++c;
            }
            query.append(')');
            return true;
        }
        query.append(columnName).append("=:").append(columnName);
        this.queryParameters.put(columnName, new ParameterValue(value, dec));
        return true;
    }

    @Override
    public Map<String, ParameterValue> getQueryParameters() {
        return this.queryParameters;
    }

    @Override
    public Map<String, ColumnData> getColumnData() {
        return null;
    }

    @Override
    public String[] getJoinHints() {
        return null;
    }
}

