/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.trash.search;

import com.liferay.portal.kernel.dao.search.DisplayTerms;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Group;
import com.liferay.portlet.PortalPreferences;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.trash.search.EntryDisplayTerms;
import com.liferay.portlet.trash.search.EntrySearchTerms;
import com.liferay.portlet.trash.util.TrashUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;

public class EntrySearch
extends SearchContainer<Group> {
    static List<String> headerNames = new ArrayList<String>();
    static Map<String, String> orderableHeaders = new HashMap<String, String>();
    public static final String EMPTY_RESULTS_MESSAGE = "the-recycle-bin-is-empty";
    private static Log _log;

    static {
        headerNames.add("name");
        headerNames.add("type");
        headerNames.add("removed-date");
        headerNames.add("removed-by");
        orderableHeaders.put("name", "name");
        orderableHeaders.put("type", "type");
        orderableHeaders.put("removed-date", "removed-date");
        orderableHeaders.put("removed-by", "removed-by");
        _log = LogFactoryUtil.getLog(EntrySearch.class);
    }

    public EntrySearch(PortletRequest portletRequest, PortletURL iteratorURL) {
        super(portletRequest, (DisplayTerms)new EntryDisplayTerms(portletRequest), (DisplayTerms)new EntrySearchTerms(portletRequest), "cur", DEFAULT_DELTA, iteratorURL, headerNames, EMPTY_RESULTS_MESSAGE);
        try {
            PortalPreferences preferences = PortletPreferencesFactoryUtil.getPortalPreferences((PortletRequest)portletRequest);
            String orderByCol = ParamUtil.getString((PortletRequest)portletRequest, (String)"orderByCol");
            String orderByType = ParamUtil.getString((PortletRequest)portletRequest, (String)"orderByType");
            if (Validator.isNotNull((String)orderByCol) && Validator.isNotNull((String)orderByType)) {
                preferences.setValue("125", "entries-order-by-col", orderByCol);
                preferences.setValue("125", "entries-order-by-type", orderByType);
            } else {
                orderByCol = preferences.getValue("125", "entries-order-by-col", "removed-date");
                orderByType = preferences.getValue("125", "entries-order-by-type", "asc");
            }
            OrderByComparator orderByComparator = TrashUtil.getEntryOrderByComparator((String)orderByCol, (String)orderByType);
            this.setOrderableHeaders(orderableHeaders);
            this.setOrderByCol(orderByCol);
            this.setOrderByType(orderByType);
            this.setOrderByComparator(orderByComparator);
        }
        catch (Exception e2) {
            _log.error((Throwable)e2);
        }
    }
}

