/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;
import org.hsqldb.error.Error;
import org.hsqldb.lib.StringConverter;

public class Crypto {
    SecretKeySpec key;
    Cipher outCipher;
    Cipher inCipher;
    Cipher inStreamCipher;

    public Crypto(String keyString, String cipherName, String provider) {
        try {
            byte[] encodedKey = StringConverter.hexStringToByteArray(keyString);
            this.key = new SecretKeySpec(encodedKey, cipherName);
            this.outCipher = provider == null ? Cipher.getInstance(cipherName) : Cipher.getInstance(cipherName, provider);
            this.outCipher.init(1, this.key);
            this.inCipher = provider == null ? Cipher.getInstance(cipherName) : Cipher.getInstance(cipherName, provider);
            this.inCipher.init(2, this.key);
            this.inStreamCipher = provider == null ? Cipher.getInstance(cipherName) : Cipher.getInstance(cipherName, provider);
            this.inStreamCipher.init(2, this.key);
            return;
        }
        catch (NoSuchPaddingException e) {
            throw Error.error(331, e);
        }
        catch (NoSuchAlgorithmException e) {
            throw Error.error(331, e);
        }
        catch (InvalidKeyException e) {
            throw Error.error(331, e);
        }
        catch (NoSuchProviderException e) {
            throw Error.error(331, e);
        }
        catch (IOException e) {
            throw Error.error(331, e);
        }
    }

    public synchronized InputStream getInputStream(InputStream in) {
        if (this.inCipher == null) {
            return in;
        }
        try {
            this.inStreamCipher.init(2, this.key);
            return new CipherInputStream(in, this.inStreamCipher);
        }
        catch (InvalidKeyException e) {
            throw Error.error(331, e);
        }
    }

    public synchronized OutputStream getOutputStream(OutputStream out) {
        if (this.outCipher == null) {
            return out;
        }
        try {
            this.outCipher.init(1, this.key);
            return new CipherOutputStream(out, this.outCipher);
        }
        catch (InvalidKeyException e) {
            throw Error.error(331, e);
        }
    }

    public synchronized int decode(byte[] source, int sourceOffset, int length, byte[] dest, int destOffset) {
        if (this.inCipher == null) {
            return length;
        }
        try {
            this.inCipher.init(2, this.key);
            return this.inCipher.doFinal(source, sourceOffset, length, dest, destOffset);
        }
        catch (InvalidKeyException e) {
            throw Error.error(331, e);
        }
        catch (BadPaddingException e) {
            throw Error.error(331, e);
        }
        catch (IllegalBlockSizeException e) {
            throw Error.error(331, e);
        }
        catch (ShortBufferException e) {
            throw Error.error(331, e);
        }
    }

    public synchronized int encode(byte[] source, int sourceOffset, int length, byte[] dest, int destOffset) {
        if (this.outCipher == null) {
            return length;
        }
        try {
            this.outCipher.init(1, this.key);
            return this.outCipher.doFinal(source, sourceOffset, length, dest, destOffset);
        }
        catch (InvalidKeyException e) {
            throw Error.error(331, e);
        }
        catch (BadPaddingException e) {
            throw Error.error(331, e);
        }
        catch (IllegalBlockSizeException e) {
            throw Error.error(331, e);
        }
        catch (ShortBufferException e) {
            throw Error.error(331, e);
        }
    }

    public static byte[] getNewKey(String cipherName, String provider) {
        try {
            KeyGenerator generator = provider == null ? KeyGenerator.getInstance(cipherName) : KeyGenerator.getInstance(cipherName, provider);
            SecretKey key = generator.generateKey();
            byte[] raw = key.getEncoded();
            return raw;
        }
        catch (NoSuchAlgorithmException e) {
            throw Error.error(331, e);
        }
        catch (NoSuchProviderException e) {
            throw Error.error(331, e);
        }
    }

    public synchronized int getEncodedSize(int size) {
        try {
            return this.outCipher.getOutputSize(size);
        }
        catch (IllegalStateException ex) {
            try {
                this.outCipher.init(1, this.key);
                return this.outCipher.getOutputSize(size);
            }
            catch (InvalidKeyException e) {
                throw Error.error(331, e);
            }
        }
    }
}

