/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search;

import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Locale;
import javax.portlet.PortletURL;

public class Summary {
    private String _content;
    private Locale _locale;
    private int _maxContentLength;
    private PortletURL _portletURL;
    private String _title;

    public Summary(Locale locale, String title, String content, PortletURL portletURL) {
        this._locale = locale;
        this._title = title;
        this._content = content;
        this._portletURL = portletURL;
    }

    public Summary(String title, String content, PortletURL portletURL) {
        this(LocaleThreadLocal.getThemeDisplayLocale(), title, content, portletURL);
    }

    public String getContent() {
        if (Validator.isNull(this._content)) {
            return "";
        }
        return this._content;
    }

    public Locale getLocale() {
        return this._locale;
    }

    public int getMaxContentLength() {
        return this._maxContentLength;
    }

    public PortletURL getPortletURL() {
        return this._portletURL;
    }

    public String getTitle() {
        if (Validator.isNull(this._title)) {
            return "";
        }
        return this._title;
    }

    public void setContent(String content) {
        this._content = content;
        if (this._content != null && this._maxContentLength > 0 && this._content.length() > this._maxContentLength) {
            this._content = StringUtil.shorten(this._content, this._maxContentLength);
        }
    }

    public void setLocale(Locale locale) {
        this._locale = locale;
    }

    public void setMaxContentLength(int maxContentLength) {
        this._maxContentLength = maxContentLength;
        this.setContent(this._content);
    }

    public void setPortletURL(PortletURL portletURL) {
        this._portletURL = portletURL;
    }

    public void setTitle(String title) {
        this._title = title;
    }
}

