/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.grid;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Formatter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.grib.GribGridRecord;
import ucar.grib.GribPds;
import ucar.grid.GridRecord;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.dataset.DatasetConstructor;
import ucar.nc2.units.DateFormatter;
import ucar.nc2.units.DateUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridTimeCoord
implements Comparable<GridTimeCoord> {
    private static Logger log = LoggerFactory.getLogger(GridTimeCoord.class);
    private int seq = 0;
    private String timeUdunit;
    private int timeUnit;
    private Date baseDate;
    private List<Date> times;
    private List<TimeCoordWithInterval> timeIntvs;
    private int constantInterval = -1;
    private int[] coordData;

    GridTimeCoord(List<GridRecord> records) {
        GribGridRecord ggr;
        for (GridRecord record : records) {
            Date ref;
            if (this.baseDate == null) {
                this.baseDate = record.getReferenceTime();
                this.timeUdunit = record.getTimeUdunitName();
                this.timeUnit = record.getTimeUnit();
            }
            if (!(ref = record.getReferenceTime()).before(this.baseDate)) continue;
            this.baseDate = ref;
        }
        if (records.get(0) instanceof GribGridRecord && (ggr = (GribGridRecord)records.get(0)).isInterval()) {
            this.timeIntvs = new ArrayList<TimeCoordWithInterval>();
            boolean same = true;
            int intv = -1;
            for (GridRecord gr : records) {
                Date validTime;
                TimeCoordWithInterval timeCoordIntv;
                int start;
                GribPds pds;
                int[] timeInv;
                int end;
                int intv2;
                ggr = (GribGridRecord)gr;
                Date ref = gr.getReferenceTime();
                if (!this.baseDate.equals(ref)) {
                    log.warn(gr + " does not have same base date= " + this.baseDate + " != " + ref);
                }
                if ((intv2 = (end = (timeInv = (pds = ggr.getPds()).getForecastTimeInterval(this.timeUnit))[1]) - (start = timeInv[0])) > 0) {
                    if (intv < 0) {
                        intv = intv2;
                    } else {
                        boolean bl = same = same && intv == intv2;
                    }
                }
                if (this.timeIntvs.contains(timeCoordIntv = new TimeCoordWithInterval(validTime = gr.getValidTime(), start, intv2))) continue;
                this.timeIntvs.add(timeCoordIntv);
            }
            if (same) {
                this.constantInterval = intv;
            }
            Collections.sort(this.timeIntvs);
            return;
        }
        this.times = new ArrayList<Date>();
        for (GridRecord gr : records) {
            Date validTime = gr.getValidTime();
            if (validTime == null) {
                validTime = gr.getReferenceTime();
            }
            if (this.times.contains(validTime)) continue;
            this.times.add(validTime);
        }
        Collections.sort(this.times);
    }

    boolean matchTimes(List<GridRecord> records) {
        ArrayList<Comparable<TimeCoordWithInterval>> timeList;
        GribGridRecord ggr;
        for (GridRecord record : records) {
            if (this.timeUdunit.equals(record.getTimeUdunitName())) continue;
            return false;
        }
        if (records.get(0) instanceof GribGridRecord && (ggr = (GribGridRecord)records.get(0)).isInterval() != this.isInterval()) {
            return false;
        }
        if (this.isInterval()) {
            timeList = new ArrayList<Comparable<TimeCoordWithInterval>>(records.size());
            for (GridRecord record : records) {
                Date ref = record.getReferenceTime();
                if (!this.baseDate.equals(ref)) {
                    return false;
                }
                GribGridRecord ggr2 = (GribGridRecord)record;
                GribPds pds = ggr2.getPds();
                int[] timeInv = pds.getForecastTimeInterval(this.timeUnit);
                int start = timeInv[0];
                int end = timeInv[1];
                int intv2 = end - start;
                Date validTime = record.getValidTime();
                TimeCoordWithInterval timeCoordIntv = new TimeCoordWithInterval(validTime, start, intv2);
                if (timeList.contains(timeCoordIntv)) continue;
                timeList.add(timeCoordIntv);
            }
            Collections.sort(timeList);
            return ((Object)timeList).equals(this.timeIntvs);
        }
        timeList = new ArrayList(records.size());
        for (GridRecord record : records) {
            Date validTime = record.getValidTime();
            if (validTime == null) {
                validTime = record.getReferenceTime();
            }
            if (timeList.contains(validTime)) continue;
            timeList.add(validTime);
        }
        Collections.sort(timeList);
        return ((Object)timeList).equals(this.times);
    }

    void setSequence(int seq) {
        this.seq = seq;
    }

    String getName() {
        return this.seq == 0 ? "time" : "time" + this.seq;
    }

    void addDimensionsToNetcdfFile(NetcdfFile ncfile, Group g) {
        ncfile.addDimension(g, new Dimension(this.getName(), this.getNTimes(), true));
    }

    void addToNetcdfFile(NetcdfFile ncfile, Group g) {
        Variable v = new Variable(ncfile, g, null, this.getName());
        v.setDataType(DataType.INT);
        DateFormatter formatter = new DateFormatter();
        String refDate = formatter.toDateTimeStringISO(this.baseDate);
        String udunit = this.timeUdunit + " since " + refDate;
        DateUnit dateUnit = null;
        try {
            dateUnit = new DateUnit(udunit);
        }
        catch (Exception e) {
            log.error("TimeCoord not added, cant make DateUnit from String '" + udunit + "'", (Throwable)e);
            return;
        }
        Array coordArray = null;
        Array boundsArray = null;
        int ntimes = this.getNTimes();
        this.coordData = new int[ntimes];
        if (!this.isInterval()) {
            for (int i = 0; i < this.times.size(); ++i) {
                this.coordData[i] = (int)dateUnit.makeValue(this.times.get(i));
            }
            coordArray = Array.factory(DataType.INT, new int[]{ntimes}, (Object)this.coordData);
        } else {
            int[] boundsData = new int[ntimes * 2];
            for (int i = 0; i < this.timeIntvs.size(); ++i) {
                TimeCoordWithInterval tintv = this.timeIntvs.get(i);
                this.coordData[i] = tintv.start + tintv.interval;
                boundsData[2 * i + 1] = tintv.start + tintv.interval;
                boundsData[2 * i] = tintv.start;
            }
            coordArray = Array.factory(DataType.INT, new int[]{ntimes}, (Object)this.coordData);
            boundsArray = Array.factory(DataType.INT, new int[]{ntimes, 2}, (Object)boundsData);
        }
        v.setDimensions(v.getShortName());
        v.setCachedData(coordArray, false);
        if (!this.isInterval()) {
            v.addAttribute(new Attribute("long_name", "forecast time"));
            v.addAttribute(new Attribute("units", this.timeUdunit + " since " + refDate));
        } else {
            Formatter intervalName = new Formatter();
            if (this.constantInterval < 0) {
                intervalName.format("(mixed intervals)", new Object[0]);
            } else {
                intervalName.format("(%d %s intervals)", this.constantInterval, this.timeUdunit);
            }
            v.addAttribute(new Attribute("long_name", "forecast time for " + intervalName.toString()));
            v.addAttribute(new Attribute("units", this.timeUdunit + " since " + refDate));
            v.addAttribute(new Attribute("bounds", this.getName() + "_bounds"));
            if (g == null) {
                g = ncfile.getRootGroup();
            }
            Dimension bd = DatasetConstructor.getBoundsDimension(ncfile);
            Variable vb = new Variable(ncfile, g, null, this.getName() + "_bounds");
            vb.setDataType(DataType.INT);
            vb.setDimensions(this.getName() + " " + bd.getName());
            vb.addAttribute(new Attribute("long_name", "bounds for " + this.getName()));
            vb.addAttribute(new Attribute("units", this.timeUdunit + " since " + refDate));
            vb.setCachedData(boundsArray, false);
            ncfile.addVariable(g, vb);
        }
        ncfile.addVariable(g, v);
    }

    int findIndex(GridRecord record) {
        Date validTime = record.getValidTime();
        if (!this.isInterval()) {
            return this.times.indexOf(validTime);
        }
        int index = 0;
        for (TimeCoordWithInterval t : this.timeIntvs) {
            GribGridRecord ggr = (GribGridRecord)record;
            GribPds pds = ggr.getPds();
            int[] intv = pds.getForecastTimeInterval(this.timeUnit);
            int diff = intv[1] - intv[0];
            if (t.coord.equals(validTime) && t.interval == diff) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    int getNTimes() {
        return this.isInterval() ? this.timeIntvs.size() : this.times.size();
    }

    int getConstantInterval() {
        return this.constantInterval;
    }

    String getTimeUnit() {
        return this.timeUdunit;
    }

    boolean isInterval() {
        return this.timeIntvs != null;
    }

    public String getCoord(int i) {
        if (this.timeIntvs == null) {
            return this.coordData[i] + " ";
        }
        TimeCoordWithInterval ti = this.timeIntvs.get(i);
        return this.coordData[i] + "=" + ti.start + "/" + ti.interval;
    }

    @Override
    public int compareTo(GridTimeCoord o) {
        return o.getNTimes() - this.getNTimes();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TimeCoordWithInterval
    implements Comparable<TimeCoordWithInterval> {
        Date coord;
        int start;
        int interval;

        private TimeCoordWithInterval(Date coord, int start, int interval) {
            this.coord = coord;
            this.start = start;
            this.interval = interval;
        }

        @Override
        public int compareTo(TimeCoordWithInterval o) {
            int diff = this.coord.compareTo(o.coord);
            return diff == 0 ? o.interval - this.interval : diff;
        }

        public int hashCode() {
            return 17 * this.coord.hashCode() + this.interval;
        }

        public boolean equals(Object obj) {
            TimeCoordWithInterval o = (TimeCoordWithInterval)obj;
            return this.coord.equals(o.coord) && this.interval == o.interval;
        }

        public String toString() {
            return "start=" + this.start + ", interval=" + this.interval;
        }
    }
}

