/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.model.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portlet.journal.NoSuchFolderException;
import com.liferay.portlet.journal.model.JournalFolder;
import com.liferay.portlet.journal.model.impl.JournalFolderBaseImpl;
import com.liferay.portlet.journal.service.JournalFolderLocalServiceUtil;
import com.liferay.portlet.trash.model.TrashEntry;
import com.liferay.portlet.trash.service.TrashEntryLocalServiceUtil;
import java.util.ArrayList;
import java.util.List;

public class JournalFolderImpl
extends JournalFolderBaseImpl {
    public List<Long> getAncestorFolderIds() throws PortalException, SystemException {
        ArrayList<Long> ancestorFolderIds = new ArrayList<Long>();
        JournalFolderImpl folder = this;
        while (!folder.isRoot()) {
            try {
                folder = folder.getParentFolder();
                ancestorFolderIds.add(folder.getFolderId());
            }
            catch (NoSuchFolderException nsfe) {
                if (folder.isInTrash()) break;
                throw nsfe;
            }
        }
        return ancestorFolderIds;
    }

    public List<JournalFolder> getAncestors() throws PortalException, SystemException {
        ArrayList<JournalFolder> ancestors = new ArrayList<JournalFolder>();
        JournalFolderImpl folder = this;
        while (!folder.isRoot()) {
            folder = folder.getParentFolder();
            ancestors.add(folder);
        }
        return ancestors;
    }

    public JournalFolder getParentFolder() throws PortalException, SystemException {
        if (this.getParentFolderId() == 0L) {
            return null;
        }
        return JournalFolderLocalServiceUtil.getFolder((long)this.getParentFolderId());
    }

    public boolean isInTrashExplicitly() throws SystemException {
        if (!this.isInTrash()) {
            return false;
        }
        TrashEntry trashEntry = TrashEntryLocalServiceUtil.fetchEntry((String)this.getModelClassName(), (long)this.getTrashEntryClassPK());
        return trashEntry != null;
    }

    public boolean isRoot() {
        return this.getParentFolderId() == 0L;
    }
}

