/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.schemaframework;

import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.tools.schemaframework.TableDefinition;

public class TypeTableDefinition
extends TableDefinition {
    protected String typeName = "";
    protected String additional = "";

    public Writer buildCreationWriter(AbstractSession session, Writer writer) {
        try {
            writer.write("CREATE TABLE " + this.getFullName() + " OF " + this.getTypeName() + " (");
            Vector<String> keyFields = this.getPrimaryKeyFieldNames();
            if (!keyFields.isEmpty() && session.getPlatform().supportsPrimaryKeyConstraint()) {
                writer.write("PRIMARY KEY (");
                Enumeration<String> keyEnum = keyFields.elements();
                while (keyEnum.hasMoreElements()) {
                    writer.write(keyEnum.nextElement());
                    if (!keyEnum.hasMoreElements()) continue;
                    writer.write(", ");
                }
                writer.write(")");
            }
            writer.write(")");
            writer.write(this.additional);
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
        return writer;
    }

    public String getAdditonal() {
        return this.additional;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setAdditional(String additional) {
        this.additional = additional;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }
}

