/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util.cache;

import java.io.IOException;
import java.util.Collection;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.cache.FileCache;
import ucar.nc2.util.cache.FileCacheable;
import ucar.nc2.util.cache.FileFactory;
import ucar.unidata.io.RandomAccessFile;

public class FileCacheRaf {
    private FileCache cache;
    private FileFactory factory;

    public FileCacheRaf(int minElementsInMemory, int maxElementsInMemory, int period) {
        this.cache = new FileCache("FileCacheRaf", minElementsInMemory, maxElementsInMemory, -1, period);
        this.factory = new RafFactory();
    }

    public void clearCache(boolean force) {
        this.cache.clearCache(force);
    }

    public Collection getCache() {
        return this.cache.getCache().values();
    }

    public static void shutdown() {
        FileCache.shutdown();
    }

    public Raf acquire(String filename) throws IOException {
        return (Raf)this.cache.acquire(this.factory, filename, null);
    }

    public void release(Raf craf) throws IOException {
        this.cache.release(craf);
    }

    public class Raf
    implements FileCacheable {
        private RandomAccessFile raf;

        Raf(String location) throws IOException {
            this.raf = new RandomAccessFile(location, "r");
        }

        public String getLocation() {
            return this.raf.getLocation();
        }

        public RandomAccessFile getRaf() {
            return this.raf;
        }

        public void close() throws IOException {
            this.raf.close();
        }

        public boolean sync() throws IOException {
            return false;
        }

        public void setFileCache(FileCache fileCache) {
        }
    }

    private class RafFactory
    implements FileFactory {
        private RafFactory() {
        }

        public FileCacheable open(String location, int buffer_size, CancelTask cancelTask, Object iospMessage) throws IOException {
            return new Raf(location);
        }
    }
}

