/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.filters;

import com.ecyrd.jspwiki.FileUtil;
import com.ecyrd.jspwiki.InternalWikiException;
import com.ecyrd.jspwiki.TextUtil;
import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.WikiPage;
import com.ecyrd.jspwiki.attachment.Attachment;
import com.ecyrd.jspwiki.auth.user.UserProfile;
import com.ecyrd.jspwiki.filters.BasicPageFilter;
import com.ecyrd.jspwiki.filters.RedirectException;
import com.ecyrd.jspwiki.providers.ProviderException;
import com.ecyrd.jspwiki.ui.EditorManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import net.sf.akismet.Akismet;
import org.apache.commons.jrcs.diff.AddDelta;
import org.apache.commons.jrcs.diff.ChangeDelta;
import org.apache.commons.jrcs.diff.DeleteDelta;
import org.apache.commons.jrcs.diff.Delta;
import org.apache.commons.jrcs.diff.Diff;
import org.apache.commons.jrcs.diff.DiffAlgorithm;
import org.apache.commons.jrcs.diff.DifferentiationFailedException;
import org.apache.commons.jrcs.diff.Revision;
import org.apache.commons.jrcs.diff.myers.MyersDiff;
import org.apache.commons.lang.time.StopWatch;
import org.apache.log4j.Logger;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpamFilter
extends BasicPageFilter {
    private static final String ATTR_SPAMFILTER_SCORE = "spamfilter.score";
    private static final String REASON_REGEXP = "Regexp";
    private static final String REASON_IP_BANNED_TEMPORARILY = "IPBannedTemporarily";
    private static final String REASON_BOT_TRAP = "BotTrap";
    private static final String REASON_AKISMET = "Akismet";
    private static final String REASON_TOO_MANY_URLS = "TooManyUrls";
    private static final String REASON_SIMILAR_MODIFICATIONS = "SimilarModifications";
    private static final String REASON_TOO_MANY_MODIFICATIONS = "TooManyModifications";
    private static final String REASON_UTF8_TRAP = "UTF8Trap";
    private static final String LISTVAR = "spamwords";
    public static final String PROP_WORDLIST = "wordlist";
    public static final String PROP_ERRORPAGE = "errorpage";
    public static final String PROP_PAGECHANGES = "pagechangesinminute";
    public static final String PROP_SIMILARCHANGES = "similarchanges";
    public static final String PROP_BANTIME = "bantime";
    public static final String PROP_BLACKLIST = "blacklist";
    public static final String PROP_MAXURLS = "maxurls";
    public static final String PROP_AKISMET_API_KEY = "akismet-apikey";
    public static final String PROP_IGNORE_AUTHENTICATED = "ignoreauthenticated";
    public static final String PROP_CAPTCHA = "captcha";
    public static final String PROP_FILTERSTRATEGY = "strategy";
    public static final String STRATEGY_EAGER = "eager";
    public static final String STRATEGY_SCORE = "score";
    private static final String URL_REGEXP = "(http://|https://|mailto:)([A-Za-z0-9_/\\.\\+\\?\\#\\-\\@=&;]+)";
    private String m_forbiddenWordsPage = "SpamFilterWordList";
    private String m_errorPage = "RejectedMessage";
    private String m_blacklist = "SpamFilterWordList/blacklist.txt";
    private PatternMatcher m_matcher = new Perl5Matcher();
    private PatternCompiler m_compiler = new Perl5Compiler();
    private Collection<Pattern> m_spamPatterns = null;
    private Date m_lastRebuild = new Date(0L);
    private static Logger c_spamlog = Logger.getLogger((String)"SpamLog");
    private static Logger log = Logger.getLogger(SpamFilter.class);
    private Vector<Host> m_temporaryBanList = new Vector();
    private int m_banTime = 60;
    private Vector<Host> m_lastModifications = new Vector();
    private int m_limitSinglePageChanges = 5;
    private int m_limitSimilarChanges = 2;
    private int m_maxUrls = 10;
    private Pattern m_urlPattern;
    private Akismet m_akismet;
    private String m_akismetAPIKey = null;
    private boolean m_useCaptcha = false;
    private int m_scoreLimit = 1;
    private boolean m_ignoreAuthenticated = false;
    private boolean m_stopAtFirstMatch = true;
    private static String c_hashName;
    private static long c_lastUpdate;
    private static final long HASH_DELAY = 24L;
    private static final int REJECT = 0;
    private static final int ACCEPT = 1;
    private static final int NOTE = 2;

    @Override
    public void initialize(WikiEngine engine, Properties properties) {
        this.m_forbiddenWordsPage = properties.getProperty(PROP_WORDLIST, this.m_forbiddenWordsPage);
        this.m_errorPage = properties.getProperty(PROP_ERRORPAGE, this.m_errorPage);
        this.m_limitSinglePageChanges = TextUtil.getIntegerProperty(properties, PROP_PAGECHANGES, this.m_limitSinglePageChanges);
        this.m_limitSimilarChanges = TextUtil.getIntegerProperty(properties, PROP_SIMILARCHANGES, this.m_limitSimilarChanges);
        this.m_maxUrls = TextUtil.getIntegerProperty(properties, PROP_MAXURLS, this.m_maxUrls);
        this.m_banTime = TextUtil.getIntegerProperty(properties, PROP_BANTIME, this.m_banTime);
        this.m_blacklist = properties.getProperty(PROP_BLACKLIST, this.m_blacklist);
        this.m_ignoreAuthenticated = TextUtil.getBooleanProperty(properties, PROP_IGNORE_AUTHENTICATED, this.m_ignoreAuthenticated);
        this.m_useCaptcha = properties.getProperty(PROP_CAPTCHA, "").equals("asirra");
        try {
            this.m_urlPattern = this.m_compiler.compile(URL_REGEXP);
        }
        catch (MalformedPatternException e) {
            log.fatal((Object)"Internal error: Someone put in a faulty pattern.", (Throwable)e);
            throw new InternalWikiException("Faulty pattern.");
        }
        this.m_akismetAPIKey = TextUtil.getStringProperty(properties, PROP_AKISMET_API_KEY, this.m_akismetAPIKey);
        this.m_stopAtFirstMatch = TextUtil.getStringProperty(properties, PROP_FILTERSTRATEGY, STRATEGY_EAGER).equals(STRATEGY_EAGER);
        log.info((Object)("# Spam filter initialized.  Temporary ban time " + this.m_banTime + " mins, max page changes/minute: " + this.m_limitSinglePageChanges));
    }

    private static String log(WikiContext ctx, int type, String source, String message) {
        message = TextUtil.replaceString(message, "\r\n", "\\r\\n");
        message = TextUtil.replaceString(message, "\"", "\\\"");
        String uid = SpamFilter.getUniqueID();
        String page = ctx.getPage().getName();
        String reason = "UNKNOWN";
        String addr = ctx.getHttpRequest() != null ? ctx.getHttpRequest().getRemoteAddr() : "-";
        switch (type) {
            case 0: {
                reason = "REJECTED";
                break;
            }
            case 1: {
                reason = "ACCEPTED";
                break;
            }
            case 2: {
                reason = "NOTE";
                break;
            }
            default: {
                throw new InternalWikiException("Illegal type " + type);
            }
        }
        c_spamlog.info((Object)(reason + " " + source + " " + uid + " " + addr + " \"" + page + "\" " + message));
        return uid;
    }

    @Override
    public String preSave(WikiContext context, String content) throws RedirectException {
        Integer score;
        this.cleanBanList();
        this.refreshBlacklists(context);
        Change change = SpamFilter.getChange(context, content);
        if (!this.ignoreThisUser(context)) {
            this.checkBanList(context, change);
            this.checkSinglePageChange(context, content, change);
            this.checkPatternList(context, content, change);
        }
        if (!this.m_stopAtFirstMatch && (score = (Integer)context.getVariable(ATTR_SPAMFILTER_SCORE)) != null && score >= this.m_scoreLimit) {
            throw new RedirectException("Herb says you got too many points", this.getRedirectPage(context));
        }
        SpamFilter.log(context, 1, "-", change.toString());
        return content;
    }

    private void checkStrategy(WikiContext context, String error, String message) throws RedirectException {
        if (this.m_stopAtFirstMatch) {
            throw new RedirectException(message, this.getRedirectPage(context));
        }
        Integer score = (Integer)context.getVariable(ATTR_SPAMFILTER_SCORE);
        score = score != null ? Integer.valueOf(score + 1) : Integer.valueOf(1);
        context.setVariable(ATTR_SPAMFILTER_SCORE, score);
    }

    private Collection<Pattern> parseWordList(WikiPage source, String list) {
        ArrayList<Pattern> compiledpatterns = new ArrayList<Pattern>();
        if (list != null) {
            StringTokenizer tok = new StringTokenizer(list, " \t\n");
            while (tok.hasMoreTokens()) {
                String pattern = tok.nextToken();
                try {
                    compiledpatterns.add(this.m_compiler.compile(pattern));
                }
                catch (MalformedPatternException e) {
                    log.debug((Object)("Malformed spam filter pattern " + pattern));
                    source.setAttribute("error", "Malformed spam filter pattern " + pattern);
                }
            }
        }
        return compiledpatterns;
    }

    private Collection<Pattern> parseBlacklist(String list) {
        ArrayList<Pattern> compiledpatterns = new ArrayList<Pattern>();
        if (list != null) {
            try {
                String line;
                BufferedReader in = new BufferedReader(new StringReader(list));
                while ((line = in.readLine()) != null) {
                    if ((line = line.trim()).length() == 0 || line.startsWith("#")) continue;
                    int ws = line.indexOf(32);
                    if (ws == -1) {
                        ws = line.indexOf(9);
                    }
                    if (ws != -1) {
                        line = line.substring(0, ws);
                    }
                    try {
                        compiledpatterns.add(this.m_compiler.compile(line));
                    }
                    catch (MalformedPatternException e) {
                        log.debug((Object)("Malformed spam filter pattern " + line));
                    }
                }
            }
            catch (IOException e) {
                log.info((Object)"Could not read patterns; returning what I got", (Throwable)e);
            }
        }
        return compiledpatterns;
    }

    private synchronized void checkSinglePageChange(WikiContext context, String content, Change change) throws RedirectException {
        HttpServletRequest req = context.getHttpRequest();
        if (req != null) {
            String uid;
            Host host;
            String addr = req.getRemoteAddr();
            int hostCounter = 0;
            int changeCounter = 0;
            log.debug((Object)("Change is " + change.m_change));
            long time = System.currentTimeMillis() - 60000L;
            Iterator<Host> i = this.m_lastModifications.iterator();
            while (i.hasNext()) {
                Host host2 = i.next();
                if (host2.getAddedTime() < time) {
                    log.debug((Object)("Removed host " + host2.getAddress() + " from modification queue (expired)"));
                    i.remove();
                    continue;
                }
                if (host2.getAddress().equals(addr)) {
                    ++hostCounter;
                }
                if (host2.getChange() == null || !host2.getChange().equals(change)) continue;
                ++changeCounter;
            }
            if (hostCounter >= this.m_limitSinglePageChanges) {
                host = new Host(addr, null);
                this.m_temporaryBanList.add(host);
                uid = SpamFilter.log(context, 0, REASON_TOO_MANY_MODIFICATIONS, change.m_change);
                log.info((Object)("SPAM:TooManyModifications (" + uid + "). Added host " + addr + " to temporary ban list for doing too many modifications/minute"));
                this.checkStrategy(context, REASON_TOO_MANY_MODIFICATIONS, "Herb says you look like a spammer, and I trust Herb! (Incident code " + uid + ")");
            }
            if (changeCounter >= this.m_limitSimilarChanges) {
                host = new Host(addr, null);
                this.m_temporaryBanList.add(host);
                uid = SpamFilter.log(context, 0, REASON_SIMILAR_MODIFICATIONS, change.m_change);
                log.info((Object)("SPAM:SimilarModifications (" + uid + "). Added host " + addr + " to temporary ban list for doing too many similar modifications"));
                this.checkStrategy(context, REASON_SIMILAR_MODIFICATIONS, "Herb says you look like a spammer, and I trust Herb! (Incident code " + uid + ")");
            }
            String tstChange = change.toString();
            int urlCounter = 0;
            while (this.m_matcher.contains(tstChange, this.m_urlPattern)) {
                MatchResult m = this.m_matcher.getMatch();
                tstChange = tstChange.substring(m.endOffset(0));
                ++urlCounter;
            }
            if (urlCounter > this.m_maxUrls) {
                Host host3 = new Host(addr, null);
                this.m_temporaryBanList.add(host3);
                String uid2 = SpamFilter.log(context, 0, REASON_TOO_MANY_URLS, change.toString());
                log.info((Object)("SPAM:TooManyUrls (" + uid2 + "). Added host " + addr + " to temporary ban list for adding too many URLs"));
                this.checkStrategy(context, REASON_TOO_MANY_URLS, "Herb says you look like a spammer, and I trust Herb! (Incident code " + uid2 + ")");
            }
            this.checkBotTrap(context, change);
            this.checkUTF8(context, change);
            this.checkAkismet(context, change);
            this.m_lastModifications.add(new Host(addr, change));
        }
    }

    private void checkAkismet(WikiContext context, Change change) throws RedirectException {
        if (this.m_akismetAPIKey != null) {
            if (this.m_akismet == null) {
                log.info((Object)"Initializing Akismet spam protection.");
                this.m_akismet = new Akismet(this.m_akismetAPIKey, context.getEngine().getBaseURL());
                if (!this.m_akismet.verifyAPIKey()) {
                    log.error((Object)"Akismet API key cannot be verified.  Please check your config.");
                    this.m_akismetAPIKey = null;
                    this.m_akismet = null;
                }
            }
            HttpServletRequest req = context.getHttpRequest();
            if (change.m_adds == 0 && change.m_removals > 0) {
                return;
            }
            if (req != null && this.m_akismet != null) {
                log.debug((Object)"Calling Akismet to check for spam...");
                StopWatch sw = new StopWatch();
                sw.start();
                String ipAddress = req.getRemoteAddr();
                String userAgent = req.getHeader("User-Agent");
                String referrer = req.getHeader("Referer");
                String permalink = context.getViewURL(context.getPage().getName());
                String commentType = context.getRequestContext().equals(WikiContext.COMMENT) ? "comment" : "edit";
                String commentAuthor = context.getCurrentUser().getName();
                String commentAuthorEmail = null;
                String commentAuthorURL = null;
                boolean isSpam = this.m_akismet.commentCheck(ipAddress, userAgent, referrer, permalink, commentType, commentAuthor, commentAuthorEmail, commentAuthorURL, change.toString(), null);
                sw.stop();
                log.debug((Object)("Akismet request done in: " + sw));
                if (isSpam) {
                    String uid = SpamFilter.log(context, 0, REASON_AKISMET, change.toString());
                    log.info((Object)("SPAM:Akismet (" + uid + "). Akismet thinks this change is spam; added host to temporary ban list."));
                    this.checkStrategy(context, REASON_AKISMET, "Akismet tells Herb you're a spammer, Herb trusts Akismet, and I trust Herb! (Incident code " + uid + ")");
                }
            }
        }
    }

    public static String getBotFieldName() {
        return "submit_auth";
    }

    private void checkBotTrap(WikiContext context, Change change) throws RedirectException {
        String unspam;
        HttpServletRequest request = context.getHttpRequest();
        if (request != null && (unspam = request.getParameter(SpamFilter.getBotFieldName())) != null && unspam.length() > 0) {
            String uid = SpamFilter.log(context, 0, REASON_BOT_TRAP, change.toString());
            log.info((Object)("SPAM:BotTrap (" + uid + ").  Wildly behaving bot detected."));
            this.checkStrategy(context, REASON_BOT_TRAP, "Spamming attempt detected. (Incident code " + uid + ")");
        }
    }

    private void checkUTF8(WikiContext context, Change change) throws RedirectException {
        String utf8field;
        HttpServletRequest request = context.getHttpRequest();
        if (request != null && (utf8field = request.getParameter("encodingcheck")) != null && !utf8field.equals("\u3041")) {
            String uid = SpamFilter.log(context, 0, REASON_UTF8_TRAP, change.toString());
            log.info((Object)("SPAM:UTF8Trap (" + uid + ").  Wildly posting dumb bot detected."));
            this.checkStrategy(context, REASON_UTF8_TRAP, "Spamming attempt detected. (Incident code " + uid + ")");
        }
    }

    private synchronized void cleanBanList() {
        long now = System.currentTimeMillis();
        Iterator<Host> i = this.m_temporaryBanList.iterator();
        while (i.hasNext()) {
            Host host = i.next();
            if (host.getReleaseTime() >= now) continue;
            log.debug((Object)("Removed host " + host.getAddress() + " from temporary ban list (expired)"));
            i.remove();
        }
    }

    private void checkBanList(WikiContext context, Change change) throws RedirectException {
        HttpServletRequest req = context.getHttpRequest();
        if (req != null) {
            String remote = req.getRemoteAddr();
            long now = System.currentTimeMillis();
            for (Host host : this.m_temporaryBanList) {
                if (!host.getAddress().equals(remote)) continue;
                long timeleft = (host.getReleaseTime() - now) / 1000L;
                SpamFilter.log(context, 0, REASON_IP_BANNED_TEMPORARILY, change.m_change);
                this.checkStrategy(context, REASON_IP_BANNED_TEMPORARILY, "You have been temporarily banned from modifying this wiki. (" + timeleft + " seconds of ban left)");
            }
        }
    }

    private void refreshBlacklists(WikiContext context) {
        try {
            WikiPage source = context.getEngine().getPage(this.m_forbiddenWordsPage);
            Attachment att = context.getEngine().getAttachmentManager().getAttachmentInfo(context, this.m_blacklist);
            boolean rebuild = false;
            if (source != null && (this.m_spamPatterns == null || this.m_spamPatterns.isEmpty() || source.getLastModified().after(this.m_lastRebuild))) {
                rebuild = true;
            }
            if (att != null && (this.m_spamPatterns == null || this.m_spamPatterns.isEmpty() || att.getLastModified().after(this.m_lastRebuild))) {
                rebuild = true;
            }
            if (rebuild) {
                this.m_lastRebuild = new Date();
                this.m_spamPatterns = this.parseWordList(source, source != null ? (String)source.getAttribute(LISTVAR) : null);
                log.info((Object)("Spam filter reloaded - recognizing " + this.m_spamPatterns.size() + " patterns from page " + this.m_forbiddenWordsPage));
                if (att != null) {
                    InputStream in = context.getEngine().getAttachmentManager().getAttachmentStream(att);
                    StringWriter out = new StringWriter();
                    FileUtil.copyContents(new InputStreamReader(in, "UTF-8"), out);
                    Collection<Pattern> blackList = this.parseBlacklist(out.toString());
                    log.info((Object)("...recognizing additional " + blackList.size() + " patterns from blacklist " + this.m_blacklist));
                    this.m_spamPatterns.addAll(blackList);
                }
            }
        }
        catch (IOException ex) {
            log.info((Object)"Unable to read attachment data, continuing...", (Throwable)ex);
        }
        catch (ProviderException ex) {
            log.info((Object)"Failed to read spam filter attachment, continuing...", (Throwable)ex);
        }
    }

    private void checkPatternList(WikiContext context, String content, Change change) throws RedirectException {
        if (this.m_spamPatterns == null || context.getPage().getName().equals(this.m_forbiddenWordsPage)) {
            return;
        }
        String ch = change.toString();
        if (context.getHttpRequest() != null) {
            ch = ch + context.getHttpRequest().getRemoteAddr();
        }
        for (Pattern p : this.m_spamPatterns) {
            if (!this.m_matcher.contains(ch, p)) continue;
            String uid = SpamFilter.log(context, 0, "Regexp(" + p.getPattern() + ")", ch);
            log.info((Object)("SPAM:Regexp (" + uid + "). Content matches the spam filter '" + p.getPattern() + "'"));
            this.checkStrategy(context, REASON_REGEXP, "Herb says '" + p.getPattern() + "' is a bad spam word and I trust Herb! (Incident code " + uid + ")");
        }
    }

    private void checkPatternList(WikiContext context, String content, String change) throws RedirectException {
        Change c = new Change();
        c.m_change = change;
        this.checkPatternList(context, content, c);
    }

    private static Change getChange(WikiContext context, String newText) {
        WikiPage page = context.getPage();
        StringBuffer change = new StringBuffer();
        WikiEngine engine = context.getEngine();
        Change ch = new Change();
        try {
            String oldText = engine.getPureText(page.getName(), -1);
            Object[] first = Diff.stringToArray((String)oldText);
            Object[] second = Diff.stringToArray((String)newText);
            Revision rev = Diff.diff((Object[])first, (Object[])second, (DiffAlgorithm)new MyersDiff());
            if (rev == null || rev.size() == 0) {
                return ch;
            }
            for (int i = 0; i < rev.size(); ++i) {
                Delta d = rev.getDelta(i);
                if (d instanceof AddDelta) {
                    d.getRevised().toString(change, "", "\r\n");
                    ++ch.m_adds;
                    continue;
                }
                if (d instanceof ChangeDelta) {
                    d.getRevised().toString(change, "", "\r\n");
                    ++ch.m_adds;
                    continue;
                }
                if (!(d instanceof DeleteDelta)) continue;
                ++ch.m_removals;
            }
        }
        catch (DifferentiationFailedException e) {
            log.error((Object)"Diff failed", (Throwable)e);
        }
        String changeNote = (String)page.getAttribute("changenote");
        if (changeNote != null) {
            change.append("\r\n");
            change.append(changeNote);
        }
        if (page.getAuthor() != null) {
            change.append("\r\n" + page.getAuthor());
        }
        ch.m_change = change.toString();
        return ch;
    }

    private boolean ignoreThisUser(WikiContext context) {
        if (context.hasAdminPermissions()) {
            return true;
        }
        if (this.m_ignoreAuthenticated && context.getWikiSession().isAuthenticated()) {
            return true;
        }
        return context.getVariable(PROP_CAPTCHA) != null;
    }

    private static String getUniqueID() {
        StringBuffer sb = new StringBuffer();
        Random rand = new Random();
        for (int i = 0; i < 6; ++i) {
            char x = (char)(65 + rand.nextInt(26));
            sb.append(x);
        }
        return sb.toString();
    }

    private String getRedirectPage(WikiContext ctx) {
        if (this.m_useCaptcha) {
            return ctx.getURL(WikiContext.NONE, "Captcha.jsp", "page=" + ctx.getEngine().encodeName(ctx.getPage().getName()));
        }
        return ctx.getURL(WikiContext.VIEW, this.m_errorPage);
    }

    public boolean isValidUserProfile(WikiContext context, UserProfile profile) {
        try {
            this.checkPatternList(context, profile.getEmail(), profile.getEmail());
            this.checkPatternList(context, profile.getFullname(), profile.getFullname());
            this.checkPatternList(context, profile.getLoginName(), profile.getLoginName());
        }
        catch (RedirectException e) {
            log.info((Object)"Detected attempt to create a spammer user account (see above for rejection reason)");
            return false;
        }
        return true;
    }

    public static final String getSpamHash(WikiPage page, HttpServletRequest request) {
        long lastModified = 0L;
        if (page.getLastModified() != null) {
            lastModified = page.getLastModified().getTime();
        }
        long remote = request.getRemoteAddr().hashCode();
        return Long.toString(lastModified ^ remote);
    }

    public static final String getHashFieldName(HttpServletRequest request) {
        String hash = null;
        if (request.getSession() != null && (hash = (String)request.getSession().getAttribute("_hash")) == null) {
            hash = c_hashName;
            request.getSession().setAttribute("_hash", (Object)hash);
        }
        if (c_hashName == null || c_lastUpdate < System.currentTimeMillis() - 86400000L) {
            c_hashName = SpamFilter.getUniqueID().toLowerCase();
            c_lastUpdate = System.currentTimeMillis();
        }
        return hash != null ? hash : c_hashName;
    }

    public static final boolean checkHash(WikiContext context, PageContext pageContext) throws IOException {
        String hashName = SpamFilter.getHashFieldName((HttpServletRequest)pageContext.getRequest());
        if (pageContext.getRequest().getParameter(hashName) == null && pageContext.getAttribute(hashName) == null) {
            Change change = SpamFilter.getChange(context, EditorManager.getEditedText(pageContext));
            SpamFilter.log(context, 0, "MissingHash", change.m_change);
            String redirect = context.getURL(WikiContext.VIEW, "SessionExpired");
            ((HttpServletResponse)pageContext.getResponse()).sendRedirect(redirect);
            return false;
        }
        return true;
    }

    public static final String insertInputFields(PageContext pageContext) {
        WikiContext ctx = WikiContext.findContext(pageContext);
        WikiEngine engine = ctx.getEngine();
        StringBuffer sb = new StringBuffer();
        if (engine.getContentEncoding().equals("UTF-8")) {
            sb.append("<input name='encodingcheck' type='hidden' value='\u3041' />\n");
        }
        return sb.toString();
    }

    private static class Change {
        public String m_change;
        public int m_adds;
        public int m_removals;

        private Change() {
        }

        public String toString() {
            return this.m_change;
        }

        public boolean equals(Object o) {
            if (o instanceof Change) {
                return this.m_change.equals(((Change)o).m_change);
            }
            return false;
        }

        public int hashCode() {
            return this.m_change.hashCode() + 17;
        }
    }

    private class Host {
        private long m_addedTime = System.currentTimeMillis();
        private long m_releaseTime;
        private String m_address;
        private Change m_change;

        public String getAddress() {
            return this.m_address;
        }

        public long getReleaseTime() {
            return this.m_releaseTime;
        }

        public long getAddedTime() {
            return this.m_addedTime;
        }

        public Change getChange() {
            return this.m_change;
        }

        public Host(String ipaddress, Change change) {
            this.m_address = ipaddress;
            this.m_change = change;
            this.m_releaseTime = System.currentTimeMillis() + (long)(SpamFilter.this.m_banTime * 60) * 1000L;
        }
    }
}

