/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.pacl.checker;

import com.liferay.portal.bean.BeanLocatorImpl;
import com.liferay.portal.dao.orm.hibernate.DynamicQueryFactoryImpl;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletClassLoaderUtil;
import com.liferay.portal.kernel.security.pacl.permission.PortalRuntimePermission;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.pacl.Reflection;
import com.liferay.portal.security.pacl.checker.AuthorizationProperty;
import com.liferay.portal.security.pacl.checker.BaseChecker;
import com.liferay.portal.service.BaseLocalServiceImpl;
import com.liferay.portal.service.BaseServiceImpl;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.template.TemplateContextHelper;
import java.lang.reflect.Modifier;
import java.security.Permission;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PortalRuntimeChecker
extends BaseChecker {
    private static final String _PORTAL_SERVLET_CONTEXT_NAME = "portal";
    private static Log _log = LogFactoryUtil.getLog(PortalRuntimeChecker.class);
    private Set<String> _classLoaderReferenceIds;
    private Set<String> _expandoBridgeClassNames;
    private Map<String, Set<String>> _getBeanPropertyClassNames = new HashMap<String, Set<String>>();
    private List<Pattern> _portletBagPoolPortletIdPatterns;
    private Set<String> _searchEngineIds;
    private Map<String, Set<String>> _setBeanPropertyClassNames = new HashMap<String, Set<String>>();
    private List<Pattern> _threadPoolExecutorNamePatterns;

    @Override
    public void afterPropertiesSet() {
        this.initClassLoaderReferenceIds();
        this.initExpandoBridgeClassNames();
        this.initGetBeanPropertyClassNames();
        this.initPortletBagPoolPortletIds();
        this.initSearchEngineIds();
        this.initSetBeanPropertyClassNames();
        this.initThreadPoolExecutorNames();
    }

    @Override
    public AuthorizationProperty generateAuthorizationProperty(Object ... arguments) {
        StringBundler sb;
        if (arguments == null || arguments.length != 1 || !(arguments[0] instanceof Permission)) {
            return null;
        }
        PortalRuntimePermission portalRuntimePermission = (PortalRuntimePermission)arguments[0];
        String name = portalRuntimePermission.getShortName();
        String servletContextName = portalRuntimePermission.getServletContextName();
        String subject = portalRuntimePermission.getSubject();
        String property = portalRuntimePermission.getProperty();
        String key = null;
        String value = subject;
        if (name.startsWith("getClassLoader")) {
            key = "security-manager-class-loader-reference-ids";
        } else if (name.equals("expandoBridge")) {
            key = "security-manager-expando-bridge";
        } else if (name.equals("getBeanProperty")) {
            sb = new StringBundler(4);
            sb.append("security-manager-get-bean-property");
            sb.append("[");
            sb.append(servletContextName);
            sb.append("]");
            key = sb.toString();
            if (Validator.isNotNull((String)property)) {
                value = String.valueOf(value) + "#" + property;
            }
        } else if (name.equals("portletBagPool")) {
            key = "security-manager-portlet-bag-pool-portlet-ids";
        } else if (name.equals("searchEngine")) {
            key = "security-manager-search-engine-ids";
        } else if (name.equals("setBeanProperty")) {
            sb = new StringBundler(4);
            sb.append("security-manager-set-bean-property");
            sb.append("[");
            sb.append(servletContextName);
            sb.append("]");
            key = sb.toString();
            if (Validator.isNotNull((String)property)) {
                value = String.valueOf(value) + "#" + property;
            }
        } else if (name.equals("threadPoolExecutor")) {
            key = "security-manager-thread-pool-executor-names";
        } else {
            return null;
        }
        AuthorizationProperty authorizationProperty = new AuthorizationProperty();
        authorizationProperty.setKey(key);
        authorizationProperty.setValue(value);
        return authorizationProperty;
    }

    @Override
    public boolean implies(Permission permission) {
        PortalRuntimePermission portalRuntimePermission = (PortalRuntimePermission)permission;
        String name = portalRuntimePermission.getShortName();
        String subject = portalRuntimePermission.getSubject();
        String servletContextName = portalRuntimePermission.getServletContextName();
        String property = GetterUtil.getString((String)portalRuntimePermission.getProperty());
        if (name.equals("expandoBridge")) {
            if (!this._expandoBridgeClassNames.contains(subject)) {
                this.logSecurityException(_log, "Attempted to get Expando bridge on " + subject);
                return false;
            }
        } else if (name.equals("getBeanProperty")) {
            if (!this.hasGetBeanProperty(servletContextName, subject, property, permission)) {
                if (Validator.isNotNull((String)property)) {
                    this.logSecurityException(_log, "Attempted to get bean property " + property + " on " + subject + " from " + servletContextName);
                } else {
                    this.logSecurityException(_log, "Attempted to get bean property on " + subject + " from " + servletContextName);
                }
                return false;
            }
        } else if (name.startsWith("getClassLoader")) {
            if (!this.hasGetClassLoader(subject, permission)) {
                this.logSecurityException(_log, "Attempted to get class loader " + subject);
                return false;
            }
        } else if (name.equals("portletBagPool")) {
            if (!this.hasPortletBagPoolPortletId(subject)) {
                this.logSecurityException(_log, "Attempted to handle portlet bag pool portlet ID " + subject);
                return false;
            }
        } else if (name.equals("searchEngine")) {
            if (!this._searchEngineIds.contains(subject)) {
                this.logSecurityException(_log, "Attempted to get search engine " + subject);
                return false;
            }
        } else if (name.equals("setBeanProperty")) {
            if (!this.hasSetBeanProperty(servletContextName, subject, property)) {
                if (Validator.isNotNull((String)property)) {
                    this.logSecurityException(_log, "Attempted to set bean property " + property + " on " + subject + " from " + servletContextName);
                } else {
                    this.logSecurityException(_log, "Attempted to set bean property on " + subject + " from " + servletContextName);
                }
                return false;
            }
        } else if (name.equals("threadPoolExecutor") && !this.hasThreadPoolExecutorNames(subject)) {
            this.logSecurityException(_log, "Attempted to modify thread pool executor " + subject);
            return false;
        }
        return true;
    }

    protected boolean hasGetBeanProperty(String servletContextName, String className, String property, Permission permission) {
        Set<String> getBeanPropertyClassNames;
        if (servletContextName.equals(this.getServletContextName())) {
            return true;
        }
        int stackIndex = Reflection.getStackIndex(13, 12);
        Class<?> callerClass = Reflection.getCallerClass(stackIndex);
        if (this.isTrustedCaller(callerClass, permission)) {
            ++stackIndex;
            if (callerClass.equals(BeanLocatorImpl.class)) {
                stackIndex += 2;
            }
            if (!(callerClass = Reflection.getCallerClass(stackIndex)).equals(TemplateContextHelper.class) && this.isTrustedCaller(callerClass, permission)) {
                return true;
            }
        }
        if ((getBeanPropertyClassNames = this._getBeanPropertyClassNames.get(servletContextName)) == null) {
            return false;
        }
        if (getBeanPropertyClassNames.contains(className)) {
            return true;
        }
        return Validator.isNotNull((String)property) && getBeanPropertyClassNames.contains(className.concat("#").concat(property));
    }

    protected boolean hasGetClassLoader(String classLoaderReferenceId, Permission permission) {
        int stackIndex = Reflection.getStackIndex(12, 11);
        if (this._classLoaderReferenceIds.contains(classLoaderReferenceId)) {
            return true;
        }
        Class<?> callerClass = Reflection.getCallerClass(stackIndex);
        String callerClassName = callerClass.getName();
        if (callerClassName.equals(PortalClassLoaderUtil.class.getName()) || callerClassName.equals(PortletClassLoaderUtil.class.getName())) {
            callerClass = Reflection.getCallerClass(stackIndex + 1);
        } else if (callerClassName.equals(DynamicQueryFactoryImpl.class.getName())) {
            callerClass = Reflection.getCallerClass(stackIndex + 3);
        }
        if (this.isTrustedCaller(callerClass, permission)) {
            return true;
        }
        Class<?> superClass = callerClass.getSuperclass();
        return Modifier.isAbstract(callerClass.getModifiers()) && (superClass.equals(BaseLocalServiceImpl.class) || superClass.equals(BasePersistenceImpl.class) || superClass.equals(BaseServiceImpl.class));
    }

    protected boolean hasPortletBagPoolPortletId(String portletId) {
        for (Pattern portletBagPoolPortletIdPattern : this._portletBagPoolPortletIdPatterns) {
            Matcher matcher = portletBagPoolPortletIdPattern.matcher(portletId);
            if (!matcher.matches()) continue;
            return true;
        }
        return false;
    }

    protected boolean hasSetBeanProperty(String servletContextName, String className, String property) {
        if (servletContextName.equals(this.getServletContextName())) {
            return true;
        }
        Set<String> setBeanPropertyClassNames = this._setBeanPropertyClassNames.get(servletContextName);
        if (setBeanPropertyClassNames == null) {
            return false;
        }
        if (setBeanPropertyClassNames.contains(className)) {
            return true;
        }
        return Validator.isNotNull((String)property) && setBeanPropertyClassNames.contains(className.concat("#").concat(property));
    }

    protected boolean hasThreadPoolExecutorNames(String threadPoolExecutorName) {
        for (Pattern threadPoolExecutorNamePattern : this._threadPoolExecutorNamePatterns) {
            Matcher matcher = threadPoolExecutorNamePattern.matcher(threadPoolExecutorName);
            if (!matcher.matches()) continue;
            return true;
        }
        return false;
    }

    protected void initClassLoaderReferenceIds() {
        this._classLoaderReferenceIds = this.getPropertySet("security-manager-class-loader-reference-ids");
        if (_log.isDebugEnabled()) {
            TreeSet<String> classLoaderReferenceIds = new TreeSet<String>(this._classLoaderReferenceIds);
            for (String classLoaderReferenceId : classLoaderReferenceIds) {
                _log.debug((Object)("Allowing access to class loader for reference " + classLoaderReferenceId));
            }
        }
    }

    protected void initExpandoBridgeClassNames() {
        this._expandoBridgeClassNames = this.getPropertySet("security-manager-expando-bridge");
        if (_log.isDebugEnabled()) {
            TreeSet<String> classNames = new TreeSet<String>(this._expandoBridgeClassNames);
            for (String className : classNames) {
                _log.debug((Object)("Allowing Expando bridge on class " + className));
            }
        }
    }

    protected void initGetBeanPropertyClassNames() {
        Properties properties = this.getProperties();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!key.startsWith("security-manager-get-bean-property[")) continue;
            int x = key.indexOf("[");
            int y = key.indexOf("]", x);
            String servletContextName = key.substring(x + 1, y);
            Set getBeanPropertyClassNames = SetUtil.fromArray((Object[])StringUtil.split((String)value));
            this._getBeanPropertyClassNames.put(servletContextName, getBeanPropertyClassNames);
            if (!_log.isDebugEnabled() || servletContextName.equals(_PORTAL_SERVLET_CONTEXT_NAME)) continue;
            TreeSet classNames = new TreeSet(getBeanPropertyClassNames);
            for (String className : classNames) {
                _log.debug((Object)("Allowing get bean property from " + servletContextName + " on class " + className));
            }
        }
        Set<String> getBeanPropertyClassNames = this._getBeanPropertyClassNames.get(_PORTAL_SERVLET_CONTEXT_NAME);
        if (getBeanPropertyClassNames == null) {
            getBeanPropertyClassNames = this.getPropertySet("security-manager-get-bean-property");
        } else {
            getBeanPropertyClassNames.addAll(this.getPropertySet("security-manager-get-bean-property"));
        }
        this._getBeanPropertyClassNames.put(_PORTAL_SERVLET_CONTEXT_NAME, getBeanPropertyClassNames);
        if (_log.isDebugEnabled()) {
            TreeSet<String> classNames = new TreeSet<String>(getBeanPropertyClassNames);
            for (String className : classNames) {
                _log.debug((Object)("Allowing get bean property from portal on class " + className));
            }
        }
    }

    protected void initPortletBagPoolPortletIds() {
        Set<String> portletBagPoolPortletIds = this.getPropertySet("security-manager-portlet-bag-pool-portlet-ids");
        this._portletBagPoolPortletIdPatterns = new ArrayList<Pattern>(portletBagPoolPortletIds.size());
        for (String portletBagPoolPortletId : portletBagPoolPortletIds) {
            Pattern portletBagPoolPortletIdPattern = Pattern.compile(portletBagPoolPortletId);
            this._portletBagPoolPortletIdPatterns.add(portletBagPoolPortletIdPattern);
            if (!_log.isDebugEnabled()) continue;
            _log.debug((Object)("Allowing portlet bag pool portlet IDs that match the regular expression " + portletBagPoolPortletId));
        }
    }

    protected void initSearchEngineIds() {
        this._searchEngineIds = this.getPropertySet("security-manager-search-engine-ids");
        if (_log.isDebugEnabled()) {
            TreeSet<String> searchEngineIds = new TreeSet<String>(this._searchEngineIds);
            for (String searchEngineId : searchEngineIds) {
                _log.debug((Object)("Allowing search engine " + searchEngineId));
            }
        }
    }

    protected void initSetBeanPropertyClassNames() {
        Properties properties = this.getProperties();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!key.startsWith("security-manager-set-bean-property[")) continue;
            int x = key.indexOf("[");
            int y = key.indexOf("]", x);
            String servletContextName = key.substring(x + 1, y);
            Set setBeanPropertyClassNames = SetUtil.fromArray((Object[])StringUtil.split((String)value));
            this._setBeanPropertyClassNames.put(servletContextName, setBeanPropertyClassNames);
            if (!_log.isDebugEnabled() || servletContextName.equals(_PORTAL_SERVLET_CONTEXT_NAME)) continue;
            TreeSet classNames = new TreeSet(setBeanPropertyClassNames);
            for (String className : classNames) {
                _log.debug((Object)("Allowing set bean property from " + servletContextName + " on class " + className));
            }
        }
        Set<String> setBeanPropertyClassNames = this._setBeanPropertyClassNames.get(_PORTAL_SERVLET_CONTEXT_NAME);
        if (setBeanPropertyClassNames == null) {
            setBeanPropertyClassNames = this.getPropertySet("security-manager-set-bean-property");
        } else {
            setBeanPropertyClassNames.addAll(this.getPropertySet("security-manager-set-bean-property"));
        }
        this._setBeanPropertyClassNames.put(_PORTAL_SERVLET_CONTEXT_NAME, setBeanPropertyClassNames);
        if (_log.isDebugEnabled()) {
            TreeSet<String> classNames = new TreeSet<String>(setBeanPropertyClassNames);
            for (String className : classNames) {
                _log.debug((Object)("Allowing set bean property from portal on class " + className));
            }
        }
    }

    protected void initThreadPoolExecutorNames() {
        Set<String> threadPoolExecutorNames = this.getPropertySet("security-manager-thread-pool-executor-names");
        this._threadPoolExecutorNamePatterns = new ArrayList<Pattern>(threadPoolExecutorNames.size());
        for (String threadPoolExecutorName : threadPoolExecutorNames) {
            Pattern threadPoolExecutorNamePattern = Pattern.compile(threadPoolExecutorName);
            this._threadPoolExecutorNamePatterns.add(threadPoolExecutorNamePattern);
            if (!_log.isDebugEnabled()) continue;
            _log.debug((Object)("Allowing thread pool executors that match the regular expression " + threadPoolExecutorName));
        }
    }
}

