/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.sourceformatter;

import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.sourceformatter.ImportPackage;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ImportPackageFactoryUtil {
    private static final Pattern _javaImportPattern = Pattern.compile("import ([^\\s;]+)");
    private static final Pattern _jspImportPattern = Pattern.compile("import=\"([^\\s\"]+)\"");

    public static ImportPackage create(String line) {
        if (Validator.isNull((String)line)) {
            return null;
        }
        Matcher javaMatcher = _javaImportPattern.matcher(line);
        if (javaMatcher.find()) {
            return new ImportPackage(javaMatcher.group(1), line);
        }
        Matcher jspMatcher = _jspImportPattern.matcher(line);
        if (jspMatcher.find()) {
            return new ImportPackage(jspMatcher.group(1), line);
        }
        return null;
    }
}

