/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.layoutconfiguration.util.xml;

import com.liferay.portal.kernel.portlet.PortletContainerUtil;
import com.liferay.portal.kernel.portlet.PortletLayoutListener;
import com.liferay.portal.kernel.portlet.PortletParameterUtil;
import com.liferay.portal.kernel.servlet.BufferCacheServletResponse;
import com.liferay.portal.kernel.servlet.DynamicServletRequest;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.PredicateFilter;
import com.liferay.portal.kernel.util.PrefixPredicateFilter;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.layoutconfiguration.util.xml.RuntimeLogic;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.PortletConstants;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.service.PortletPreferencesLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PortletLogic
extends RuntimeLogic {
    public static final String CLOSE_1_TAG = "</runtime-portlet>";
    public static final String CLOSE_2_TAG = "/>";
    public static final String OPEN_TAG = "<runtime-portlet";
    private HttpServletRequest _request;
    private HttpServletResponse _response;

    public PortletLogic(HttpServletRequest request, HttpServletResponse response) {
        this._request = request;
        this._response = response;
    }

    public String getClose1Tag() {
        return CLOSE_1_TAG;
    }

    public String getOpenTag() {
        return OPEN_TAG;
    }

    public String processXML(String xml) throws Exception {
        Document document = SAXReaderUtil.read((String)xml);
        Element rootElement = document.getRootElement();
        String portletId = rootElement.attributeValue("name");
        String instanceId = rootElement.attributeValue("instance");
        String queryString = rootElement.attributeValue("queryString");
        if (Validator.isNotNull((String)instanceId)) {
            portletId = PortletConstants.assemblePortletId((String)portletId, (String)instanceId);
        }
        BufferCacheServletResponse bufferCacheServletResponse = new BufferCacheServletResponse(this._response);
        queryString = PortletParameterUtil.addNamespace((String)portletId, (String)queryString);
        Map parameterMap = this._request.getParameterMap();
        if (!portletId.equals(this._request.getParameter("p_p_id"))) {
            parameterMap = MapUtil.filter((Map)parameterMap, new HashMap(), (PredicateFilter)new PrefixPredicateFilter("p_p_"));
        }
        HttpServletRequest request = DynamicServletRequest.addQueryString((HttpServletRequest)this._request, (Map)parameterMap, (String)queryString, (boolean)false);
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Portlet portlet = this.getPortlet(themeDisplay, portletId);
        PortletContainerUtil.render((HttpServletRequest)request, (HttpServletResponse)bufferCacheServletResponse, (Portlet)portlet);
        return bufferCacheServletResponse.getString();
    }

    protected Portlet getPortlet(ThemeDisplay themeDisplay, String portletId) throws Exception {
        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)themeDisplay.getCompanyId(), (String)portletId);
        if (PortletPreferencesLocalServiceUtil.getPortletPreferencesCount((int)3, (long)themeDisplay.getPlid(), (String)portletId) < 1L) {
            PortletPreferencesFactoryUtil.getPortletSetup((HttpServletRequest)this._request, (String)portletId);
            PortletLayoutListener portletLayoutListener = portlet.getPortletLayoutListenerInstance();
            if (portletLayoutListener != null) {
                portletLayoutListener.onAddToLayout(portletId, themeDisplay.getPlid());
            }
        }
        if (!portlet.isInstanceable()) {
            portlet = (Portlet)portlet.clone();
        }
        portlet.setStatic(true);
        return portlet;
    }
}

