/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.facets.data;

import com.browseengine.bobo.facets.data.TermNumberList;
import it.unimi.dsi.fastutil.shorts.ShortArrayList;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;

public class TermShortList
extends TermNumberList<Short> {
    private static Logger log = Logger.getLogger(TermShortList.class);
    private short[] _elements = null;
    private short sanity = (short)-1;
    private boolean withDummy = true;
    public static final short VALUE_MISSING = Short.MIN_VALUE;

    private static short parse(String s) {
        if (s == null || s.length() == 0) {
            return 0;
        }
        return Short.parseShort(s);
    }

    public TermShortList() {
    }

    public TermShortList(String formatString) {
        super(formatString);
    }

    public TermShortList(int capacity, String formatString) {
        super(capacity, formatString);
    }

    @Override
    public boolean add(String o) {
        if (this._innerList.size() == 0 && o != null) {
            this.withDummy = false;
        }
        short item = TermShortList.parse(o);
        return ((ShortArrayList)this._innerList).add(item);
    }

    @Override
    public void clear() {
        super.clear();
    }

    @Override
    public String get(int index) {
        DecimalFormat formatter = (DecimalFormat)this._formatter.get();
        if (formatter == null) {
            return String.valueOf(this._elements[index]);
        }
        return formatter.format(this._elements[index]);
    }

    public short getPrimitiveValue(int index) {
        if (index < this._elements.length) {
            return this._elements[index];
        }
        return Short.MIN_VALUE;
    }

    @Override
    protected List<?> buildPrimitiveList(int capacity) {
        this._type = Short.class;
        return capacity > 0 ? new ShortArrayList(capacity) : new ShortArrayList();
    }

    @Override
    public int indexOf(Object o) {
        if (this.withDummy) {
            if (o == null) {
                return -1;
            }
            short val = o instanceof String ? TermShortList.parse((String)o) : (Short)o;
            return Arrays.binarySearch(this._elements, 1, this._elements.length, val);
        }
        short val = o instanceof String ? TermShortList.parse((String)o) : (Short)o;
        return Arrays.binarySearch(this._elements, val);
    }

    public int indexOf(Short val) {
        if (this.withDummy) {
            if (val == null) {
                return -1;
            }
            return Arrays.binarySearch(this._elements, 1, this._elements.length, val);
        }
        return Arrays.binarySearch(this._elements, val);
    }

    public int indexOf(short val) {
        if (this.withDummy) {
            return Arrays.binarySearch(this._elements, 1, this._elements.length, val);
        }
        return Arrays.binarySearch(this._elements, val);
    }

    @Override
    public int indexOfWithType(Short val) {
        if (this.withDummy) {
            if (val == null) {
                return -1;
            }
            return Arrays.binarySearch(this._elements, 1, this._elements.length, val);
        }
        return Arrays.binarySearch(this._elements, val);
    }

    @Override
    public int indexOfWithType(short val) {
        if (this.withDummy) {
            return Arrays.binarySearch(this._elements, 1, this._elements.length, val);
        }
        return Arrays.binarySearch(this._elements, val);
    }

    @Override
    public void seal() {
        int negativeIndexCheck;
        ((ShortArrayList)this._innerList).trim();
        this._elements = ((ShortArrayList)this._innerList).elements();
        int n = negativeIndexCheck = this.withDummy ? 1 : 0;
        if (this._elements.length > negativeIndexCheck && this._elements[negativeIndexCheck] < 0) {
            int endPosition = this.indexOfWithType((short)0);
            if (endPosition < 0) {
                endPosition = -1 * endPosition - 1;
            }
            for (int i = 0; i < (endPosition - negativeIndexCheck) / 2; ++i) {
                short tmp = this._elements[i + negativeIndexCheck];
                this._elements[i + negativeIndexCheck] = this._elements[endPosition - i - 1];
                this._elements[endPosition - i - 1] = tmp;
            }
        }
    }

    @Override
    protected Object parseString(String o) {
        return TermShortList.parse(o);
    }

    public boolean contains(short val) {
        if (this.withDummy) {
            return Arrays.binarySearch(this._elements, 1, this._elements.length, val) >= 0;
        }
        return Arrays.binarySearch(this._elements, val) >= 0;
    }

    @Override
    public boolean containsWithType(Short val) {
        if (this.withDummy) {
            if (val == null) {
                return false;
            }
            return Arrays.binarySearch(this._elements, 1, this._elements.length, val) >= 0;
        }
        return Arrays.binarySearch(this._elements, val) >= 0;
    }

    @Override
    public boolean containsWithType(short val) {
        if (this.withDummy) {
            return Arrays.binarySearch(this._elements, 1, this._elements.length, val) >= 0;
        }
        return Arrays.binarySearch(this._elements, val) >= 0;
    }

    public short[] getElements() {
        return this._elements;
    }

    @Override
    public double getDoubleValue(int index) {
        return this._elements[index];
    }
}

