/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.helper;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetClassLoaderForClass;
import org.eclipse.persistence.internal.security.PrivilegedGetContextClassLoader;

public class ConversionManager
implements Serializable,
Cloneable {
    protected Map defaultNullValues;
    protected boolean shouldUseClassLoaderFromCurrentThread = false;
    protected static ConversionManager defaultManager;
    private static ClassLoader defaultLoader;
    protected ClassLoader loader;
    protected Hashtable dataTypesConvertedFromAClass = new Hashtable();
    protected Hashtable dataTypesConvertedToAClass = new Hashtable();

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException exception) {
            return null;
        }
    }

    public Object convertObject(Object sourceObject, Class javaClass) throws ConversionException {
        if (sourceObject == null) {
            if (javaClass != null) {
                return this.getDefaultNullValue(javaClass);
            }
            return null;
        }
        if (sourceObject.getClass() == javaClass || javaClass == null || javaClass == ClassConstants.OBJECT || javaClass == ClassConstants.BLOB || javaClass == ClassConstants.CLOB) {
            return sourceObject;
        }
        try {
            if (javaClass == ClassConstants.STRING) {
                return this.convertObjectToString(sourceObject);
            }
            if (javaClass == ClassConstants.UTILDATE) {
                return this.convertObjectToUtilDate(sourceObject);
            }
            if (javaClass == ClassConstants.SQLDATE) {
                return this.convertObjectToDate(sourceObject);
            }
            if (javaClass == ClassConstants.TIME) {
                return this.convertObjectToTime(sourceObject);
            }
            if (javaClass == ClassConstants.TIMESTAMP) {
                return this.convertObjectToTimestamp(sourceObject);
            }
            if (javaClass == ClassConstants.CALENDAR || javaClass == ClassConstants.GREGORIAN_CALENDAR) {
                return this.convertObjectToCalendar(sourceObject);
            }
            if (javaClass == ClassConstants.CHAR || javaClass == ClassConstants.PCHAR && !(sourceObject instanceof Character)) {
                return this.convertObjectToChar(sourceObject);
            }
            if (javaClass == ClassConstants.INTEGER || javaClass == ClassConstants.PINT && !(sourceObject instanceof Integer)) {
                return this.convertObjectToInteger(sourceObject);
            }
            if (javaClass == ClassConstants.DOUBLE || javaClass == ClassConstants.PDOUBLE && !(sourceObject instanceof Double)) {
                return this.convertObjectToDouble(sourceObject);
            }
            if (javaClass == ClassConstants.FLOAT || javaClass == ClassConstants.PFLOAT && !(sourceObject instanceof Float)) {
                return this.convertObjectToFloat(sourceObject);
            }
            if (javaClass == ClassConstants.LONG || javaClass == ClassConstants.PLONG && !(sourceObject instanceof Long)) {
                return this.convertObjectToLong(sourceObject);
            }
            if (javaClass == ClassConstants.SHORT || javaClass == ClassConstants.PSHORT && !(sourceObject instanceof Short)) {
                return this.convertObjectToShort(sourceObject);
            }
            if (javaClass == ClassConstants.BYTE || javaClass == ClassConstants.PBYTE && !(sourceObject instanceof Byte)) {
                return this.convertObjectToByte(sourceObject);
            }
            if (javaClass == ClassConstants.BIGINTEGER) {
                return this.convertObjectToBigInteger(sourceObject);
            }
            if (javaClass == ClassConstants.BIGDECIMAL) {
                return this.convertObjectToBigDecimal(sourceObject);
            }
            if (javaClass == ClassConstants.NUMBER) {
                return this.convertObjectToNumber(sourceObject);
            }
            if (javaClass == ClassConstants.BOOLEAN || javaClass == ClassConstants.PBOOLEAN && !(sourceObject instanceof Boolean)) {
                return this.convertObjectToBoolean(sourceObject);
            }
            if (javaClass == ClassConstants.APBYTE) {
                return this.convertObjectToByteArray(sourceObject);
            }
            if (javaClass == ClassConstants.ABYTE) {
                return this.convertObjectToByteObjectArray(sourceObject);
            }
            if (javaClass == ClassConstants.APCHAR) {
                return this.convertObjectToCharArray(sourceObject);
            }
            if (javaClass == ClassConstants.ACHAR) {
                return this.convertObjectToCharacterArray(sourceObject);
            }
            if (sourceObject.getClass() == ClassConstants.STRING && javaClass == ClassConstants.CLASS) {
                return this.convertObjectToClass(sourceObject);
            }
        }
        catch (ConversionException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw ConversionException.couldNotBeConverted(sourceObject, javaClass, e);
        }
        if (javaClass == ClassConstants.PBOOLEAN && sourceObject instanceof Boolean || javaClass == ClassConstants.PLONG && sourceObject instanceof Long || javaClass == ClassConstants.PINT && sourceObject instanceof Integer || javaClass == ClassConstants.PFLOAT && sourceObject instanceof Float || javaClass == ClassConstants.PDOUBLE && sourceObject instanceof Double || javaClass == ClassConstants.PBYTE && sourceObject instanceof Byte || javaClass == ClassConstants.PCHAR && sourceObject instanceof Character || javaClass == ClassConstants.PSHORT && sourceObject instanceof Short) {
            return sourceObject;
        }
        if (javaClass.isInstance(sourceObject)) {
            return sourceObject;
        }
        if (ClassConstants.NOCONVERSION.isAssignableFrom(javaClass)) {
            return sourceObject;
        }
        throw ConversionException.couldNotBeConverted(sourceObject, javaClass);
    }

    protected BigDecimal convertObjectToBigDecimal(Object sourceObject) throws ConversionException {
        BigDecimal bigDecimal;
        block5: {
            bigDecimal = null;
            try {
                if (sourceObject instanceof String) {
                    bigDecimal = new BigDecimal((String)sourceObject);
                    break block5;
                }
                if (sourceObject instanceof BigInteger) {
                    bigDecimal = new BigDecimal((BigInteger)sourceObject);
                    break block5;
                }
                if (sourceObject instanceof Number) {
                    String numberString = String.valueOf(sourceObject);
                    bigDecimal = numberString.endsWith(".0") || numberString.contains(".0E+") ? new BigDecimal(((Number)sourceObject).doubleValue()) : new BigDecimal(numberString);
                    break block5;
                }
                throw ConversionException.couldNotBeConverted(sourceObject, ClassConstants.BIGDECIMAL);
            }
            catch (NumberFormatException exception) {
                throw ConversionException.couldNotBeConverted(sourceObject, ClassConstants.BIGDECIMAL, exception);
            }
        }
        return bigDecimal;
    }

    protected BigInteger convertObjectToBigInteger(Object sourceObject) throws ConversionException {
        BigInteger bigInteger;
        block9: {
            bigInteger = null;
            try {
                if (sourceObject instanceof BigInteger) {
                    bigInteger = (BigInteger)sourceObject;
                    break block9;
                }
                if (sourceObject instanceof String) {
                    bigInteger = new BigInteger((String)sourceObject);
                    break block9;
                }
                if (sourceObject instanceof BigDecimal) {
                    bigInteger = ((BigDecimal)sourceObject).toBigInteger();
                    break block9;
                }
                if (sourceObject instanceof Number) {
                    bigInteger = new BigInteger(String.valueOf(((Number)sourceObject).longValue()));
                    break block9;
                }
                if (sourceObject instanceof Byte[]) {
                    Byte[] objectBytes = (Byte[])sourceObject;
                    byte[] bytes = new byte[objectBytes.length];
                    for (int index = 0; index < objectBytes.length; ++index) {
                        bytes[index] = objectBytes[index];
                    }
                    bigInteger = new BigInteger(bytes);
                    break block9;
                }
                if (sourceObject instanceof byte[]) {
                    bigInteger = new BigInteger((byte[])sourceObject);
                    break block9;
                }
                throw ConversionException.couldNotBeConverted(sourceObject, ClassConstants.BIGINTEGER);
            }
            catch (NumberFormatException exception) {
                throw ConversionException.couldNotBeConverted(sourceObject, ClassConstants.BIGINTEGER, exception);
            }
        }
        return bigInteger;
    }

    protected Boolean convertObjectToBoolean(Object sourceObject) {
        if (sourceObject instanceof Character) {
            switch (Character.toLowerCase(((Character)sourceObject).charValue())) {
                case '1': 
                case 't': {
                    return new Boolean(true);
                }
                case '0': 
                case 'f': {
                    return new Boolean(false);
                }
            }
        }
        if (sourceObject instanceof String) {
            String stringValue = ((String)sourceObject).toLowerCase();
            if (stringValue.equals("t") || stringValue.equals("true") || stringValue.equals("1")) {
                return new Boolean(true);
            }
            if (stringValue.equals("f") || stringValue.equals("false") || stringValue.equals("0")) {
                return new Boolean(false);
            }
        }
        if (sourceObject instanceof Number) {
            int intValue = ((Number)sourceObject).intValue();
            if (intValue != 0) {
                return new Boolean(true);
            }
            if (intValue == 0) {
                return new Boolean(false);
            }
        }
        throw ConversionException.couldNotBeConverted(sourceObject, ClassConstants.BOOLEAN);
    }

    protected Byte convertObjectToByte(Object sourceObject) throws ConversionException {
        try {
            if (sourceObject instanceof String) {
                return new Byte((String)sourceObject);
            }
            if (sourceObject instanceof Number) {
                return new Byte(((Number)sourceObject).byteValue());
            }
        }
        catch (NumberFormatException exception) {
            throw ConversionException.couldNotBeConverted(sourceObject, ClassConstants.BYTE, exception);
        }
        throw ConversionException.couldNotBeConverted(sourceObject, ClassConstants.BYTE);
    }

    protected byte[] convertObjectToByteArray(Object sourceObject) throws ConversionException {
        if (sourceObject instanceof byte[]) {
            return (byte[])sourceObject;
        }
        if (sourceObject instanceof Byte[]) {
            Byte[] objectBytes = (Byte[])sourceObject;
            byte[] bytes = new byte[objectBytes.length];
            for (int index = 0; index < objectBytes.length; ++index) {
                bytes[index] = objectBytes[index];
            }
            return bytes;
        }
        if (sourceObject instanceof String) {
            return Helper.buildBytesFromHexString((String)sourceObject);
        }
        if (sourceObject instanceof Blob) {
            Blob blob = (Blob)sourceObject;
            try {
                return blob.getBytes(1L, (int)blob.length());
            }
            catch (SQLException exception) {
                throw DatabaseException.sqlException(exception);
            }
        }
        if (sourceObject instanceof InputStream) {
            InputStream inputStream = (InputStream)sourceObject;
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            try {
                int tempInt = inputStream.read();
                while (tempInt != -1) {
                    outputStream.write(tempInt);
                    tempInt = inputStream.read();
                }
                return outputStream.toByteArray();
            }
            catch (IOException ioException) {
                throw ConversionException.couldNotBeConverted(sourceObject, ClassConstants.APBYTE, ioException);
            }
        }
        if (sourceObject instanceof BigInteger) {
            return ((BigInteger)sourceObject).toByteArray();
        }
        throw ConversionException.couldNotBeConverted(sourceObject, ClassConstants.APBYTE);
    }

    protected Byte[] convertObjectToByteObjectArray(Object sourceObject) throws ConversionException {
        byte[] bytes = this.convertObjectToByteArray(sourceObject);
        Byte[] objectBytes = new Byte[bytes.length];
        for (int index = 0; index < bytes.length; ++index) {
            objectBytes[index] = new Byte(bytes[index]);
        }
        return objectBytes;
    }

    protected Calendar convertObjectToCalendar(Object sourceObject) throws ConversionException {
        if (sourceObject instanceof Calendar) {
            return (Calendar)sourceObject;
        }
        if (sourceObject instanceof java.util.Date) {
            return Helper.calendarFromUtilDate((java.util.Date)sourceObject);
        }
        return Helper.calendarFromUtilDate(this.convertObjectToUtilDate(sourceObject));
    }

    protected Character convertObjectToChar(Object sourceObject) throws ConversionException {
        if (sourceObject instanceof String) {
            if (((String)sourceObject).length() < 1) {
                return null;
            }
            return new Character(((String)sourceObject).charAt(0));
        }
        if (sourceObject instanceof Number) {
            return new Character((char)((Number)sourceObject).byteValue());
        }
        throw ConversionException.couldNotBeConverted(sourceObject, ClassConstants.CHAR);
    }

    protected Character[] convertObjectToCharacterArray(Object sourceObject) throws ConversionException {
        String stringValue = this.convertObjectToString(sourceObject);
        Character[] chars = new Character[stringValue.length()];
        for (int index = 0; index < stringValue.length(); ++index) {
            chars[index] = new Character(stringValue.charAt(index));
        }
        return chars;
    }

    protected char[] convertObjectToCharArray(Object sourceObject) throws ConversionException {
        if (sourceObject instanceof Character[]) {
            Character[] objectChars = (Character[])sourceObject;
            char[] chars = new char[objectChars.length];
            for (int index = 0; index < objectChars.length; ++index) {
                chars[index] = objectChars[index].charValue();
            }
            return chars;
        }
        String stringValue = this.convertObjectToString(sourceObject);
        char[] chars = new char[stringValue.length()];
        for (int index = 0; index < stringValue.length(); ++index) {
            chars[index] = stringValue.charAt(index);
        }
        return chars;
    }

    protected Class convertObjectToClass(Object sourceObject) throws ConversionException {
        Class<?> theClass = null;
        if (!(sourceObject instanceof String)) {
            throw ConversionException.couldNotBeConverted(sourceObject, ClassConstants.CLASS);
        }
        try {
            theClass = ConversionManager.getPrimitiveClass((String)sourceObject);
            if (theClass == null) {
                theClass = Class.forName((String)sourceObject, true, this.getLoader());
            }
        }
        catch (Exception exception) {
            throw ConversionException.couldNotBeConvertedToClass(sourceObject, ClassConstants.CLASS, exception);
        }
        return theClass;
    }

    protected Date convertObjectToDate(Object sourceObject) throws ConversionException {
        Date date = null;
        if (sourceObject instanceof Date) {
            date = (Date)sourceObject;
        } else if (sourceObject instanceof Timestamp) {
            date = Helper.dateFromTimestamp((Timestamp)sourceObject);
        } else if (sourceObject.getClass() == ClassConstants.UTILDATE) {
            date = Helper.sqlDateFromUtilDate((java.util.Date)sourceObject);
        } else {
            if (sourceObject instanceof Calendar) {
                return Helper.dateFromCalendar((Calendar)sourceObject);
            }
            if (sourceObject instanceof String) {
                date = Helper.dateFromString((String)sourceObject);
            } else if (sourceObject instanceof Long) {
                date = Helper.dateFromLong((Long)sourceObject);
            } else {
                throw ConversionException.couldNotBeConverted(sourceObject, ClassConstants.SQLDATE);
            }
        }
        return date;
    }

    protected Double convertObjectToDouble(Object sourceObject) throws ConversionException {
        try {
            if (sourceObject instanceof String) {
                return new Double((String)sourceObject);
            }
            if (sourceObject instanceof Number) {
                return new Double(((Number)sourceObject).doubleValue());
            }
        }
        catch (NumberFormatException exception) {
            throw ConversionException.couldNotBeConverted(sourceObject, ClassConstants.DOUBLE, exception);
        }
        throw ConversionException.couldNotBeConverted(sourceObject, ClassConstants.DOUBLE);
    }

    protected Float convertObjectToFloat(Object sourceObject) throws ConversionException {
        try {
            if (sourceObject instanceof String) {
                return new Float((String)sourceObject);
            }
            if (sourceObject instanceof Number) {
                return new Float(((Number)sourceObject).floatValue());
            }
        }
        catch (NumberFormatException exception) {
            throw ConversionException.couldNotBeConverted(sourceObject, ClassConstants.FLOAT, exception);
        }
        throw ConversionException.couldNotBeConverted(sourceObject, ClassConstants.FLOAT);
    }

    protected Integer convertObjectToInteger(Object sourceObject) throws ConversionException {
        try {
            if (sourceObject instanceof String) {
                return new Integer((String)sourceObject);
            }
            if (sourceObject instanceof Number) {
                return new Integer(((Number)sourceObject).intValue());
            }
            if (sourceObject instanceof Boolean) {
                if (((Boolean)sourceObject).booleanValue()) {
                    return new Integer(1);
                }
                return new Integer(0);
            }
        }
        catch (NumberFormatException exception) {
            throw ConversionException.couldNotBeConverted(sourceObject, ClassConstants.INTEGER, exception);
        }
        throw ConversionException.couldNotBeConverted(sourceObject, ClassConstants.INTEGER);
    }

    protected Long convertObjectToLong(Object sourceObject) throws ConversionException {
        try {
            if (sourceObject instanceof String) {
                return new Long((String)sourceObject);
            }
            if (sourceObject instanceof Number) {
                return new Long(((Number)sourceObject).longValue());
            }
            if (sourceObject instanceof java.util.Date) {
                return new Long(((java.util.Date)sourceObject).getTime());
            }
            if (sourceObject instanceof Calendar) {
                return new Long(((Calendar)sourceObject).getTimeInMillis());
            }
            if (sourceObject instanceof Boolean) {
                if (((Boolean)sourceObject).booleanValue()) {
                    return new Long(1L);
                }
                return new Long(0L);
            }
        }
        catch (NumberFormatException exception) {
            throw ConversionException.couldNotBeConverted(sourceObject, ClassConstants.LONG, exception);
        }
        throw ConversionException.couldNotBeConverted(sourceObject, ClassConstants.LONG);
    }

    protected BigDecimal convertObjectToNumber(Object sourceObject) throws ConversionException {
        try {
            if (sourceObject instanceof String) {
                return new BigDecimal((String)sourceObject);
            }
            if (sourceObject instanceof Number) {
                return new BigDecimal(((Number)sourceObject).doubleValue());
            }
            if (sourceObject instanceof Boolean) {
                if (((Boolean)sourceObject).booleanValue()) {
                    return new BigDecimal(1);
                }
                return new BigDecimal(0);
            }
        }
        catch (NumberFormatException exception) {
            throw ConversionException.couldNotBeConverted(sourceObject, ClassConstants.NUMBER, exception);
        }
        throw ConversionException.couldNotBeConverted(sourceObject, ClassConstants.NUMBER);
    }

    protected Short convertObjectToShort(Object sourceObject) throws ConversionException {
        try {
            if (sourceObject instanceof String) {
                return new Short((String)sourceObject);
            }
            if (sourceObject instanceof Number) {
                return new Short(((Number)sourceObject).shortValue());
            }
            if (sourceObject instanceof Boolean) {
                if (((Boolean)sourceObject).booleanValue()) {
                    return new Short(1);
                }
                return new Short(0);
            }
        }
        catch (Exception exception) {
            throw ConversionException.couldNotBeConverted(sourceObject, ClassConstants.SHORT, exception);
        }
        throw ConversionException.couldNotBeConverted(sourceObject, ClassConstants.SHORT);
    }

    protected String convertObjectToString(Object sourceObject) throws ConversionException {
        if (sourceObject.getClass() == ClassConstants.UTILDATE) {
            return Helper.printTimestamp(Helper.timestampFromDate((java.util.Date)sourceObject));
        }
        if (sourceObject instanceof Calendar) {
            return Helper.printCalendar((Calendar)sourceObject);
        }
        if (sourceObject instanceof Timestamp) {
            return Helper.printTimestamp((Timestamp)sourceObject);
        }
        if (sourceObject instanceof Date) {
            return Helper.printDate((Date)sourceObject);
        }
        if (sourceObject instanceof Time) {
            return Helper.printTime((Time)sourceObject);
        }
        if (sourceObject instanceof byte[]) {
            return Helper.buildHexStringFromBytes((byte[])sourceObject);
        }
        if (sourceObject instanceof Byte[]) {
            return Helper.buildHexStringFromBytes(this.convertObjectToByteArray(sourceObject));
        }
        if (sourceObject instanceof char[]) {
            return new String((char[])sourceObject);
        }
        if (sourceObject instanceof Character[]) {
            return new String(this.convertObjectToCharArray(sourceObject));
        }
        if (sourceObject instanceof Class) {
            return ((Class)sourceObject).getName();
        }
        if (sourceObject instanceof Character) {
            return sourceObject.toString();
        }
        if (sourceObject instanceof Clob) {
            Clob clob = (Clob)sourceObject;
            try {
                return clob.getSubString(1L, (int)clob.length());
            }
            catch (SQLException exception) {
                throw DatabaseException.sqlException(exception);
            }
        }
        return sourceObject.toString();
    }

    protected Time convertObjectToTime(Object sourceObject) throws ConversionException {
        Time time = null;
        if (sourceObject instanceof Time) {
            return (Time)sourceObject;
        }
        if (sourceObject instanceof String) {
            time = Helper.timeFromString((String)sourceObject);
        } else if (sourceObject.getClass() == ClassConstants.UTILDATE) {
            time = Helper.timeFromDate((java.util.Date)sourceObject);
        } else if (sourceObject instanceof Timestamp) {
            time = Helper.timeFromTimestamp((Timestamp)sourceObject);
        } else {
            if (sourceObject instanceof Calendar) {
                return Helper.timeFromCalendar((Calendar)sourceObject);
            }
            if (sourceObject instanceof Long) {
                time = Helper.timeFromLong((Long)sourceObject);
            } else {
                throw ConversionException.couldNotBeConverted(sourceObject, ClassConstants.TIME);
            }
        }
        return time;
    }

    protected Timestamp convertObjectToTimestamp(Object sourceObject) throws ConversionException {
        Timestamp timestamp = null;
        if (sourceObject instanceof Timestamp) {
            return (Timestamp)sourceObject;
        }
        if (sourceObject instanceof String) {
            timestamp = Helper.timestampFromString((String)sourceObject);
        } else if (sourceObject instanceof java.util.Date) {
            timestamp = Helper.timestampFromDate((java.util.Date)sourceObject);
        } else {
            if (sourceObject instanceof Calendar) {
                return Helper.timestampFromCalendar((Calendar)sourceObject);
            }
            if (sourceObject instanceof Long) {
                timestamp = Helper.timestampFromLong((Long)sourceObject);
            } else {
                throw ConversionException.couldNotBeConverted(sourceObject, ClassConstants.TIMESTAMP);
            }
        }
        return timestamp;
    }

    protected java.util.Date convertObjectToUtilDate(Object sourceObject) throws ConversionException {
        java.util.Date date = null;
        if (sourceObject.getClass() == java.util.Date.class) {
            date = (java.util.Date)sourceObject;
        } else if (sourceObject instanceof Date) {
            date = Helper.utilDateFromSQLDate((Date)sourceObject);
        } else if (sourceObject instanceof Time) {
            date = Helper.utilDateFromTime((Time)sourceObject);
        } else if (sourceObject instanceof String) {
            date = Helper.utilDateFromTimestamp(Helper.timestampFromString((String)sourceObject));
        } else if (sourceObject instanceof Timestamp) {
            date = Helper.utilDateFromTimestamp((Timestamp)sourceObject);
        } else {
            if (sourceObject instanceof Calendar) {
                return ((Calendar)sourceObject).getTime();
            }
            if (sourceObject instanceof Long) {
                date = Helper.utilDateFromLong((Long)sourceObject);
            } else {
                throw ConversionException.couldNotBeConverted(sourceObject, ClassConstants.UTILDATE);
            }
        }
        return date;
    }

    public Class convertClassNameToClass(String className) throws ConversionException {
        return this.convertObjectToClass(className);
    }

    public static ConversionManager getDefaultManager() {
        if (defaultManager == null) {
            ConversionManager.setDefaultManager(new ConversionManager());
            defaultManager.setShouldUseClassLoaderFromCurrentThread(true);
        }
        return defaultManager;
    }

    public Object getDefaultNullValue(Class theClass) {
        if (this.defaultNullValues == null) {
            return null;
        }
        return this.getDefaultNullValues().get(theClass);
    }

    public Map getDefaultNullValues() {
        return this.defaultNullValues;
    }

    public ClassLoader getLoader() {
        if (this.shouldUseClassLoaderFromCurrentThread()) {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    return (ClassLoader)AccessController.doPrivileged(new PrivilegedGetContextClassLoader(Thread.currentThread()));
                }
                catch (PrivilegedActionException exception) {
                }
            } else {
                return PrivilegedAccessHelper.getContextClassLoader(Thread.currentThread());
            }
        }
        if (this.loader == null) {
            if (defaultLoader == null) {
                ClassLoader loader = null;
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        loader = (ClassLoader)AccessController.doPrivileged(new PrivilegedGetClassLoaderForClass(ClassConstants.ConversionManager_Class));
                    }
                    catch (PrivilegedActionException privilegedActionException) {}
                } else {
                    loader = PrivilegedAccessHelper.getClassLoaderForClass(ClassConstants.ConversionManager_Class);
                }
                this.setLoader(loader);
            } else {
                this.setLoader(ConversionManager.getDefaultLoader());
            }
        }
        return this.loader;
    }

    public boolean hasDefaultNullValues() {
        return this.defaultNullValues != null;
    }

    public static Class loadClass(String className) {
        return (Class)ConversionManager.getDefaultManager().convertObject(className, ClassConstants.CLASS);
    }

    public static Class getObjectClass(Class javaClass) {
        if (javaClass == null) {
            return null;
        }
        if (javaClass.isPrimitive()) {
            if (javaClass == ClassConstants.PCHAR) {
                return ClassConstants.CHAR;
            }
            if (javaClass == ClassConstants.PINT) {
                return ClassConstants.INTEGER;
            }
            if (javaClass == ClassConstants.PDOUBLE) {
                return ClassConstants.DOUBLE;
            }
            if (javaClass == ClassConstants.PFLOAT) {
                return ClassConstants.FLOAT;
            }
            if (javaClass == ClassConstants.PLONG) {
                return ClassConstants.LONG;
            }
            if (javaClass == ClassConstants.PSHORT) {
                return ClassConstants.SHORT;
            }
            if (javaClass == ClassConstants.PBYTE) {
                return ClassConstants.BYTE;
            }
            if (javaClass == ClassConstants.PBOOLEAN) {
                return ClassConstants.BOOLEAN;
            }
        } else {
            if (javaClass == ClassConstants.APBYTE) {
                return ClassConstants.APBYTE;
            }
            if (javaClass == ClassConstants.APCHAR) {
                return ClassConstants.APCHAR;
            }
            return javaClass;
        }
        return javaClass;
    }

    public static Class getPrimitiveClass(String classType) {
        if (classType.equals("int")) {
            return Integer.TYPE;
        }
        if (classType.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (classType.equals("char")) {
            return Character.TYPE;
        }
        if (classType.equals("short")) {
            return Short.TYPE;
        }
        if (classType.equals("byte")) {
            return Byte.TYPE;
        }
        if (classType.equals("float")) {
            return Float.TYPE;
        }
        if (classType.equals("double")) {
            return Double.TYPE;
        }
        if (classType.equals("long")) {
            return Long.TYPE;
        }
        return null;
    }

    public static void setDefaultManager(ConversionManager theManager) {
        defaultManager = theManager;
    }

    public void setDefaultNullValue(Class theClass, Object theValue) {
        if (this.defaultNullValues == null) {
            this.defaultNullValues = new HashMap(5);
        }
        this.getDefaultNullValues().put(theClass, theValue);
    }

    public void setDefaultNullValues(Map defaultNullValues) {
        this.defaultNullValues = defaultNullValues;
    }

    public void setLoader(ClassLoader classLoader) {
        this.shouldUseClassLoaderFromCurrentThread = false;
        this.loader = classLoader;
    }

    public static void setDefaultLoader(ClassLoader classLoader) {
        defaultLoader = classLoader;
    }

    public static ClassLoader getDefaultLoader() {
        return defaultLoader;
    }

    public void setShouldUseClassLoaderFromCurrentThread(boolean useCurrentThread) {
        this.shouldUseClassLoaderFromCurrentThread = useCurrentThread;
    }

    public boolean shouldUseClassLoaderFromCurrentThread() {
        return this.shouldUseClassLoaderFromCurrentThread;
    }

    public Vector getDataTypesConvertedFrom(Class javaClass) {
        if (this.dataTypesConvertedFromAClass.isEmpty()) {
            this.buildDataTypesConvertedFromAClass();
        }
        return (Vector)this.dataTypesConvertedFromAClass.get(javaClass);
    }

    public Vector getDataTypesConvertedTo(Class javaClass) {
        if (this.dataTypesConvertedToAClass.isEmpty()) {
            this.buildDataTypesConvertedToAClass();
        }
        return (Vector)this.dataTypesConvertedToAClass.get(javaClass);
    }

    protected Vector buildNumberVec() {
        Vector<Class<Number>> vec = new Vector<Class<Number>>();
        vec.addElement(BigInteger.class);
        vec.addElement(BigDecimal.class);
        vec.addElement(Byte.class);
        vec.addElement(Double.class);
        vec.addElement(Float.class);
        vec.addElement(Integer.class);
        vec.addElement(Long.class);
        vec.addElement(Short.class);
        vec.addElement(Number.class);
        return vec;
    }

    protected Vector buildDateTimeVec() {
        Vector<Class<Calendar>> vec = new Vector<Class<Calendar>>();
        vec.addElement(java.util.Date.class);
        vec.addElement(Timestamp.class);
        vec.addElement(Calendar.class);
        return vec;
    }

    protected void buildDataTypesConvertedFromAClass() {
        this.dataTypesConvertedFromAClass.put(BigDecimal.class, this.buildFromBigDecimalVec());
        this.dataTypesConvertedFromAClass.put(BigInteger.class, this.buildFromBigIntegerVec());
        this.dataTypesConvertedFromAClass.put(Blob.class, this.buildFromBlobVec());
        this.dataTypesConvertedFromAClass.put(Boolean.class, this.buildFromBooleanVec());
        this.dataTypesConvertedFromAClass.put(byte[].class, this.buildFromByteArrayVec());
        this.dataTypesConvertedFromAClass.put(Byte.class, this.buildFromByteVec());
        this.dataTypesConvertedFromAClass.put(Calendar.class, this.buildFromCalendarVec());
        this.dataTypesConvertedFromAClass.put(Character.class, this.buildFromCharacterVec());
        this.dataTypesConvertedFromAClass.put(Clob.class, this.buildFromClobVec());
        this.dataTypesConvertedFromAClass.put(Date.class, this.buildFromDateVec());
        this.dataTypesConvertedFromAClass.put(Double.class, this.buildFromDoubleVec());
        this.dataTypesConvertedFromAClass.put(Float.class, this.buildFromFloatVec());
        this.dataTypesConvertedFromAClass.put(Integer.class, this.buildFromIntegerVec());
        this.dataTypesConvertedFromAClass.put(Long.class, this.buildFromLongVec());
        this.dataTypesConvertedFromAClass.put(Number.class, this.buildFromNumberVec());
        this.dataTypesConvertedFromAClass.put(Short.class, this.buildFromShortVec());
        this.dataTypesConvertedFromAClass.put(String.class, this.buildFromStringVec());
        this.dataTypesConvertedFromAClass.put(Timestamp.class, this.buildFromTimestampVec());
        this.dataTypesConvertedFromAClass.put(Time.class, this.buildFromTimeVec());
        this.dataTypesConvertedFromAClass.put(java.util.Date.class, this.buildFromUtilDateVec());
        this.dataTypesConvertedFromAClass.put(Byte[].class, this.buildFromByteObjectArraryVec());
        this.dataTypesConvertedFromAClass.put(char[].class, this.buildFromCharArrayVec());
        this.dataTypesConvertedFromAClass.put(Character[].class, this.buildFromCharacterArrayVec());
    }

    protected Vector buildFromBooleanVec() {
        Vector<Class<Comparable<Boolean>>> vec = new Vector<Class<Comparable<Boolean>>>();
        vec.addElement(String.class);
        vec.addElement(Boolean.class);
        vec.addElement(Integer.class);
        vec.addElement(Long.class);
        vec.addElement(Short.class);
        vec.addElement(Number.class);
        vec.addElement(Character[].class);
        vec.addElement(char[].class);
        vec.addElement(Boolean.TYPE);
        vec.addElement(Integer.TYPE);
        vec.addElement(Long.TYPE);
        vec.addElement(Short.TYPE);
        return vec;
    }

    protected Vector buildFromNumberVec() {
        Vector vec = this.buildNumberVec();
        vec.addElement(String.class);
        vec.addElement(Character.class);
        vec.addElement(Boolean.class);
        vec.addElement(Character[].class);
        vec.addElement(char[].class);
        vec.addElement(Character.TYPE);
        vec.addElement(Integer.TYPE);
        vec.addElement(Double.TYPE);
        vec.addElement(Float.TYPE);
        vec.addElement(Long.TYPE);
        vec.addElement(Short.TYPE);
        vec.addElement(Byte.TYPE);
        vec.addElement(Boolean.TYPE);
        return vec;
    }

    protected Vector buildFromBigDecimalVec() {
        return this.buildFromNumberVec();
    }

    protected Vector buildFromBigIntegerVec() {
        return this.buildFromNumberVec();
    }

    protected Vector buildFromIntegerVec() {
        return this.buildFromNumberVec();
    }

    protected Vector buildFromFloatVec() {
        return this.buildFromNumberVec();
    }

    protected Vector buildFromDoubleVec() {
        return this.buildFromNumberVec();
    }

    protected Vector buildFromShortVec() {
        return this.buildFromNumberVec();
    }

    protected Vector buildFromByteVec() {
        return this.buildFromNumberVec();
    }

    protected Vector buildFromLongVec() {
        Vector vec = this.buildFromNumberVec();
        vec.addAll(this.buildDateTimeVec());
        vec.addElement(Date.class);
        vec.addElement(Time.class);
        return vec;
    }

    protected Vector buildFromStringVec() {
        Vector vec = this.buildFromLongVec();
        vec.addElement(Byte[].class);
        vec.addElement(byte[].class);
        vec.addElement(Clob.class);
        return vec;
    }

    protected Vector buildFromCharacterVec() {
        Vector<Class<Boolean>> vec = new Vector<Class<Boolean>>();
        vec.addElement(String.class);
        vec.addElement(Boolean.class);
        vec.addElement(Character[].class);
        vec.addElement(Character.class);
        vec.addElement(char[].class);
        vec.addElement(Character.TYPE);
        vec.addElement(Boolean.TYPE);
        return vec;
    }

    protected Vector buildFromByteArrayVec() {
        Vector<Class<char[]>> vec = new Vector<Class<char[]>>();
        vec.addElement(String.class);
        vec.addElement(byte[].class);
        vec.addElement(Byte[].class);
        vec.addElement(Character[].class);
        vec.addElement(char[].class);
        return vec;
    }

    protected Vector buildFromClobVec() {
        Vector<Class<char[]>> vec = new Vector<Class<char[]>>();
        vec.addElement(String.class);
        vec.addElement(Character[].class);
        vec.addElement(char[].class);
        return vec;
    }

    protected Vector buildFromBlobVec() {
        Vector<Class<char[]>> vec = new Vector<Class<char[]>>();
        vec.addElement(String.class);
        vec.addElement(Byte[].class);
        vec.addElement(byte[].class);
        vec.addElement(Character[].class);
        vec.addElement(char[].class);
        return vec;
    }

    protected Vector buildFromUtilDateVec() {
        Vector vec = this.buildDateTimeVec();
        vec.addElement(String.class);
        vec.addElement(Long.class);
        vec.addElement(Date.class);
        vec.addElement(Time.class);
        vec.addElement(Long.TYPE);
        vec.addElement(Character[].class);
        vec.addElement(char[].class);
        return vec;
    }

    protected Vector buildFromTimestampVec() {
        return this.buildFromUtilDateVec();
    }

    protected Vector buildFromCalendarVec() {
        return this.buildFromUtilDateVec();
    }

    protected Vector buildFromDateVec() {
        Vector vec = this.buildDateTimeVec();
        vec.addElement(String.class);
        vec.addElement(Long.class);
        vec.addElement(Date.class);
        vec.addElement(Long.TYPE);
        vec.addElement(Character[].class);
        vec.addElement(char[].class);
        return vec;
    }

    protected Vector buildFromTimeVec() {
        Vector vec = this.buildDateTimeVec();
        vec.addElement(String.class);
        vec.addElement(Long.class);
        vec.addElement(Time.class);
        vec.addElement(Long.TYPE);
        vec.addElement(Character[].class);
        vec.addElement(char[].class);
        return vec;
    }

    protected Vector buildFromByteObjectArraryVec() {
        Vector<Class> vec = new Vector<Class>();
        vec.addElement(Blob.class);
        vec.addElement(byte[].class);
        return vec;
    }

    protected Vector buildFromCharArrayVec() {
        Vector<Class<Clob>> vec = new Vector<Class<Clob>>();
        vec.addElement(Clob.class);
        return vec;
    }

    protected Vector buildFromCharacterArrayVec() {
        Vector<Class<Clob>> vec = new Vector<Class<Clob>>();
        vec.addElement(Clob.class);
        return vec;
    }

    protected void buildDataTypesConvertedToAClass() {
        this.dataTypesConvertedToAClass.put(BigDecimal.class, this.buildToBigDecimalVec());
        this.dataTypesConvertedToAClass.put(BigInteger.class, this.buildToBigIntegerVec());
        this.dataTypesConvertedToAClass.put(Boolean.class, this.buildToBooleanVec());
        this.dataTypesConvertedToAClass.put(Byte.class, this.buildToByteVec());
        this.dataTypesConvertedToAClass.put(byte[].class, this.buildToByteArrayVec());
        this.dataTypesConvertedToAClass.put(Byte[].class, this.buildToByteObjectArrayVec());
        this.dataTypesConvertedToAClass.put(Calendar.class, this.buildToCalendarVec());
        this.dataTypesConvertedToAClass.put(Character.class, this.buildToCharacterVec());
        this.dataTypesConvertedToAClass.put(Character[].class, this.buildToCharacterArrayVec());
        this.dataTypesConvertedToAClass.put(char[].class, this.buildToCharArrayVec());
        this.dataTypesConvertedToAClass.put(Date.class, this.buildToDateVec());
        this.dataTypesConvertedToAClass.put(Double.class, this.buildToDoubleVec());
        this.dataTypesConvertedToAClass.put(Float.class, this.buildToFloatVec());
        this.dataTypesConvertedToAClass.put(Integer.class, this.buildToIntegerVec());
        this.dataTypesConvertedToAClass.put(Long.class, this.buildToLongVec());
        this.dataTypesConvertedToAClass.put(Number.class, this.buildToNumberVec());
        this.dataTypesConvertedToAClass.put(Short.class, this.buildToShortVec());
        this.dataTypesConvertedToAClass.put(String.class, this.buildToStringVec());
        this.dataTypesConvertedToAClass.put(Timestamp.class, this.buildToTimestampVec());
        this.dataTypesConvertedToAClass.put(Time.class, this.buildToTimeVec());
        this.dataTypesConvertedToAClass.put(java.util.Date.class, this.buildToUtilDateVec());
        this.dataTypesConvertedToAClass.put(Clob.class, this.buildToClobVec());
        this.dataTypesConvertedToAClass.put(Blob.class, this.buildToBlobVec());
    }

    protected Vector buildAllTypesToAClassVec() {
        Vector<Class> vec = new Vector<Class>();
        vec.addElement(String.class);
        vec.addElement(Integer.class);
        vec.addElement(java.util.Date.class);
        vec.addElement(Date.class);
        vec.addElement(Time.class);
        vec.addElement(Timestamp.class);
        vec.addElement(Calendar.class);
        vec.addElement(Character.class);
        vec.addElement(Double.class);
        vec.addElement(Float.class);
        vec.addElement(Long.class);
        vec.addElement(Short.class);
        vec.addElement(Byte.class);
        vec.addElement(BigInteger.class);
        vec.addElement(BigDecimal.class);
        vec.addElement(Number.class);
        vec.addElement(Boolean.class);
        vec.addElement(Character[].class);
        vec.addElement(Blob.class);
        vec.addElement(Clob.class);
        return vec;
    }

    protected Vector buildToBigDecimalVec() {
        Vector vec = this.buildNumberVec();
        vec.addElement(String.class);
        return vec;
    }

    protected Vector buildToBigIntegerVec() {
        return this.buildToBigDecimalVec();
    }

    protected Vector buildToBooleanVec() {
        Vector vec = this.buildToBigDecimalVec();
        vec.addElement(Character.class);
        vec.addElement(Boolean.class);
        return vec;
    }

    protected Vector buildToByteVec() {
        return this.buildToBigDecimalVec();
    }

    protected Vector buildToDoubleVec() {
        return this.buildToBigDecimalVec();
    }

    protected Vector buildToFloatVec() {
        return this.buildToBigDecimalVec();
    }

    protected Vector buildToIntegerVec() {
        Vector vec = this.buildToBigDecimalVec();
        vec.addElement(Boolean.class);
        return vec;
    }

    protected Vector buildToLongVec() {
        Vector vec = this.buildToIntegerVec();
        vec.addElement(Calendar.class);
        vec.addElement(java.util.Date.class);
        return vec;
    }

    protected Vector buildToNumberVec() {
        return this.buildToIntegerVec();
    }

    protected Vector buildToShortVec() {
        return this.buildToIntegerVec();
    }

    protected Vector buildToByteArrayVec() {
        Vector<Class> vec = new Vector<Class>();
        vec.addElement(String.class);
        vec.addElement(Blob.class);
        vec.addElement(byte[].class);
        vec.addElement(Byte[].class);
        return vec;
    }

    protected Vector buildToByteObjectArrayVec() {
        Vector vec = this.buildToByteArrayVec();
        vec.addElement(Byte[].class);
        return vec;
    }

    protected Vector buildToCharacterVec() {
        Vector vec = this.buildToBigDecimalVec();
        vec.addElement(Character.class);
        return vec;
    }

    protected Vector buildToCharacterArrayVec() {
        return this.buildAllTypesToAClassVec();
    }

    protected Vector buildToCharArrayVec() {
        return this.buildAllTypesToAClassVec();
    }

    protected Vector buildToStringVec() {
        return this.buildAllTypesToAClassVec();
    }

    protected Vector buildToCalendarVec() {
        Vector vec = this.buildDateTimeVec();
        vec.addElement(String.class);
        vec.addElement(Long.class);
        vec.addElement(Date.class);
        vec.addElement(Time.class);
        return vec;
    }

    protected Vector buildToTimestampVec() {
        return this.buildToCalendarVec();
    }

    protected Vector buildToUtilDateVec() {
        return this.buildToCalendarVec();
    }

    protected Vector buildToDateVec() {
        Vector vec = this.buildDateTimeVec();
        vec.addElement(String.class);
        vec.addElement(Long.class);
        vec.addElement(Date.class);
        return vec;
    }

    protected Vector buildToTimeVec() {
        Vector vec = this.buildDateTimeVec();
        vec.addElement(String.class);
        vec.addElement(Long.class);
        vec.addElement(Time.class);
        return vec;
    }

    protected Vector buildToBlobVec() {
        Vector<Class> vec = new Vector<Class>();
        vec.addElement(Byte[].class);
        vec.addElement(byte[].class);
        return vec;
    }

    protected Vector buildToClobVec() {
        Vector<Class<Character[]>> vec = new Vector<Class<Character[]>>();
        vec.addElement(String.class);
        vec.addElement(char[].class);
        vec.addElement(Character[].class);
        return vec;
    }
}

