/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.nodes;

import java.io.Serializable;
import org.htmlparser.Node;
import org.htmlparser.NodeFilter;
import org.htmlparser.lexer.Page;
import org.htmlparser.util.NodeList;
import org.htmlparser.util.ParserException;
import org.htmlparser.visitors.NodeVisitor;

public abstract class AbstractNode
implements Node,
Serializable {
    protected Page mPage;
    protected int nodeBegin;
    protected int nodeEnd;
    protected Node parent;
    protected NodeList children;

    public AbstractNode(Page page, int start, int end) {
        this.mPage = page;
        this.nodeBegin = start;
        this.nodeEnd = end;
        this.parent = null;
        this.children = null;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public abstract String toPlainTextString();

    public String toHtml() {
        return this.toHtml(false);
    }

    public abstract String toHtml(boolean var1);

    public abstract String toString();

    public void collectInto(NodeList list, NodeFilter filter) {
        if (filter.accept(this)) {
            list.add(this);
        }
    }

    public Page getPage() {
        return this.mPage;
    }

    public void setPage(Page page) {
        this.mPage = page;
    }

    public int getStartPosition() {
        return this.nodeBegin;
    }

    public void setStartPosition(int position) {
        this.nodeBegin = position;
    }

    public int getEndPosition() {
        return this.nodeEnd;
    }

    public void setEndPosition(int position) {
        this.nodeEnd = position;
    }

    public abstract void accept(NodeVisitor var1);

    public Node getParent() {
        return this.parent;
    }

    public void setParent(Node node) {
        this.parent = node;
    }

    public NodeList getChildren() {
        return this.children;
    }

    public void setChildren(NodeList children) {
        this.children = children;
    }

    public Node getFirstChild() {
        if (this.children == null) {
            return null;
        }
        if (this.children.size() == 0) {
            return null;
        }
        return this.children.elementAt(0);
    }

    public Node getLastChild() {
        if (this.children == null) {
            return null;
        }
        int numChildren = this.children.size();
        if (numChildren == 0) {
            return null;
        }
        return this.children.elementAt(numChildren - 1);
    }

    public Node getPreviousSibling() {
        Node parentNode = this.getParent();
        if (parentNode == null) {
            return null;
        }
        NodeList siblings = parentNode.getChildren();
        if (siblings == null) {
            return null;
        }
        int numSiblings = siblings.size();
        if (numSiblings < 2) {
            return null;
        }
        int positionInParent = -1;
        for (int i = 0; i < numSiblings; ++i) {
            if (siblings.elementAt(i) != this) continue;
            positionInParent = i;
            break;
        }
        if (positionInParent < 1) {
            return null;
        }
        return siblings.elementAt(positionInParent - 1);
    }

    public Node getNextSibling() {
        Node parentNode = this.getParent();
        if (parentNode == null) {
            return null;
        }
        NodeList siblings = parentNode.getChildren();
        if (siblings == null) {
            return null;
        }
        int numSiblings = siblings.size();
        if (numSiblings < 2) {
            return null;
        }
        int positionInParent = -1;
        for (int i = 0; i < numSiblings; ++i) {
            if (siblings.elementAt(i) != this) continue;
            positionInParent = i;
            break;
        }
        if (positionInParent == -1) {
            return null;
        }
        if (positionInParent == numSiblings - 1) {
            return null;
        }
        return siblings.elementAt(positionInParent + 1);
    }

    public String getText() {
        return null;
    }

    public void setText(String text) {
    }

    public void doSemanticAction() throws ParserException {
    }
}

