/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.shopping.action;

import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.shopping.CartMinQuantityException;
import com.liferay.portlet.shopping.CouponActiveException;
import com.liferay.portlet.shopping.CouponEndDateException;
import com.liferay.portlet.shopping.CouponStartDateException;
import com.liferay.portlet.shopping.NoSuchCouponException;
import com.liferay.portlet.shopping.NoSuchItemException;
import com.liferay.portlet.shopping.model.ShoppingCart;
import com.liferay.portlet.shopping.model.ShoppingItem;
import com.liferay.portlet.shopping.service.ShoppingCartLocalServiceUtil;
import com.liferay.portlet.shopping.service.ShoppingItemLocalServiceUtil;
import com.liferay.portlet.shopping.util.ShoppingUtil;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class CartAction
extends PortletAction {
    @Override
    public void processAction(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        try {
            this.updateCart(actionRequest, actionResponse);
            String redirect = PortalUtil.escapeRedirect((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect"));
            if (Validator.isNotNull((String)redirect)) {
                actionResponse.sendRedirect(redirect);
            }
        }
        catch (Exception e2) {
            if (e2 instanceof NoSuchItemException || e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
                this.setForward((PortletRequest)actionRequest, "portlet.shopping.error");
            }
            if (e2 instanceof CartMinQuantityException || e2 instanceof CouponActiveException || e2 instanceof CouponEndDateException || e2 instanceof CouponStartDateException || e2 instanceof NoSuchCouponException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass(), (Object)e2);
            }
            throw e2;
        }
    }

    @Override
    public ActionForward render(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        return actionMapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.shopping.cart"));
    }

    protected void updateCart(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        ShoppingCart cart = ShoppingUtil.getCart((PortletRequest)actionRequest);
        if (cmd.equals("add")) {
            ShoppingItem item;
            long itemId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"itemId");
            String fields = ParamUtil.getString((PortletRequest)actionRequest, (String)"fields");
            if (Validator.isNotNull((String)fields)) {
                fields = "|" + fields;
            }
            if ((item = ShoppingItemLocalServiceUtil.getItem((long)itemId)).getMinQuantity() > 0) {
                int i2 = 0;
                while (i2 < item.getMinQuantity()) {
                    cart.addItemId(itemId, fields);
                    ++i2;
                }
            } else {
                cart.addItemId(itemId, fields);
            }
        } else {
            String itemIds = ParamUtil.getString((PortletRequest)actionRequest, (String)"itemIds");
            String couponCodes = ParamUtil.getString((PortletRequest)actionRequest, (String)"couponCodes");
            int altShipping = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"altShipping");
            boolean insure = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"insure");
            cart.setItemIds(itemIds);
            cart.setCouponCodes(couponCodes);
            cart.setAltShipping(altShipping);
            cart.setInsure(insure);
        }
        ShoppingCartLocalServiceUtil.updateCart((long)cart.getUserId(), (long)cart.getGroupId(), (String)cart.getItemIds(), (String)cart.getCouponCodes(), (int)cart.getAltShipping(), (boolean)cart.isInsure());
        if (cmd.equals("add") || cmd.equals("update")) {
            this.addSuccessMessage(actionRequest, actionResponse);
        }
    }
}

