/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring.tracks;

import com.coremedia.iso.boxes.AbstractMediaHeaderBox;
import com.coremedia.iso.boxes.CompositionTimeToSample;
import com.coremedia.iso.boxes.SampleDependencyTypeBox;
import com.coremedia.iso.boxes.SampleDescriptionBox;
import com.coremedia.iso.boxes.TimeToSampleBox;
import com.googlecode.mp4parser.authoring.AbstractTrack;
import com.googlecode.mp4parser.authoring.Track;
import com.googlecode.mp4parser.authoring.TrackMetaData;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppendTrack
extends AbstractTrack {
    Track[] tracks;

    public AppendTrack(Track ... tracks) throws IOException {
        this.tracks = tracks;
        byte[] referenceSampleDescriptionBox = null;
        Track[] trackArray = tracks;
        int n = tracks.length;
        int n2 = 0;
        while (n2 < n) {
            Track track = trackArray[n2];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            track.getSampleDescriptionBox().getBox(Channels.newChannel(baos));
            if (referenceSampleDescriptionBox == null) {
                referenceSampleDescriptionBox = baos.toByteArray();
            } else if (!Arrays.equals(referenceSampleDescriptionBox, baos.toByteArray())) {
                throw new IOException("Cannot append " + track + " to " + tracks[0] + " since their Sample Description Boxes differ");
            }
            ++n2;
        }
    }

    @Override
    public List<ByteBuffer> getSamples() {
        ArrayList<ByteBuffer> lists = new ArrayList<ByteBuffer>();
        Track[] trackArray = this.tracks;
        int n = this.tracks.length;
        int n2 = 0;
        while (n2 < n) {
            Track track = trackArray[n2];
            lists.addAll(track.getSamples());
            ++n2;
        }
        return lists;
    }

    @Override
    public SampleDescriptionBox getSampleDescriptionBox() {
        return this.tracks[0].getSampleDescriptionBox();
    }

    @Override
    public List<TimeToSampleBox.Entry> getDecodingTimeEntries() {
        if (this.tracks[0].getDecodingTimeEntries() != null && !this.tracks[0].getDecodingTimeEntries().isEmpty()) {
            LinkedList<long[]> lists = new LinkedList<long[]>();
            Track[] trackArray = this.tracks;
            int n = this.tracks.length;
            int n2 = 0;
            while (n2 < n) {
                Track track = trackArray[n2];
                lists.add(TimeToSampleBox.blowupTimeToSamples(track.getDecodingTimeEntries()));
                ++n2;
            }
            LinkedList<TimeToSampleBox.Entry> returnDecodingEntries = new LinkedList<TimeToSampleBox.Entry>();
            Iterator iterator = lists.iterator();
            while (iterator.hasNext()) {
                long[] list;
                long[] lArray = list = (long[])iterator.next();
                int n3 = list.length;
                int n4 = 0;
                while (n4 < n3) {
                    TimeToSampleBox.Entry e;
                    long nuDecodingTime = lArray[n4];
                    if (returnDecodingEntries.isEmpty() || returnDecodingEntries.getLast().getDelta() != nuDecodingTime) {
                        e = new TimeToSampleBox.Entry(1L, nuDecodingTime);
                        returnDecodingEntries.add(e);
                    } else {
                        e = returnDecodingEntries.getLast();
                        e.setCount(e.getCount() + 1L);
                    }
                    ++n4;
                }
            }
            return returnDecodingEntries;
        }
        return null;
    }

    @Override
    public List<CompositionTimeToSample.Entry> getCompositionTimeEntries() {
        if (this.tracks[0].getCompositionTimeEntries() != null && !this.tracks[0].getCompositionTimeEntries().isEmpty()) {
            LinkedList<int[]> lists = new LinkedList<int[]>();
            Track[] trackArray = this.tracks;
            int n = this.tracks.length;
            int n2 = 0;
            while (n2 < n) {
                Track track = trackArray[n2];
                lists.add(CompositionTimeToSample.blowupCompositionTimes(track.getCompositionTimeEntries()));
                ++n2;
            }
            LinkedList<CompositionTimeToSample.Entry> compositionTimeEntries = new LinkedList<CompositionTimeToSample.Entry>();
            Iterator iterator = lists.iterator();
            while (iterator.hasNext()) {
                int[] list;
                int[] nArray = list = (int[])iterator.next();
                int n3 = list.length;
                int n4 = 0;
                while (n4 < n3) {
                    CompositionTimeToSample.Entry e;
                    int compositionTime = nArray[n4];
                    if (compositionTimeEntries.isEmpty() || compositionTimeEntries.getLast().getOffset() != compositionTime) {
                        e = new CompositionTimeToSample.Entry(1, compositionTime);
                        compositionTimeEntries.add(e);
                    } else {
                        e = compositionTimeEntries.getLast();
                        e.setCount(e.getCount() + 1);
                    }
                    ++n4;
                }
            }
            return compositionTimeEntries;
        }
        return null;
    }

    @Override
    public long[] getSyncSamples() {
        if (this.tracks[0].getSyncSamples() != null && this.tracks[0].getSyncSamples().length > 0) {
            int numSyncSamples = 0;
            Track[] trackArray = this.tracks;
            int n = this.tracks.length;
            int n2 = 0;
            while (n2 < n) {
                Track track = trackArray[n2];
                numSyncSamples += track.getSyncSamples().length;
                ++n2;
            }
            long[] returnSyncSamples = new long[numSyncSamples];
            int pos = 0;
            long samplesBefore = 0L;
            Track[] trackArray2 = this.tracks;
            int n3 = this.tracks.length;
            int n4 = 0;
            while (n4 < n3) {
                Track track = trackArray2[n4];
                long[] lArray = track.getSyncSamples();
                int n5 = lArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    long l = lArray[n6];
                    returnSyncSamples[pos++] = samplesBefore + l;
                    ++n6;
                }
                samplesBefore += (long)track.getSamples().size();
                ++n4;
            }
            return returnSyncSamples;
        }
        return null;
    }

    @Override
    public List<SampleDependencyTypeBox.Entry> getSampleDependencies() {
        if (this.tracks[0].getSampleDependencies() != null && !this.tracks[0].getSampleDependencies().isEmpty()) {
            LinkedList<SampleDependencyTypeBox.Entry> list = new LinkedList<SampleDependencyTypeBox.Entry>();
            Track[] trackArray = this.tracks;
            int n = this.tracks.length;
            int n2 = 0;
            while (n2 < n) {
                Track track = trackArray[n2];
                list.addAll(track.getSampleDependencies());
                ++n2;
            }
            return list;
        }
        return null;
    }

    @Override
    public TrackMetaData getTrackMetaData() {
        return this.tracks[0].getTrackMetaData();
    }

    @Override
    public String getHandler() {
        return this.tracks[0].getHandler();
    }

    @Override
    public AbstractMediaHeaderBox getMediaHeaderBox() {
        return this.tracks[0].getMediaHeaderBox();
    }
}

