/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.coverage;

import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyHash;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class CoverageModule {
    @JRubyMethod(module=true)
    public static IRubyObject start(ThreadContext context, IRubyObject self) {
        Ruby runtime2 = context.runtime;
        if (!runtime2.getCoverageData().isCoverageEnabled()) {
            runtime2.getCoverageData().setCoverageEnabled(runtime2, true);
        }
        return context.nil;
    }

    @JRubyMethod(module=true)
    public static IRubyObject result(ThreadContext context, IRubyObject self) {
        Ruby runtime2 = context.runtime;
        if (!runtime2.getCoverageData().isCoverageEnabled()) {
            throw runtime2.newRuntimeError("coverage measurement is not enabled");
        }
        Map<String, Integer[]> coverage2 = runtime2.getCoverageData().resetCoverage(runtime2);
        RubyHash covHash = RubyHash.newHash(runtime2);
        for (Map.Entry<String, Integer[]> entry : coverage2.entrySet()) {
            RubyArray ary = RubyArray.newArray(runtime2, entry.getValue().length);
            for (int i2 = 0; i2 < entry.getValue().length; ++i2) {
                Integer integer = entry.getValue()[i2];
                ary.store(i2, integer == null ? runtime2.getNil() : runtime2.newFixnum(integer));
                covHash.fastASetCheckString(runtime2, RubyString.newString(runtime2, entry.getKey()), ary);
            }
        }
        return covHash;
    }
}

