/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.build;

import aQute.bnd.build.Container;
import aQute.bnd.build.Project;
import aQute.bnd.differ.Baseline;
import aQute.bnd.differ.DiffPluginImpl;
import aQute.bnd.header.Attrs;
import aQute.bnd.header.Parameters;
import aQute.bnd.osgi.Builder;
import aQute.bnd.osgi.Instruction;
import aQute.bnd.osgi.Instructions;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Processor;
import aQute.bnd.osgi.Verifier;
import aQute.bnd.service.RepositoryPlugin;
import aQute.bnd.version.Version;
import aQute.lib.collections.SortedList;
import aQute.lib.io.IO;
import aQute.service.reporter.Report;
import aQute.service.reporter.Reporter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectBuilder
extends Builder {
    private final DiffPluginImpl differ = new DiffPluginImpl();
    Project project;
    boolean initialized;

    public ProjectBuilder(Project project) {
        super(project);
        this.project = project;
        String diffignore = project.getProperty("-diffignore");
        if (diffignore != null) {
            this.differ.setIgnore(diffignore);
        }
    }

    public ProjectBuilder(ProjectBuilder builder) {
        super(builder);
        this.project = builder.project;
    }

    @Override
    public long lastModified() {
        return Math.max(this.project.lastModified(), super.lastModified());
    }

    @Override
    protected Object[] getMacroDomains() {
        return new Object[]{this.project, this.project.getWorkspace()};
    }

    @Override
    public Builder getSubBuilder() throws Exception {
        return this.project.getBuilder(this);
    }

    public Project getProject() {
        return this.project;
    }

    @Override
    public void init() {
        try {
            if (!this.initialized) {
                this.initialized = true;
                for (Container container : this.project.getClasspath()) {
                    this.addClasspath(container.getFile());
                }
                for (Container container : this.project.getBuildpath()) {
                    this.addClasspath(container.getFile());
                }
                for (Container container : this.project.getBootclasspath()) {
                    this.addClasspath(container.getFile());
                }
                for (File file : this.project.getAllsourcepath()) {
                    this.addSourcepath(file);
                }
            }
        }
        catch (Exception e) {
            this.msgs.Unexpected_Error_("ProjectBuilder init", e);
        }
    }

    @Override
    public List<Jar> getClasspath() {
        this.init();
        return super.getClasspath();
    }

    @Override
    protected void changedFile(File f) {
        this.project.getWorkspace().changedFile(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doBaseline(Jar dot) throws Exception {
        Jar fromRepo = this.getBaselineJar();
        if (fromRepo == null) {
            this.trace("No baseline jar %s", this.getProperty("-baseline"));
            return;
        }
        Version newer = new Version(this.getVersion());
        Version older = new Version(fromRepo.getVersion());
        if (!this.getBsn().equals(fromRepo.getBsn())) {
            this.error("The symbolic name of this project (%s) is not the same as the baseline: %s", this.getBsn(), fromRepo.getBsn());
            return;
        }
        this.trace("baseline %s-%s against: %s", this.getBsn(), this.getVersion(), fromRepo.getName());
        try {
            Baseline baseliner = new Baseline(this, this.differ);
            Set<Baseline.Info> infos = baseliner.baseline(dot, fromRepo, null);
            if (infos.isEmpty()) {
                this.trace("no deltas", new Object[0]);
            }
            for (Baseline.Info info : infos) {
                if (!info.mismatch) continue;
                Reporter.SetLocation l = this.error("Baseline mismatch for package %s, %s change. Current is %s, repo is %s, suggest %s or %s\n", new Object[]{info.packageName, info.packageDiff.getDelta(), info.newerVersion, info.olderVersion, info.suggestedVersion, info.suggestedIfProviders == null ? "-" : info.suggestedIfProviders});
                l.header("-baseline");
                this.fillInLocationForPackageInfo(l.location(), info.packageName);
                if (this.getPropertiesFile() != null) {
                    l.file(this.getPropertiesFile().getAbsolutePath());
                }
                l.details(info);
            }
            Baseline.BundleInfo binfo = baseliner.getBundleInfo();
            if (binfo.mismatch) {
                Reporter.SetLocation error = this.error("The bundle version %s is too low, must be at least %s", binfo.version, binfo.suggestedVersion);
                error.context("Baselining");
                error.header("Bundle-Version");
                error.details(binfo);
                Processor.FileLine fl = this.getHeader(Pattern.compile("^Bundle-Version", 8));
                if (fl != null) {
                    error.file(fl.file.getAbsolutePath());
                    error.line(fl.line);
                    error.length(fl.length);
                }
            }
        }
        finally {
            fromRepo.close();
        }
    }

    public void fillInLocationForPackageInfo(Report.Location location, String packageName) throws Exception {
        Processor.FileLine fl;
        Parameters eps = this.getExportPackage();
        Attrs attrs = eps.get(packageName);
        if (attrs != null && attrs.containsKey("version") && (fl = this.getHeader(Pattern.compile("Export-Package", 2))) != null) {
            location.file = fl.file.getAbsolutePath();
            location.line = fl.line;
            location.length = fl.length;
            return;
        }
        Parameters ecs = this.getExportContents();
        attrs = ecs.get(packageName);
        if (attrs != null && attrs.containsKey("version") && (fl = this.getHeader(Pattern.compile("-exportcontents", 2))) != null) {
            location.file = fl.file.getAbsolutePath();
            location.line = fl.line;
            location.length = fl.length;
            return;
        }
        for (File src : this.project.getSourcePath()) {
            String path;
            File packageDir = IO.getFile(src, path = packageName.replace('.', '/'));
            File pi = IO.getFile(packageDir, "package-info.java");
            if (pi.isFile() && (fl = ProjectBuilder.findHeader(pi, Pattern.compile("@Version\\s*([^)]+)"))) != null) {
                location.file = fl.file.getAbsolutePath();
                location.line = fl.line;
                location.length = fl.length;
                return;
            }
            pi = IO.getFile(packageDir, "packageinfo");
            if (!pi.isFile() || (fl = ProjectBuilder.findHeader(pi, Pattern.compile("^\\s*version.*$"))) == null) continue;
            location.file = fl.file.getAbsolutePath();
            location.line = fl.line;
            location.length = fl.length;
            return;
        }
    }

    public Jar getLastRevision() throws Exception {
        RepositoryPlugin releaseRepo = this.getReleaseRepo();
        SortedSet<Version> versions = releaseRepo.versions(this.getBsn());
        if (versions.isEmpty()) {
            return null;
        }
        Jar jar = new Jar(releaseRepo.get(this.getBsn(), versions.last(), null, new RepositoryPlugin.DownloadListener[0]));
        this.addClose(jar);
        return jar;
    }

    public Jar getBaselineJar() throws Exception {
        String bl = this.getProperty("-baseline");
        if (bl == null || "none".equals(bl)) {
            return null;
        }
        Instructions baselines = new Instructions(this.getProperty("-baseline"));
        if (baselines.isEmpty()) {
            return null;
        }
        RepositoryPlugin repo = this.getReleaseRepo();
        if (repo == null) {
            return null;
        }
        String bsn = this.getBsn();
        Version version = new Version(this.getVersion());
        SortedSet<Version> versions = this.removeStagedAndFilter(repo.versions(bsn));
        if (versions.isEmpty()) {
            Version v = new Version(this.getVersion());
            if (v.getWithoutQualifier().compareTo(Version.ONE) > 0) {
                this.error("There is no baseline for %s in the baseline repo %s. The build is for version %s, which is <= 1.0.0 which suggests that there should be a prior version.", this.getBsn(), repo, v);
            }
            return null;
        }
        for (Map.Entry<Instruction, Attrs> e : baselines.entrySet()) {
            File file;
            Version target;
            if (!e.getKey().matches(bsn)) continue;
            Attrs attrs = e.getValue();
            if (attrs.containsKey("version")) {
                String v = attrs.get("version");
                if (!Verifier.isVersion(v)) {
                    this.error("Not a valid version in %s %s", "-baseline", v);
                    return null;
                }
                Version base = new Version(v);
                SortedSet<Version> later = versions.tailSet(base);
                if (later.isEmpty()) {
                    this.error("For baselineing %s-%s, specified version %s not found", bsn, version, base);
                    return null;
                }
                target = later.first();
            } else {
                if (attrs.containsKey("file")) {
                    File f = this.getProject().getFile(attrs.get("file"));
                    if (f != null && f.isFile()) {
                        Jar jar = new Jar(f);
                        this.addClose(jar);
                        return jar;
                    }
                    this.error("Specified file for baseline but could not find it %s", f);
                    return null;
                }
                target = versions.last();
            }
            if (target.getWithoutQualifier().compareTo(version.getWithoutQualifier()) > 0) {
                this.error("The baseline version %s is higher or equal than the current version %s for %s in %s", target, version, bsn, repo);
                return null;
            }
            if (target.getWithoutQualifier().compareTo(version.getWithoutQualifier()) > 0 && this.isPedantic()) {
                this.warning("Baselining against jar", new Object[0]);
            }
            if ((file = repo.get(bsn, target, attrs, new RepositoryPlugin.DownloadListener[0])) == null || !file.isFile()) {
                this.error("Decided on version %s-%s but cannot get file from repo %s", bsn, version, repo);
                return null;
            }
            Jar jar = new Jar(file);
            this.addClose(jar);
            return jar;
        }
        return null;
    }

    private SortedSet<Version> removeStagedAndFilter(SortedSet<Version> versions) {
        ArrayList<Version> filtered = new ArrayList<Version>(versions);
        Collections.reverse(filtered);
        Version last = null;
        Iterator i = filtered.iterator();
        while (i.hasNext()) {
            Version current = ((Version)i.next()).getWithoutQualifier();
            if (last != null && current.equals(last)) {
                i.remove();
                continue;
            }
            last = current;
        }
        SortedList<Version> set = new SortedList<Version>((Collection<Comparable<?>>)filtered);
        this.trace("filtered for only latest staged: %s from %s in range ", set, versions);
        return set;
    }

    private RepositoryPlugin getReleaseRepo() {
        RepositoryPlugin repo = null;
        String repoName = this.getReleaseRepoName();
        List<RepositoryPlugin> repos = this.getPlugins(RepositoryPlugin.class);
        for (RepositoryPlugin r : repos) {
            if (!r.canWrite() || repoName != null && !r.getName().equals(repoName)) continue;
            repo = r;
            break;
        }
        if (repo == null) {
            if (repoName != null) {
                this.error("No writeable repo with name %s found", repoName);
            } else {
                this.error("No writeable repo found", new Object[0]);
            }
        }
        return repo;
    }

    private String getReleaseRepoName() {
        String repoName = this.getProperty("-baselinerepo");
        if (repoName == null) {
            repoName = this.getProperty("-releaserepo");
        }
        if (repoName != null && "none".equals(repoName)) {
            return null;
        }
        return repoName;
    }
}

