/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.test;

import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.InputStream;
import java.sql.Blob;
import java.util.Arrays;
import java.util.Map;
import org.junit.Assert;

public class AssertUtils {
    public static void assertEquals(Blob expectedBlob, Blob actualBlob) throws Exception {
        int expectValue;
        InputStream expectInputStream = expectedBlob.getBinaryStream();
        InputStream actualInputStream = actualBlob.getBinaryStream();
        do {
            expectValue = expectInputStream.read();
            int actualValue = actualInputStream.read();
            AssertUtils.assertEquals(expectValue, actualValue);
        } while (expectValue != -1);
        expectInputStream.close();
        actualInputStream.close();
    }

    public static void assertEquals(double expectedDouble, double actualDouble) {
        Assert.assertEquals((double)expectedDouble, (double)actualDouble, (double)0.0);
    }

    public static void assertEquals(double[] expectedArray, double[] actualArray) {
        Assert.assertArrayEquals((double[])expectedArray, (double[])actualArray, (double)0.0);
    }

    public static void assertEquals(Map<String, ?> expectedMap, Map<String, ?> actualMap) {
        Assert.assertEquals((String)"The maps are different sizes", (long)expectedMap.size(), (long)actualMap.size());
        for (String name : expectedMap.keySet()) {
            Assert.assertEquals((String)("The values for key '" + name + "' are different"), (Object)MapUtil.getString(expectedMap, name), (Object)MapUtil.getString(actualMap, name));
        }
    }

    public static void assertEqualsIgnoreCase(String expectedString, String actualString) {
        if (expectedString != null) {
            expectedString = StringUtil.toLowerCase(expectedString);
        }
        if (actualString != null) {
            actualString = StringUtil.toLowerCase(actualString);
        }
        Assert.assertEquals((Object)expectedString, (Object)actualString);
    }

    public static void assertEqualsSorted(String[] expectedStringArray, String[] actualStringArray) {
        if (expectedStringArray != null) {
            Arrays.sort(expectedStringArray);
        }
        if (actualStringArray != null) {
            Arrays.sort(actualStringArray);
        }
        Assert.assertEquals((Object)StringUtil.merge(expectedStringArray), (Object)StringUtil.merge(actualStringArray));
    }

    public static void assertLessThan(double expectedDouble, double actualDouble) throws Exception {
        if (actualDouble > expectedDouble) {
            Assert.fail((String)(String.valueOf(actualDouble) + " is not less than " + expectedDouble));
        }
    }
}

