/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.persistence.bundle;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.jackrabbit.core.cache.ConcurrentCache;
import org.apache.jackrabbit.core.fs.FileSystemResource;
import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.id.PropertyId;
import org.apache.jackrabbit.core.persistence.CachingPersistenceManager;
import org.apache.jackrabbit.core.persistence.IterablePersistenceManager;
import org.apache.jackrabbit.core.persistence.PMContext;
import org.apache.jackrabbit.core.persistence.PersistenceManager;
import org.apache.jackrabbit.core.persistence.util.BundleBinding;
import org.apache.jackrabbit.core.persistence.util.HashMapIndex;
import org.apache.jackrabbit.core.persistence.util.NodePropBundle;
import org.apache.jackrabbit.core.state.ChangeLog;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.apache.jackrabbit.core.state.NodeReferences;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.util.StringIndex;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBundlePersistenceManager
implements PersistenceManager,
CachingPersistenceManager,
IterablePersistenceManager {
    private static Logger log = LoggerFactory.getLogger(AbstractBundlePersistenceManager.class);
    protected static final String NODEFILENAME = "n";
    protected static final String NODEREFSFILENAME = "r";
    protected static final String RES_NAME_INDEX = "/names.properties";
    protected static final String RES_NS_INDEX = "/namespaces.properties";
    private static final NodePropBundle MISSING = new NodePropBundle(null, new NodeId());
    private StringIndex nsIndex;
    private StringIndex nameIndex;
    private ConcurrentCache<NodeId, NodePropBundle> bundles;
    protected PMContext context;
    private long bundleCacheSize = 0x800000L;

    public String getBundleCacheSize() {
        return String.valueOf(this.bundleCacheSize / 0x100000L);
    }

    public void setBundleCacheSize(String bundleCacheSize) {
        this.bundleCacheSize = Long.parseLong(bundleCacheSize) * 1024L * 1024L;
    }

    protected StringBuffer buildNodeFolderPath(StringBuffer buf, NodeId id) {
        if (buf == null) {
            buf = new StringBuffer();
        }
        char[] chars = id.toString().toCharArray();
        int cnt = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '-') continue;
            if (cnt == 2 || cnt == 4) {
                buf.append('/');
            }
            buf.append(chars[i]);
            ++cnt;
        }
        return buf;
    }

    protected StringBuffer buildPropFilePath(StringBuffer buf, PropertyId id) {
        if (buf == null) {
            buf = new StringBuffer();
        }
        this.buildNodeFolderPath(buf, id.getParentId());
        buf.append("/");
        buf.append(this.getNsIndex().stringToIndex(id.getName().getNamespaceURI()));
        buf.append('.');
        buf.append(this.getNameIndex().stringToIndex(id.getName().getLocalName()));
        return buf;
    }

    protected StringBuffer buildBlobFilePath(StringBuffer buf, PropertyId id, int i) {
        if (buf == null) {
            buf = new StringBuffer();
        }
        this.buildPropFilePath(buf, id);
        buf.append('.');
        buf.append(i);
        return buf;
    }

    protected StringBuffer buildNodeFilePath(StringBuffer buf, NodeId id) {
        if (buf == null) {
            buf = new StringBuffer();
        }
        this.buildNodeFolderPath(buf, id);
        buf.append("/");
        buf.append(NODEFILENAME);
        return buf;
    }

    protected StringBuffer buildNodeReferencesFilePath(StringBuffer buf, NodeId id) {
        if (buf == null) {
            buf = new StringBuffer();
        }
        this.buildNodeFolderPath(buf, id);
        buf.append("/");
        buf.append(NODEREFSFILENAME);
        return buf;
    }

    public StringIndex getNsIndex() {
        try {
            if (this.nsIndex == null) {
                FileSystemResource nsFile = new FileSystemResource(this.context.getFileSystem(), RES_NS_INDEX);
                this.nsIndex = nsFile.exists() ? new HashMapIndex(nsFile) : (StringIndex)this.context.getNamespaceRegistry();
            }
            return this.nsIndex;
        }
        catch (Exception e) {
            IllegalStateException e2 = new IllegalStateException("Unable to create nsIndex.");
            e2.initCause(e);
            throw e2;
        }
    }

    public StringIndex getNameIndex() {
        try {
            if (this.nameIndex == null) {
                this.nameIndex = new HashMapIndex(new FileSystemResource(this.context.getFileSystem(), RES_NAME_INDEX));
            }
            return this.nameIndex;
        }
        catch (Exception e) {
            IllegalStateException e2 = new IllegalStateException("Unable to create nameIndex.");
            e2.initCause(e);
            throw e2;
        }
    }

    public synchronized void onExternalUpdate(ChangeLog changes) {
        for (ItemState state : changes.modifiedStates()) {
            this.bundles.remove(this.getBundleId(state));
        }
        for (ItemState state : changes.deletedStates()) {
            this.bundles.remove(this.getBundleId(state));
        }
        for (ItemState state : changes.addedStates()) {
            this.bundles.remove(this.getBundleId(state));
        }
    }

    private NodeId getBundleId(ItemState state) {
        if (state.isNode()) {
            return (NodeId)state.getId();
        }
        return state.getParentId();
    }

    protected abstract NodePropBundle loadBundle(NodeId var1) throws ItemStateException;

    protected abstract void storeBundle(NodePropBundle var1) throws ItemStateException;

    protected abstract void destroyBundle(NodePropBundle var1) throws ItemStateException;

    protected abstract void destroy(NodeReferences var1) throws ItemStateException;

    protected abstract void store(NodeReferences var1) throws ItemStateException;

    protected abstract BundleBinding getBinding();

    public void init(PMContext context) throws Exception {
        this.context = context;
        this.bundles = new ConcurrentCache();
        this.bundles.setMaxMemorySize(this.bundleCacheSize);
    }

    public void close() throws Exception {
        this.bundles.clear();
    }

    public NodeState load(NodeId id) throws NoSuchItemStateException, ItemStateException {
        NodePropBundle bundle = this.getBundle(id);
        if (bundle == null) {
            throw new NoSuchItemStateException(id.toString());
        }
        return bundle.createNodeState(this);
    }

    public PropertyState load(PropertyId id) throws NoSuchItemStateException, ItemStateException {
        NodePropBundle bundle = this.getBundle(id.getParentId());
        if (bundle == null) {
            throw new NoSuchItemStateException(id.toString());
        }
        PropertyState state = bundle.createPropertyState(this, id.getName());
        if (state == null) {
            if (id.getName().equals(NameConstants.JCR_UUID)) {
                state = this.createNew(id);
                state.setType(1);
                state.setMultiValued(false);
                state.setValues(new InternalValue[]{InternalValue.create(id.getParentId().toString())});
            } else if (id.getName().equals(NameConstants.JCR_PRIMARYTYPE)) {
                state = this.createNew(id);
                state.setType(7);
                state.setMultiValued(false);
                state.setValues(new InternalValue[]{InternalValue.create(bundle.getNodeTypeName())});
            } else if (id.getName().equals(NameConstants.JCR_MIXINTYPES)) {
                Set<Name> mixins = bundle.getMixinTypeNames();
                state = this.createNew(id);
                state.setType(7);
                state.setMultiValued(true);
                state.setValues(InternalValue.create(mixins.toArray(new Name[mixins.size()])));
            } else {
                throw new NoSuchItemStateException(id.toString());
            }
            bundle.addProperty(state);
        }
        return state;
    }

    public boolean exists(PropertyId id) throws ItemStateException {
        NodePropBundle bundle = this.getBundle(id.getParentId());
        return bundle != null && bundle.hasProperty(id.getName());
    }

    public boolean exists(NodeId id) throws ItemStateException {
        return this.getBundle(id) != null;
    }

    public NodeState createNew(NodeId id) {
        return new NodeState(id, null, null, 4, false);
    }

    public PropertyState createNew(PropertyId id) {
        return new PropertyState(id, 4, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void store(ChangeLog changeLog) throws ItemStateException {
        boolean success = false;
        try {
            this.storeInternal(changeLog);
            success = true;
        }
        finally {
            if (!success) {
                this.bundles.clear();
            }
        }
    }

    private void storeInternal(ChangeLog changeLog) throws ItemStateException {
        NodePropBundle bundle;
        NodeId nodeId;
        PropertyId id;
        HashSet<ItemId> deleted = new HashSet<ItemId>();
        for (ItemState state : changeLog.deletedStates()) {
            if (!state.isNode()) continue;
            NodePropBundle bundle2 = this.getBundle((NodeId)state.getId());
            if (bundle2 == null) {
                throw new NoSuchItemStateException(state.getId().toString());
            }
            this.deleteBundle(bundle2);
            deleted.add(state.getId());
        }
        HashMap<ItemId, NodePropBundle> modified = new HashMap<ItemId, NodePropBundle>();
        for (ItemState state : changeLog.addedStates()) {
            if (!state.isNode()) continue;
            NodePropBundle bundle3 = new NodePropBundle(this.getBinding(), (NodeState)state);
            modified.put(state.getId(), bundle3);
        }
        for (ItemState state : changeLog.modifiedStates()) {
            if (state.isNode()) {
                NodeId nodeId2 = (NodeId)state.getId();
                NodePropBundle bundle4 = (NodePropBundle)modified.get(nodeId2);
                if (bundle4 == null) {
                    bundle4 = this.getBundle(nodeId2);
                    if (bundle4 == null) {
                        throw new NoSuchItemStateException(nodeId2.toString());
                    }
                    modified.put(nodeId2, bundle4);
                }
                bundle4.update((NodeState)state);
                continue;
            }
            id = (PropertyId)state.getId();
            if (id.getName().equals(NameConstants.JCR_PRIMARYTYPE) || id.getName().equals(NameConstants.JCR_MIXINTYPES) || id.getName().equals(NameConstants.JCR_UUID)) continue;
            nodeId = id.getParentId();
            bundle = (NodePropBundle)modified.get(nodeId);
            if (bundle == null) {
                bundle = this.getBundle(nodeId);
                if (bundle == null) {
                    throw new NoSuchItemStateException(nodeId.toString());
                }
                modified.put(nodeId, bundle);
            }
            bundle.addProperty((PropertyState)state);
        }
        for (ItemState state : changeLog.deletedStates()) {
            if (state.isNode()) {
                NodeId parentId = state.getParentId();
                if (modified.containsKey(parentId) || deleted.contains(parentId)) continue;
                log.warn("Deleted node state's parent is not modified or deleted: " + parentId + "/" + state.getId());
                continue;
            }
            id = (PropertyId)state.getId();
            nodeId = id.getParentId();
            if (deleted.contains(nodeId)) continue;
            bundle = (NodePropBundle)modified.get(nodeId);
            if (bundle == null) {
                log.warn("deleted property state's parent not modified!");
                bundle = this.getBundle(nodeId);
                if (bundle == null) {
                    throw new NoSuchItemStateException(nodeId.toString());
                }
                modified.put(nodeId, bundle);
            }
            bundle.removeProperty(id.getName());
        }
        for (ItemState state : changeLog.addedStates()) {
            if (state.isNode() || (id = (PropertyId)state.getId()).getName().equals(NameConstants.JCR_PRIMARYTYPE) || id.getName().equals(NameConstants.JCR_MIXINTYPES) || id.getName().equals(NameConstants.JCR_UUID)) continue;
            nodeId = id.getParentId();
            bundle = (NodePropBundle)modified.get(nodeId);
            if (bundle == null) {
                log.warn("added property state's parent not modified!");
                bundle = this.getBundle(nodeId);
                if (bundle == null) {
                    throw new NoSuchItemStateException(nodeId.toString());
                }
                modified.put(nodeId, bundle);
            }
            bundle.addProperty((PropertyState)state);
        }
        for (NodePropBundle bundle2 : modified.values()) {
            this.putBundle(bundle2);
        }
        for (NodeReferences refs : changeLog.modifiedRefs()) {
            if (refs.hasReferences()) {
                this.store(refs);
                continue;
            }
            this.destroy(refs);
        }
    }

    private NodePropBundle getBundle(NodeId id) throws ItemStateException {
        NodePropBundle bundle = this.bundles.get(id);
        if (bundle == MISSING) {
            return null;
        }
        if (bundle == null) {
            bundle = this.loadBundle(id);
            if (bundle != null) {
                bundle.markOld();
                this.bundles.put(id, bundle, bundle.getSize());
            } else {
                this.bundles.put(id, MISSING, 16L);
            }
        }
        return bundle;
    }

    private void deleteBundle(NodePropBundle bundle) throws ItemStateException {
        this.destroyBundle(bundle);
        bundle.removeAllProperties();
        this.bundles.put(bundle.getId(), MISSING, 16L);
    }

    private void putBundle(NodePropBundle bundle) throws ItemStateException {
        this.storeBundle(bundle);
        bundle.markOld();
        log.debug("stored bundle {}", (Object)bundle.getId());
        if (this.bundles.containsKey(bundle.getId())) {
            this.bundles.put(bundle.getId(), bundle, bundle.getSize());
        }
    }

    public void checkConsistency(String[] uuids, boolean recursive, boolean fix) {
    }

    protected void evictBundle(NodeId id) {
        this.bundles.remove(id);
    }
}

