/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.ferry;

import com.xuggle.ferry.FerryJNI;
import com.xuggle.ferry.JNIReference;
import com.xuggle.ferry.RefCounted;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class IBuffer
extends RefCounted {
    private volatile long swigCPtr;

    public IBuffer(long ignore1, boolean ignore2) {
        super(FerryJNI.SWIGIBufferUpcast(ignore1), ignore2);
        this.swigCPtr = ignore1;
    }

    protected IBuffer(long cPtr, boolean cMemoryOwn, AtomicLong ref) {
        super(FerryJNI.SWIGIBufferUpcast(cPtr), cMemoryOwn, ref);
        this.swigCPtr = cPtr;
    }

    public static long getCPtr(IBuffer obj) {
        if (obj == null) {
            return 0L;
        }
        return obj.getMyCPtr();
    }

    @Override
    public long getMyCPtr() {
        if (this.swigCPtr == 0L) {
            throw new IllegalStateException("underlying native object already deleted");
        }
        return this.swigCPtr;
    }

    @Override
    public void delete() {
        super.delete();
    }

    @Override
    public IBuffer copyReference() {
        if (this.swigCPtr == 0L) {
            return null;
        }
        return new IBuffer(this.swigCPtr, this.swigCMemOwn, this.getJavaRefCount());
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof IBuffer) {
            equal = ((IBuffer)obj).swigCPtr == this.swigCPtr;
        }
        return equal;
    }

    public int hashCode() {
        return (int)this.swigCPtr;
    }

    private void validateArgs(Object array, int arrayLength, int arrayPos, int bufferSize, int bufferPos, int length) {
        if (arrayPos < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (bufferPos < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (length < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (arrayPos + length > arrayLength) {
            throw new IndexOutOfBoundsException();
        }
        if (bufferPos + length > bufferSize) {
            throw new IndexOutOfBoundsException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(byte[] src, int srcPos, int destPos, int length) {
        AtomicReference<JNIReference> ref = new AtomicReference<JNIReference>();
        ByteBuffer buffer = this.getByteBuffer(0, this.getBufferSize(), ref);
        try {
            if (buffer == null) {
                return;
            }
            buffer.clear();
            this.validateArgs(src, src.length, srcPos, buffer.limit(), destPos, length);
            buffer.position(destPos);
            buffer.put(src, srcPos, length);
            return;
        }
        finally {
            if (ref.get() != null) {
                ref.get().delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void get(int srcPos, byte[] dest, int destPos, int length) {
        AtomicReference<JNIReference> ref = new AtomicReference<JNIReference>();
        ByteBuffer buffer = this.getByteBuffer(0, this.getBufferSize(), ref);
        try {
            if (buffer == null) {
                return;
            }
            this.validateArgs(dest, dest.length, destPos, buffer.limit(), srcPos, length);
            buffer.position(srcPos);
            buffer.get(dest, destPos, length);
            return;
        }
        finally {
            if (ref.get() != null) {
                ref.get().delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(short[] src, int srcPos, int destPos, int length) {
        AtomicReference<JNIReference> ref = new AtomicReference<JNIReference>();
        ByteBuffer bbuffer = this.getByteBuffer(0, this.getBufferSize(), ref);
        try {
            if (bbuffer == null) {
                return;
            }
            ShortBuffer buffer = bbuffer.asShortBuffer();
            buffer.clear();
            this.validateArgs(src, src.length, srcPos, buffer.limit(), destPos, length);
            buffer.position(destPos);
            buffer.put(src, srcPos, length);
            return;
        }
        finally {
            if (ref.get() != null) {
                ref.get().delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void get(int srcPos, short[] dest, int destPos, int length) {
        AtomicReference<JNIReference> ref = new AtomicReference<JNIReference>();
        ByteBuffer bbuffer = this.getByteBuffer(0, this.getBufferSize(), ref);
        try {
            if (bbuffer == null) {
                return;
            }
            ShortBuffer buffer = bbuffer.asShortBuffer();
            this.validateArgs(dest, dest.length, destPos, buffer.limit(), srcPos, length);
            buffer.position(srcPos);
            buffer.get(dest, destPos, length);
            return;
        }
        finally {
            if (ref.get() != null) {
                ref.get().delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(int[] src, int srcPos, int destPos, int length) {
        AtomicReference<JNIReference> ref = new AtomicReference<JNIReference>();
        ByteBuffer bbuffer = this.getByteBuffer(0, this.getBufferSize(), ref);
        try {
            if (bbuffer == null) {
                return;
            }
            IntBuffer buffer = bbuffer.asIntBuffer();
            buffer.clear();
            this.validateArgs(src, src.length, srcPos, buffer.limit(), destPos, length);
            buffer.position(destPos);
            buffer.put(src, srcPos, length);
            return;
        }
        finally {
            if (ref.get() != null) {
                ref.get().delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void get(int srcPos, int[] dest, int destPos, int length) {
        AtomicReference<JNIReference> ref = new AtomicReference<JNIReference>();
        ByteBuffer bbuffer = this.getByteBuffer(0, this.getBufferSize(), ref);
        try {
            if (bbuffer == null) {
                return;
            }
            IntBuffer buffer = bbuffer.asIntBuffer();
            this.validateArgs(dest, dest.length, destPos, buffer.limit(), srcPos, length);
            buffer.position(srcPos);
            buffer.get(dest, destPos, length);
            return;
        }
        finally {
            if (ref.get() != null) {
                ref.get().delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(long[] src, int srcPos, int destPos, int length) {
        AtomicReference<JNIReference> ref = new AtomicReference<JNIReference>();
        ByteBuffer bbuffer = this.getByteBuffer(0, this.getBufferSize(), ref);
        try {
            if (bbuffer == null) {
                return;
            }
            LongBuffer buffer = bbuffer.asLongBuffer();
            buffer.clear();
            this.validateArgs(src, src.length, srcPos, buffer.limit(), destPos, length);
            buffer.position(destPos);
            buffer.put(src, srcPos, length);
            return;
        }
        finally {
            if (ref.get() != null) {
                ref.get().delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void get(int srcPos, long[] dest, int destPos, int length) {
        AtomicReference<JNIReference> ref = new AtomicReference<JNIReference>();
        ByteBuffer bbuffer = this.getByteBuffer(0, this.getBufferSize(), ref);
        try {
            if (bbuffer == null) {
                return;
            }
            LongBuffer buffer = bbuffer.asLongBuffer();
            this.validateArgs(dest, dest.length, destPos, buffer.limit(), srcPos, length);
            buffer.position(srcPos);
            buffer.get(dest, destPos, length);
            return;
        }
        finally {
            if (ref.get() != null) {
                ref.get().delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(double[] src, int srcPos, int destPos, int length) {
        AtomicReference<JNIReference> ref = new AtomicReference<JNIReference>();
        ByteBuffer bbuffer = this.getByteBuffer(0, this.getBufferSize(), ref);
        try {
            if (bbuffer == null) {
                return;
            }
            DoubleBuffer buffer = bbuffer.asDoubleBuffer();
            buffer.clear();
            this.validateArgs(src, src.length, srcPos, buffer.limit(), destPos, length);
            buffer.position(destPos);
            buffer.put(src, srcPos, length);
            return;
        }
        finally {
            if (ref.get() != null) {
                ref.get().delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void get(int srcPos, double[] dest, int destPos, int length) {
        AtomicReference<JNIReference> ref = new AtomicReference<JNIReference>();
        ByteBuffer bbuffer = this.getByteBuffer(0, this.getBufferSize(), ref);
        try {
            if (bbuffer == null) {
                return;
            }
            DoubleBuffer buffer = bbuffer.asDoubleBuffer();
            this.validateArgs(dest, dest.length, destPos, buffer.limit(), srcPos, length);
            buffer.position(srcPos);
            buffer.get(dest, destPos, length);
            return;
        }
        finally {
            if (ref.get() != null) {
                ref.get().delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(float[] src, int srcPos, int destPos, int length) {
        AtomicReference<JNIReference> ref = new AtomicReference<JNIReference>();
        ByteBuffer bbuffer = this.getByteBuffer(0, this.getBufferSize(), ref);
        try {
            if (bbuffer == null) {
                return;
            }
            FloatBuffer buffer = bbuffer.asFloatBuffer();
            buffer.clear();
            this.validateArgs(src, src.length, srcPos, buffer.limit(), destPos, length);
            buffer.position(destPos);
            buffer.put(src, srcPos, length);
            return;
        }
        finally {
            if (ref.get() != null) {
                ref.get().delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void get(int srcPos, float[] dest, int destPos, int length) {
        AtomicReference<JNIReference> ref = new AtomicReference<JNIReference>();
        ByteBuffer bbuffer = this.getByteBuffer(0, this.getBufferSize(), ref);
        try {
            if (bbuffer == null) {
                return;
            }
            FloatBuffer buffer = bbuffer.asFloatBuffer();
            this.validateArgs(dest, dest.length, destPos, buffer.limit(), srcPos, length);
            buffer.position(srcPos);
            buffer.get(dest, destPos, length);
            return;
        }
        finally {
            if (ref.get() != null) {
                ref.get().delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(char[] src, int srcPos, int destPos, int length) {
        AtomicReference<JNIReference> ref = new AtomicReference<JNIReference>();
        ByteBuffer bbuffer = this.getByteBuffer(0, this.getBufferSize(), ref);
        try {
            if (bbuffer == null) {
                return;
            }
            CharBuffer buffer = bbuffer.asCharBuffer();
            buffer.clear();
            this.validateArgs(src, src.length, srcPos, buffer.limit(), destPos, length);
            buffer.position(destPos);
            buffer.put(src, srcPos, length);
            return;
        }
        finally {
            if (ref.get() != null) {
                ref.get().delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void get(int srcPos, char[] dest, int destPos, int length) {
        AtomicReference<JNIReference> ref = new AtomicReference<JNIReference>();
        ByteBuffer bbuffer = this.getByteBuffer(0, this.getBufferSize(), ref);
        try {
            if (bbuffer == null) {
                return;
            }
            CharBuffer buffer = bbuffer.asCharBuffer();
            this.validateArgs(dest, dest.length, destPos, buffer.limit(), srcPos, length);
            buffer.position(srcPos);
            buffer.get(dest, destPos, length);
            return;
        }
        finally {
            if (ref.get() != null) {
                ref.get().delete();
            }
        }
    }

    public ByteBuffer getByteBuffer(int offset, int length) {
        return this.getByteBuffer(offset, length, null);
    }

    public ByteBuffer getByteBuffer(int offset, int length, AtomicReference<JNIReference> referenceReturn) {
        ByteBuffer retval = this.java_getByteBuffer(offset, length);
        if (retval != null) {
            AtomicLong refCount = this.getJavaRefCount();
            refCount.incrementAndGet();
            JNIReference ref = JNIReference.createNonFerryReference(this, retval, this.swigCPtr, refCount);
            if (referenceReturn != null) {
                referenceReturn.set(ref);
            }
            retval.order(ByteOrder.nativeOrder());
        }
        return retval;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.toString());
        builder.append("[");
        builder.append("bytes=").append(this.getBufferSize()).append(";");
        builder.append("type=").append((Object)this.getType()).append(";");
        builder.append("size=").append(this.getSize()).append(";");
        builder.append("]");
        return builder.toString();
    }

    public int getBufferSize() {
        return FerryJNI.IBuffer_getBufferSize(this.swigCPtr, this);
    }

    public static IBuffer make(RefCounted requestor, int bufferSize) {
        long cPtr = FerryJNI.IBuffer_make__SWIG_0(RefCounted.getCPtr(requestor), requestor, bufferSize);
        return cPtr == 0L ? null : new IBuffer(cPtr, false);
    }

    public Type getType() {
        return Type.swigToEnum(FerryJNI.IBuffer_getType(this.swigCPtr, this));
    }

    public void setType(Type type) {
        FerryJNI.IBuffer_setType(this.swigCPtr, this, type.swigValue());
    }

    public static int getTypeSize(Type type) {
        return FerryJNI.IBuffer_getTypeSize(type.swigValue());
    }

    public int getSize() {
        return FerryJNI.IBuffer_getSize(this.swigCPtr, this);
    }

    public static IBuffer make(RefCounted requestor, Type type, int numElements, boolean zero) {
        long cPtr = FerryJNI.IBuffer_make__SWIG_1(RefCounted.getCPtr(requestor), requestor, type.swigValue(), numElements, zero);
        return cPtr == 0L ? null : new IBuffer(cPtr, false);
    }

    public ByteBuffer java_getByteBuffer(int offset, int length) {
        return FerryJNI.IBuffer_java_getByteBuffer(this.swigCPtr, this, offset, length);
    }

    public byte[] getByteArray(int offset, int length) {
        return FerryJNI.IBuffer_getByteArray(this.swigCPtr, this, offset, length);
    }

    public static IBuffer make(RefCounted requestor, byte[] buffer, int offset, int length) {
        long cPtr = FerryJNI.IBuffer_make__SWIG_2(RefCounted.getCPtr(requestor), requestor, buffer, offset, length);
        return cPtr == 0L ? null : new IBuffer(cPtr, false);
    }

    public static IBuffer make(RefCounted requestor, ByteBuffer directByteBuffer, int offset, int length) {
        long cPtr = FerryJNI.IBuffer_make__SWIG_3(RefCounted.getCPtr(requestor), requestor, directByteBuffer, offset, length);
        return cPtr == 0L ? null : new IBuffer(cPtr, false);
    }

    public static enum Type {
        IBUFFER_UINT8,
        IBUFFER_SINT8,
        IBUFFER_UINT16,
        IBUFFER_SINT16,
        IBUFFER_UINT32,
        IBUFFER_SINT32,
        IBUFFER_UINT64,
        IBUFFER_SINT64,
        IBUFFER_FLT32,
        IBUFFER_DBL64,
        IBUFFER_NB;

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static Type swigToEnum(int swigValue) {
            Type[] swigValues = (Type[])Type.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (Type swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + Type.class + " with value " + swigValue);
        }

        private Type() {
            this.swigValue = SwigNext.next++;
        }

        private Type(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private Type(Type swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }
}

