/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.lar;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import java.util.Locale;

public class PortletDataHandlerControl {
    private String _className;
    private String _controlLabel;
    private String _controlName;
    private boolean _disabled;
    private String _namespace;
    private String _referrerClassName;

    public static String getNamespacedControlName(String namespace, String controlName) {
        StringBundler sb = new StringBundler(4);
        sb.append("_");
        sb.append(namespace);
        sb.append("_");
        sb.append(controlName);
        return sb.toString();
    }

    public PortletDataHandlerControl(String namespace, String controlName) {
        this(namespace, controlName, false);
    }

    public PortletDataHandlerControl(String namespace, String controlName, boolean disabled) {
        this(namespace, controlName, disabled, null);
    }

    public PortletDataHandlerControl(String namespace, String controlName, boolean disabled, String className) {
        this(namespace, controlName, disabled, className, null);
    }

    public PortletDataHandlerControl(String namespace, String controlName, boolean disabled, String className, String referrerClassName) {
        this(namespace, controlName, controlName, disabled, className, referrerClassName);
    }

    public PortletDataHandlerControl(String namespace, String controlName, String controlLabel, boolean disabled, String className, String referrerClassName) {
        this._namespace = namespace;
        this._controlLabel = controlLabel;
        this._controlName = controlName;
        this._disabled = disabled;
        this._className = className;
        this._referrerClassName = referrerClassName;
    }

    public String getClassName() {
        return this._className;
    }

    public String getControlLabel() {
        return this._controlLabel;
    }

    public String getControlName() {
        return this._controlName;
    }

    public String getHelpMessage(Locale locale, String action) {
        String helpMessage = LanguageUtil.get(locale, String.valueOf(action) + "-" + this._controlLabel + "-help", "");
        if (Validator.isNull(helpMessage)) {
            helpMessage = LanguageUtil.get(locale, "export-import-publish-" + this._controlLabel + "-help", "");
        }
        return helpMessage;
    }

    public String getNamespace() {
        return this._namespace;
    }

    public String getNamespacedControlName() {
        return PortletDataHandlerControl.getNamespacedControlName(this._namespace, this.getControlName());
    }

    public String getReferrerClassName() {
        return this._referrerClassName;
    }

    public boolean isDisabled() {
        return this._disabled;
    }

    public void setNamespace(String namespace) {
        this._namespace = namespace;
    }
}

