/*
 * Decompiled with CFR 0.152.
 */
package org.walluck.oscar.handlers;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.walluck.oscar.AIMConnection;
import org.walluck.oscar.AIMFrame;
import org.walluck.oscar.AIMInputStream;
import org.walluck.oscar.AIMOutputStream;
import org.walluck.oscar.AIMSession;
import org.walluck.oscar.AIMUtil;
import org.walluck.oscar.Chat;
import org.walluck.oscar.FLAP;
import org.walluck.oscar.MsgCookie;
import org.walluck.oscar.SNAC;
import org.walluck.oscar.TLV;
import org.walluck.oscar.TLVChain;
import org.walluck.oscar.UserInfo;
import org.walluck.oscar.handlers.ChatListener;
import org.walluck.oscar.handlers.SNACHandler;

public class ChatHandler
extends SNACHandler {
    private static final Logger LOG = Logger.getLogger((String)(class$org$walluck$oscar$handlers$ChatHandler == null ? (class$org$walluck$oscar$handlers$ChatHandler = ChatHandler.class$("org.walluck.oscar.handlers.ChatHandler")) : class$org$walluck$oscar$handlers$ChatHandler).getName());
    static /* synthetic */ Class class$org$walluck$oscar$handlers$ChatHandler;

    public ChatHandler() {
        this.setFamily(14);
        this.setVersion(1);
    }

    private AIMConnection getChatConn(AIMSession sess, String name) {
        AIMConnection conn;
        Iterator i = sess.getConnList().iterator();
        while (i.hasNext() && ((conn = (AIMConnection)i.next()).getFlags() & 0xE) != 0) {
            Chat chat = (Chat)conn.getInternal();
            if (!chat.getName().equals(name)) continue;
            return conn;
        }
        return null;
    }

    public void join(AIMSession sess, AIMConnection conn, int exchange, String name, int instance) throws IOException {
        if (sess == null || conn == null || name == null) {
            throw new NullPointerException();
        }
        FLAP flap = new FLAP(2);
        SNAC snac = new SNAC(1, 4, 0, null, false);
        Chat chat = new Chat();
        chat.setSN(sess.getSN());
        chat.setExchange(exchange);
        chat.setName(name);
        chat.setInstance(instance);
        TLVChain tlvchain = new TLVChain(1);
        tlvchain.addChatRoom(1, chat);
        conn.setInternal(chat);
        AIMOutputStream buffer = new AIMOutputStream(2 + tlvchain.length());
        buffer.writeShort(14);
        buffer.writeTLVChain(tlvchain);
        conn.enqueueFrame(new AIMFrame(conn, 0, flap, snac, buffer));
    }

    public void leaveRoom(AIMSession sess, String name) {
        AIMConnection conn = this.getChatConn(sess, name);
        if (conn == null) {
            return;
        }
        conn.close();
    }

    private void infoUpdate(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, AIMInputStream buffer) throws IOException {
        Chat roominfo = buffer.readRoomInfo();
        byte detaillevel = buffer.readByte();
        if (detaillevel != 2) {
            LOG.warn((Object)("detail level " + detaillevel + " not supported"));
            return;
        }
        TLVChain tlvchain = buffer.readTLVChain(buffer.readShort());
        String name = null;
        short userCount = 0;
        short flags = 0;
        TLV tlv = tlvchain.getTLV(106, 1);
        if (tlv != null) {
            name = tlv.getValueString();
        }
        if ((tlv = tlvchain.getTLV(111, 1)) != null) {
            userCount = tlv.getValueShort();
        }
        UserInfo userinfo = null;
        ArrayList<UserInfo> occupants = new ArrayList<UserInfo>(userCount);
        tlv = tlvchain.getTLV(115, 1);
        if (tlv != null) {
            short curoccupant = 0;
            while (curoccupant < userCount) {
                userinfo = buffer.readUserInfo();
                occupants.add(userinfo);
            }
        }
        if ((tlv = tlvchain.getTLV(201, 1)) != null) {
            flags = tlv.getValueShort();
        }
        int creationTime = 0;
        tlv = tlvchain.getTLV(202, 1);
        if (tlv != null) {
            creationTime = tlv.getValueInt();
        }
        short maxmsglen = 0;
        tlv = tlvchain.getTLV(209, 1);
        if (tlv != null) {
            maxmsglen = tlv.getValueShort();
        }
        short maxOccupancy = 0;
        tlv = tlvchain.getTLV(210, 1);
        if (tlv != null) {
            maxOccupancy = tlv.getValueShort();
        }
        String roomdesc = null;
        tlv = tlvchain.getTLV(211, 1);
        if (tlv != null) {
            roomdesc = tlv.getValueString();
        }
        if ((tlv = tlvchain.getTLV(212, 1)) != null) {
            LOG.warn((Object)("Unhandled TLV type=0x" + Integer.toHexString(212) + ", value=0x" + AIMUtil.byteArrayToHexString(tlv.getValue())));
        }
        byte creationPerms = 0;
        tlv = tlvchain.getTLV(213, 1);
        if (tlv != null) {
            creationPerms = tlv.getValueByte();
        }
        if ((tlv = tlvchain.getTLV(214, 1)) != null) {
            LOG.warn((Object)("Unhandled TLV type=0x" + Integer.toHexString(214) + ", value=0x" + AIMUtil.byteArrayToHexString(tlv.getValue())));
        }
        if ((tlv = tlvchain.getTLV(215, 1)) != null) {
            LOG.warn((Object)("Unhandled TLV type=0x" + Integer.toHexString(215) + ", value=0x" + AIMUtil.byteArrayToHexString(tlv.getValue())));
        }
        if ((tlv = tlvchain.getTLV(216, 1)) != null) {
            LOG.warn((Object)("Unhandled TLV type=0x" + Integer.toHexString(216) + ", value=0x" + AIMUtil.byteArrayToHexString(tlv.getValue())));
        }
        if ((tlv = tlvchain.getTLV(217, 1)) != null) {
            LOG.warn((Object)("Unhandled TLV type=0x" + Integer.toHexString(217) + ", value=0x" + AIMUtil.byteArrayToHexString(tlv.getValue())));
        }
        short maxvisiblemsglen = 0;
        tlv = tlvchain.getTLV(218, 1);
        if (tlv != null) {
            maxvisiblemsglen = tlv.getValueShort();
        }
        Iterator i = frame.getConn().getListeners(14, 2);
        while (i.hasNext()) {
            ((ChatListener)i.next()).infoUpdate(sess, frame, roominfo, name, userCount, occupants, roomdesc, flags, creationTime, maxmsglen, maxOccupancy, creationPerms, maxvisiblemsglen);
        }
    }

    private void userlistChange(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, AIMInputStream buffer) throws IOException {
        ArrayList<UserInfo> userinfo = new ArrayList<UserInfo>();
        while (!buffer.isEmpty()) {
            userinfo.add(buffer.readUserInfo());
        }
        Iterator i = frame.getConn().getListeners(14, snac.getSubtype());
        while (i.hasNext()) {
            ((ChatListener)i.next()).userlistChange(sess, frame, userinfo.size(), userinfo);
        }
    }

    public void sendIM(AIMSession sess, AIMConnection conn, int flags, String msg) throws IOException {
        if (sess == null || conn == null || msg == null) {
            throw new NullPointerException();
        }
        if (msg.length() <= 0) {
            throw new IllegalArgumentException();
        }
        FLAP flap = new FLAP(2);
        SNAC snac = new SNAC(14, 5, 0, null, false);
        MsgCookie cookie = new MsgCookie(conn, null, 5, null);
        TLVChain tlvchain = new TLVChain(4);
        tlvchain.addNull(1);
        if ((flags & 1) == 0) {
            tlvchain.addNull(6);
        }
        if ((flags & 2) != 0) {
            tlvchain.addNull(7);
        }
        TLVChain tlvchain2 = new TLVChain(1);
        tlvchain2.addString(1, msg);
        tlvchain.addTLVChain(5, tlvchain2);
        AIMOutputStream buffer = new AIMOutputStream(cookie.getCookie().length + 2 + tlvchain.length());
        buffer.writeBytes(cookie.getCookie());
        buffer.writeShort(3);
        buffer.writeTLVChain(tlvchain);
        conn.enqueueFrame(new AIMFrame(conn, 0, flap, snac, buffer));
    }

    private void incomingChatMsg(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, AIMInputStream buffer) throws IOException {
        AIMInputStream buffer2;
        TLVChain itl;
        UserInfo userinfo = null;
        MsgCookie cookie = new MsgCookie();
        byte[] ck = buffer.readBytes(8);
        cookie.setType(5);
        cookie.setCookie(ck);
        cookie = MsgCookie.uncacheCookie(frame.getConn(), cookie);
        if (cookie != null) {
            LOG.debug((Object)"incomingChatMsg had a cookie");
        } else {
            LOG.debug((Object)"incomingChatMsg didn't have a cookie");
        }
        short channel = buffer.readShort();
        if (channel != 3) {
            LOG.warn((Object)("Unknown channel=" + Integer.toHexString(channel)));
            return;
        }
        TLVChain otl = buffer.readTLVChain();
        TLV tlv = otl.getTLV(3, 1);
        if (tlv != null) {
            AIMInputStream buffer22 = new AIMInputStream(new ByteArrayInputStream(tlv.getValue()));
            userinfo = buffer22.readUserInfo();
        }
        if ((tlv = otl.getTLV(1, 1)) != null) {
            LOG.warn((Object)("Unhandled TLV type=0x" + Integer.toHexString(1) + ", value=0x" + AIMUtil.byteArrayToHexString(tlv.getValue())));
        }
        String msg = null;
        tlv = otl.getTLV(5, 1);
        if (tlv != null && (tlv = (itl = (buffer2 = new AIMInputStream(new ByteArrayInputStream(tlv.getValue()))).readTLVChain()).getTLV(1, 1)) != null) {
            msg = tlv.getValueString();
        }
        Iterator i = frame.getConn().getListeners(14, 6);
        while (i.hasNext()) {
            ((ChatListener)i.next()).incomingChatMsg(sess, frame, userinfo, msg);
        }
    }

    public void handleSNAC(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, AIMInputStream buffer) throws IOException {
        if (snac.getSubtype() == 2) {
            this.infoUpdate(sess, handler, frame, snac, buffer);
        } else if (snac.getSubtype() == 3 || snac.getSubtype() == 4) {
            this.userlistChange(sess, handler, frame, snac, buffer);
        } else if (snac.getSubtype() == 6) {
            this.incomingChatMsg(sess, handler, frame, snac, buffer);
        } else {
            LOG.warn((Object)("Unrecognized SNAC(" + Integer.toHexString(snac.getFamily()) + ", " + Integer.toHexString(snac.getSubtype()) + ")"));
            frame.setHandled(false);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

