/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.auth.permissions;

import com.ecyrd.jspwiki.auth.permissions.AllPermissionCollection;
import com.ecyrd.jspwiki.auth.permissions.PagePermission;
import java.io.Serializable;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Arrays;

public final class WikiPermission
extends Permission
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String CREATE_GROUPS_ACTION = "createGroups";
    public static final String CREATE_PAGES_ACTION = "createPages";
    public static final String LOGIN_ACTION = "login";
    public static final String EDIT_PREFERENCES_ACTION = "editPreferences";
    public static final String EDIT_PROFILE_ACTION = "editProfile";
    public static final String WILDCARD = "*";
    protected static final int CREATE_GROUPS_MASK = 1;
    protected static final int CREATE_PAGES_MASK = 2;
    protected static final int EDIT_PREFERENCES_MASK = 4;
    protected static final int EDIT_PROFILE_MASK = 8;
    protected static final int LOGIN_MASK = 16;
    public static final WikiPermission CREATE_GROUPS = new WikiPermission("*", "createGroups");
    public static final WikiPermission CREATE_PAGES = new WikiPermission("*", "createPages");
    public static final WikiPermission LOGIN = new WikiPermission("*", "login");
    public static final WikiPermission EDIT_PREFERENCES = new WikiPermission("*", "editPreferences");
    public static final WikiPermission EDIT_PROFILE = new WikiPermission("*", "editProfile");
    private final String m_actionString;
    private final String m_wiki;
    private final int m_mask;

    public WikiPermission(String wiki, String actions) {
        super(wiki);
        String[] pageActions = actions.toLowerCase().split(",");
        Arrays.sort(pageActions, String.CASE_INSENSITIVE_ORDER);
        this.m_mask = WikiPermission.createMask(actions);
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < pageActions.length; ++i) {
            buffer.append(pageActions[i]);
            if (i >= pageActions.length - 1) continue;
            buffer.append(",");
        }
        this.m_actionString = buffer.toString();
        this.m_wiki = wiki == null ? WILDCARD : wiki;
    }

    public final boolean equals(Object obj) {
        if (!(obj instanceof WikiPermission)) {
            return false;
        }
        WikiPermission p = (WikiPermission)obj;
        return p.m_mask == this.m_mask && p.m_wiki != null && p.m_wiki.equals(this.m_wiki);
    }

    public final String getActions() {
        return this.m_actionString;
    }

    public final String getWiki() {
        return this.m_wiki;
    }

    public final int hashCode() {
        return this.m_mask + 13 * this.m_actionString.hashCode() * 23 * this.m_wiki.hashCode();
    }

    public final boolean implies(Permission permission) {
        if (!(permission instanceof WikiPermission)) {
            return false;
        }
        WikiPermission p = (WikiPermission)permission;
        boolean impliedWiki = PagePermission.isSubset(this.m_wiki, p.m_wiki);
        int impliedMask = WikiPermission.impliedMask(this.m_mask);
        return impliedWiki && (impliedMask & p.m_mask) == p.m_mask;
    }

    public PermissionCollection newPermissionCollection() {
        return new AllPermissionCollection();
    }

    public final String toString() {
        return "(\"" + this.getClass().getName() + "\",\"" + this.m_wiki + "\",\"" + this.getActions() + "\")";
    }

    protected static final int impliedMask(int mask) {
        if ((mask & 1) > 0) {
            mask |= 2;
        }
        return mask;
    }

    protected static final int createMask(String actions) {
        if (actions == null || actions.length() == 0) {
            throw new IllegalArgumentException("Actions cannot be blank or null");
        }
        int mask = 0;
        String[] actionList = actions.split(",");
        for (int i = 0; i < actionList.length; ++i) {
            String action = actionList[i];
            if (action.equalsIgnoreCase(CREATE_GROUPS_ACTION)) {
                mask |= 1;
                continue;
            }
            if (action.equalsIgnoreCase(CREATE_PAGES_ACTION)) {
                mask |= 2;
                continue;
            }
            if (action.equalsIgnoreCase(LOGIN_ACTION)) {
                mask |= 0x10;
                continue;
            }
            if (action.equalsIgnoreCase(EDIT_PREFERENCES_ACTION)) {
                mask |= 4;
                continue;
            }
            if (action.equalsIgnoreCase(EDIT_PROFILE_ACTION)) {
                mask |= 8;
                continue;
            }
            throw new IllegalArgumentException("Unrecognized action: " + action);
        }
        return mask;
    }
}

