/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.XMLConversionPair;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.record.XMLRecord;

public class XMLField
extends DatabaseField {
    private NamespaceResolver namespaceResolver;
    private QName schemaType;
    private XPathFragment xPathFragment;
    private XPathFragment lastXPathFragment;
    private boolean isCDATA = false;
    private boolean isRequired = false;
    private boolean isInitialized = false;
    private boolean usesSingleNode;
    protected HashMap userXMLTypes;
    protected HashMap userJavaTypes;
    private boolean isTypedTextField = false;
    private QName leafElementType;

    public XMLField() {
    }

    public XMLField(String xPath) {
        super(xPath, new DatabaseTable());
    }

    public void initialize() {
        if (null != this.xPathFragment) {
            this.initializeXPathFragment(this.xPathFragment);
        }
        this.isInitialized = true;
    }

    private void initializeXPathFragment(XPathFragment xPathFragment) {
        XPathFragment nextXPathFragment;
        String localName = xPathFragment.getLocalName();
        if (localName != null && !localName.equals("") && null == xPathFragment.getNamespaceURI()) {
            if (xPathFragment.hasNamespace()) {
                if (null == this.namespaceResolver) {
                    throw XMLMarshalException.namespaceNotFound(xPathFragment.getShortName());
                }
                String uri = this.namespaceResolver.resolveNamespacePrefix(xPathFragment.getPrefix());
                if (null == uri && null != xPathFragment.getPrefix()) {
                    throw XMLMarshalException.namespaceNotFound(xPathFragment.getShortName());
                }
                xPathFragment.setNamespaceURI(uri);
            } else if (!xPathFragment.isAttribute() && null != this.namespaceResolver) {
                xPathFragment.setNamespaceURI(this.namespaceResolver.getDefaultNamespaceURI());
            }
        }
        if (null != (nextXPathFragment = xPathFragment.getNextFragment())) {
            this.initializeXPathFragment(nextXPathFragment);
        }
    }

    public String getXPath() {
        return this.getName();
    }

    public void setXPath(String xPath) {
        this.setName(xPath);
    }

    public NamespaceResolver getNamespaceResolver() {
        return this.namespaceResolver;
    }

    public void setNamespaceResolver(NamespaceResolver newNamespaceResolver) {
        this.namespaceResolver = newNamespaceResolver;
    }

    public void setUsesSingleNode(boolean usesSingleNode) {
        this.usesSingleNode = usesSingleNode;
    }

    public boolean usesSingleNode() {
        return this.usesSingleNode;
    }

    public void setSchemaType(QName value) {
        this.schemaType = value;
    }

    public QName getSchemaType() {
        return this.schemaType;
    }

    public boolean isTypedTextField() {
        return this.isTypedTextField;
    }

    public void setIsTypedTextField(boolean value) {
        this.isTypedTextField = value;
    }

    public boolean isSelfField() {
        if (null == this.xPathFragment) {
            return false;
        }
        return this.xPathFragment.isSelfFragment();
    }

    public boolean isUnionField() {
        return false;
    }

    public void setName(String xPath, String startDelimiter, String endDelimiter) {
        super.setName(xPath, null, null);
        if (this.hasPath(xPath)) {
            this.buildFragments(xPath);
        } else {
            XPathFragment xPathFragment = new XPathFragment(xPath.intern());
            xPathFragment.setXMLField(this);
            this.setXPathFragment(xPathFragment);
            this.setLastXPathFragment(xPathFragment);
        }
    }

    public void setName(String xPath) {
        this.setName(xPath, null, null);
    }

    private boolean hasPath(String xpathString) {
        return xpathString != null && xpathString.indexOf(47) != -1;
    }

    private void buildFragments(String xpathString) {
        String next;
        StringTokenizer st = new StringTokenizer(xpathString, "/");
        int i = 0;
        XPathFragment currentXPathFragment = null;
        XPathFragment nextXPathFragment = null;
        if (xpathString.charAt(0) == '/') {
            next = st.nextToken();
            next = '/' + next;
            currentXPathFragment = new XPathFragment(next);
            this.setXPathFragment(currentXPathFragment);
            currentXPathFragment.setXMLField(this);
            ++i;
        }
        while (st.hasMoreTokens()) {
            next = st.nextToken().intern();
            if (null != next) {
                nextXPathFragment = next.equals("text()") ? new XPathFragment("text()") : new XPathFragment(next);
                if (0 == i) {
                    this.setXPathFragment(nextXPathFragment);
                } else {
                    currentXPathFragment.setNextFragment(nextXPathFragment);
                    if (nextXPathFragment.isAttribute() || nextXPathFragment.nameIsText()) {
                        currentXPathFragment.setHasText(true);
                    }
                }
                nextXPathFragment.setXMLField(this);
                currentXPathFragment = nextXPathFragment;
                ++i;
            }
            this.setLastXPathFragment(currentXPathFragment);
        }
    }

    public XPathFragment getXPathFragment() {
        return this.xPathFragment;
    }

    public void setXPathFragment(XPathFragment xPathFragment) {
        this.xPathFragment = xPathFragment;
    }

    public XPathFragment getLastXPathFragment() {
        return this.lastXPathFragment;
    }

    public void setLastXPathFragment(XPathFragment lastXPathFragment) {
        this.lastXPathFragment = lastXPathFragment;
    }

    public Class getJavaClass(QName qname) {
        Class theClass;
        if (this.userXMLTypes != null && (theClass = (Class)this.userXMLTypes.get(qname)) != null) {
            return theClass;
        }
        return (Class)XMLConversionManager.getDefaultXMLTypes().get(qname);
    }

    public QName getXMLType(Class javaClass) {
        QName theQName;
        if (this.userJavaTypes != null && (theQName = (QName)this.userJavaTypes.get(javaClass)) != null) {
            return theQName;
        }
        return (QName)XMLConversionManager.getDefaultJavaTypes().get(javaClass);
    }

    private HashMap getUserJavaTypes() {
        if (this.userJavaTypes == null) {
            this.userJavaTypes = new HashMap();
        }
        return this.userJavaTypes;
    }

    private HashMap getUserXMLTypes() {
        if (this.userXMLTypes == null) {
            this.userXMLTypes = new HashMap();
        }
        return this.userXMLTypes;
    }

    public ArrayList getUserXMLTypesForDeploymentXML() {
        if (this.userXMLTypes != null) {
            ArrayList<XMLConversionPair> types = new ArrayList<XMLConversionPair>(this.userXMLTypes.size());
            for (Map.Entry entry : this.userXMLTypes.entrySet()) {
                XMLConversionPair pair = new XMLConversionPair((QName)entry.getKey(), ((Class)entry.getValue()).getName());
                types.add(pair);
            }
            return types;
        }
        return null;
    }

    public void setUserXMLTypesForDeploymentXML(ArrayList pairs) throws Exception {
        if (pairs.size() > 0) {
            this.userXMLTypes = new HashMap();
            for (XMLConversionPair pair : pairs) {
                if (pair.getXmlType() == null || pair.getJavaType() == null) continue;
                this.userXMLTypes.put(pair.getXmlType(), Class.forName(pair.getJavaType()));
            }
        }
    }

    public ArrayList getUserJavaTypesForDeploymentXML() {
        if (this.userJavaTypes != null) {
            ArrayList<XMLConversionPair> types = new ArrayList<XMLConversionPair>(this.userJavaTypes.size());
            for (Map.Entry entry : this.userJavaTypes.entrySet()) {
                XMLConversionPair pair = new XMLConversionPair((QName)entry.getValue(), ((Class)entry.getKey()).getName());
                types.add(pair);
            }
            return types;
        }
        return null;
    }

    public void setUserJavaTypesForDeploymentXML(ArrayList pairs) throws Exception {
        if (pairs.size() > 0) {
            this.userJavaTypes = new HashMap();
            for (XMLConversionPair pair : pairs) {
                if (pair.getXmlType() == null || pair.getJavaType() == null) continue;
                this.userJavaTypes.put(Class.forName(pair.getJavaType()), pair.getXmlType());
            }
        }
    }

    public Object convertValueBasedOnSchemaType(Object value, XMLConversionManager xmlConversionManager, XMLRecord record) {
        if (this.getSchemaType() != null) {
            if (XMLConstants.QNAME_QNAME.equals(this.getSchemaType())) {
                return this.buildQNameFromString((String)value, record);
            }
            Class fieldType = this.getType();
            if (fieldType == null) {
                fieldType = this.getJavaClass(this.getSchemaType());
            }
            return xmlConversionManager.convertObject(value, fieldType, this.getSchemaType());
        }
        return value;
    }

    protected QName buildQNameFromString(String stringValue, XMLRecord record) {
        int index = stringValue.lastIndexOf(58);
        if (index > -1) {
            String prefix = stringValue.substring(0, index);
            String localName = stringValue.substring(index + 1);
            String namespaceURI = record.resolveNamespacePrefix(prefix);
            return new QName(namespaceURI, localName, prefix);
        }
        String namespaceURI = record.resolveNamespacePrefix("");
        if (namespaceURI == null) {
            namespaceURI = record.resolveNamespacePrefix(null);
        }
        return new QName(namespaceURI, stringValue);
    }

    public void addXMLConversion(QName qname, Class javaClass) {
        this.getUserXMLTypes().put(qname, javaClass);
    }

    public void addJavaConversion(Class javaClass, QName qname) {
        this.getUserJavaTypes().put(javaClass, qname);
    }

    public void addConversion(QName qname, Class javaClass) {
        this.addJavaConversion(javaClass, qname);
        this.addXMLConversion(qname, javaClass);
    }

    public void removeXMLConversion(QName qname) {
        this.getUserXMLTypes().remove(qname);
    }

    public void removeJavaConversion(Class javaClass) {
        this.getUserJavaTypes().remove(javaClass);
    }

    public void removeConversion(QName qname, Class javaClass) {
        this.removeJavaConversion(javaClass);
        this.removeXMLConversion(qname);
    }

    public void setLeafElementType(QName type) {
        this.leafElementType = type;
        if (this.hasLastXPathFragment()) {
            this.getLastXPathFragment().setLeafElementType(type);
        }
    }

    public QName getLeafElementType() {
        if (this.hasLastXPathFragment()) {
            return this.getLastXPathFragment().getLeafElementType();
        }
        return this.leafElementType;
    }

    public boolean hasLastXPathFragment() {
        return this.getLastXPathFragment() != null;
    }

    public void setIsCDATA(boolean CDATA) {
        this.isCDATA = CDATA;
    }

    public boolean isCDATA() {
        return this.isCDATA;
    }

    public boolean isSchemaType(QName schemaType) {
        if (this.getSchemaType() == null) {
            return false;
        }
        return this.getSchemaType().equals(schemaType);
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public void setRequired(boolean isRequired) {
        this.isRequired = isRequired;
    }

    public boolean equals(Object object) {
        try {
            if (!this.isInitialized) {
                return super.equals(object);
            }
            if (this == object) {
                return true;
            }
            XMLField xmlField = (XMLField)object;
            if (!this.xPathFragment.equals(xmlField.getXPathFragment())) {
                return false;
            }
            XPathFragment xpf = this.xPathFragment;
            XPathFragment xpf2 = xmlField.getXPathFragment();
            while (xpf.getNextFragment() != null) {
                if ((xpf = xpf.getNextFragment()).equals(xpf2 = xpf2.getNextFragment())) continue;
                return false;
            }
            return null == xpf2.getNextFragment();
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public int hashCode() {
        if (null == this.xPathFragment) {
            return 1;
        }
        return this.xPathFragment.hashCode();
    }
}

