/*
 * Decompiled with CFR 0.152.
 */
package jodd.lagarto;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.CharBuffer;
import jodd.lagarto.LagartoException;
import jodd.lagarto.Token;

abstract class Lexer {
    public static final int YYEOF = -1;
    private static final int ZZ_BUFFERSIZE = 8192;
    public static final int SCRIPT = 8;
    public static final int YYINITIAL = 0;
    public static final int STYLE = 10;
    public static final int ATTR = 4;
    public static final int XML_DECLARATION = 12;
    public static final int XMP = 6;
    public static final int TAG = 2;
    public static final int DOCTYPE = 14;
    private static final int[] ZZ_LEXSTATE = new int[]{0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7};
    private static final String ZZ_CMAP_PACKED = "\b\u0000\u0002\u0013\u0001\u0013\u0001\u0000\u0002\u0013\u0012\u0000\u0001\u0013\u0001\u0002\u0001\u001c\u0004\u0000\u0001\u0019\u0005\u0000\u0001\b\u0001\u0000\u0001\u001a\f\u0000\u0001\u0001\u0001\u001b\u0001\u0007\u0001\u0012\u0001\u0000\u0001\u0011\u0001\u0000\u0001\r\u0001\u000b\u0001\t\u0001\u0005\u0002\u0000\u0001\u0004\u0002\u0000\u0001\u0018\u0001\u0015\u0001\n\u0001\f\u0001\u0010\u0001\u0000\u0001\u0017\u0001\u0016\u0001\u000e\u0003\u0000\u0001\u0014\u0001\u000f\u0001\u0000\u0001\u0003\u0001\u0000\u0001\u0006\u0003\u0000\u0001\u0011\u0001\u0000\u0001\r\u0001\u000b\u0001\t\u0001\u0005\u0002\u0000\u0001\u0004\u0002\u0000\u0001\u0018\u0001\u0015\u0001\n\u0001\f\u0001\u0010\u0001\u0000\u0001\u0017\u0001\u0016\u0001\u000e\u0003\u0000\u0001\u0014\u0001\u000f\uff86\u0000";
    private static final char[] ZZ_CMAP = Lexer.zzUnpackCMap("\b\u0000\u0002\u0013\u0001\u0013\u0001\u0000\u0002\u0013\u0012\u0000\u0001\u0013\u0001\u0002\u0001\u001c\u0004\u0000\u0001\u0019\u0005\u0000\u0001\b\u0001\u0000\u0001\u001a\f\u0000\u0001\u0001\u0001\u001b\u0001\u0007\u0001\u0012\u0001\u0000\u0001\u0011\u0001\u0000\u0001\r\u0001\u000b\u0001\t\u0001\u0005\u0002\u0000\u0001\u0004\u0002\u0000\u0001\u0018\u0001\u0015\u0001\n\u0001\f\u0001\u0010\u0001\u0000\u0001\u0017\u0001\u0016\u0001\u000e\u0003\u0000\u0001\u0014\u0001\u000f\u0001\u0000\u0001\u0003\u0001\u0000\u0001\u0006\u0003\u0000\u0001\u0011\u0001\u0000\u0001\r\u0001\u000b\u0001\t\u0001\u0005\u0002\u0000\u0001\u0004\u0002\u0000\u0001\u0018\u0001\u0015\u0001\n\u0001\f\u0001\u0010\u0001\u0000\u0001\u0017\u0001\u0016\u0001\u000e\u0003\u0000\u0001\u0014\u0001\u000f\uff86\u0000");
    private static final int[] ZZ_ACTION = Lexer.zzUnpackAction();
    private static final String ZZ_ACTION_PACKED_0 = "\u0001\u0000\u0001\u0001\u0006\u0000\u0001\u0002\u0001\u0003\u0001\u0001\u0001\u0004\u0001\u0005\u0002\u0001\u0001\u0006\u0001\u0007\u0001\b\u0001\u0006\u0001\u0007\u0001\t\u0001\n\u0007\u0007\u0001\u000b\u0001\u0007\u0001\u0000\u0001\f\u0003\u0001\u0001\r\u0001\u0000\u0001\u000e\u000b\u0000\u0001\u0006\u0003\u0000\u0001\u000f\u0002\u0001\b\u0000\u0002\u0001\n\u0000\u0001\u0001\u0001\u0010\n\u0000\u0001\u0011\u0001\u0012\u0002\u0000\u0001\u0013\u0004\u0000\u0001\u0014\t\u0000\u0001\u0015\u0001\u0016\u0006\u0000\u0001\u0017\u0002\u0000\u0001\u0016\u0002\u0000";
    private static final int[] ZZ_ROWMAP = Lexer.zzUnpackRowMap();
    private static final String ZZ_ROWMAP_PACKED_0 = "\u0000\u0000\u0000\u001d\u0000:\u0000W\u0000t\u0000\u0091\u0000\u00ae\u0000\u00cb\u0000\u00e8\u0000\u0105\u0000\u0122\u0000\u013f\u0000\u015c\u0000\u0179\u0000\u0196\u0000\u01b3\u0000\u013f\u0000\u013f\u0000\u01d0\u0000\u01ed\u0000\u013f\u0000\u013f\u0000\u020a\u0000\u0227\u0000\u0244\u0000\u0261\u0000\u027e\u0000\u029b\u0000\u02b8\u0000\u013f\u0000\u02d5\u0000\u02f2\u0000\u013f\u0000\u030f\u0000\u032c\u0000\u0349\u0000\u013f\u0000\u01ed\u0000\u013f\u0000\u020a\u0000\u0227\u0000\u0244\u0000\u0366\u0000\u0261\u0000\u027e\u0000\u0383\u0000\u029b\u0000\u02b8\u0000\u03a0\u0000\u02d5\u0000\u013f\u0000\u03bd\u0000\u03da\u0000\u03f7\u0000\u0122\u0000\u0414\u0000\u0431\u0000\u044e\u0000\u046b\u0000\u0488\u0000\u04a5\u0000\u04c2\u0000\u04df\u0000\u04fc\u0000\u0519\u0000\u0536\u0000\u0553\u0000\u0570\u0000\u058d\u0000\u05aa\u0000\u05c7\u0000\u05e4\u0000\u0601\u0000\u061e\u0000\u063b\u0000\u0658\u0000\u0675\u0000\u0692\u0000\u0122\u0000\u06af\u0000\u06cc\u0000\u06e9\u0000\u0706\u0000\u0723\u0000\u0740\u0000\u075d\u0000\u077a\u0000\u0797\u0000\u07b4\u0000\u0122\u0000\u013f\u0000\u07d1\u0000\u07ee\u0000\u013f\u0000\u080b\u0000\u0828\u0000\u0845\u0000\u0862\u0000\u013f\u0000\u087f\u0000\u089c\u0000\u08b9\u0000\u08d6\u0000\u08f3\u0000\u0910\u0000\u092d\u0000\u094a\u0000\u0967\u0000\u013f\u0000\u013f\u0000\u0984\u0000\u09a1\u0000\u09be\u0000\u09db\u0000\u09f8\u0000\u0a15\u0000\u013f\u0000\u0a32\u0000\u0a4f\u0000\u063b\u0000\u0a6c\u0000\u0a89";
    private static final int[] ZZ_TRANS = new int[]{8, 9, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 10, 10, 10, 10, 10, 10, 11, 11, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 11, 12, 13, 10, 14, 10, 10, 11, 11, 11, 11, 15, 15, 15, 15, 15, 15, 16, 17, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 18, 12, 15, 15, 15, 15, 15, 19, 20, 21, 22, 23, 24, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 25, 26, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 27, 28, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 15, 15, 15, 15, 15, 15, 16, 29, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 12, 15, 15, 15, 15, 15, 16, 16, 16, 30, 8, -1, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, -1, -1, 31, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 32, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, 10, 10, 10, 10, 10, -1, -1, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, -1, -1, 10, 10, 10, 10, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 12, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, 10, 10, 10, 10, 10, -1, -1, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, -1, -1, 10, 33, 10, 10, 10, -1, -1, -1, -1, 10, 10, 10, 10, 10, 10, -1, -1, 10, 10, 10, 10, 10, 34, 35, 10, 10, 10, -1, -1, 10, 10, 10, 10, 10, -1, -1, -1, -1, 15, 15, 15, 15, 15, 15, -1, -1, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, -1, 15, 15, 15, 15, 15, 15, -1, -1, 15, 15, 15, 15, 15, 15, 15, -1, 36, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, -1, 15, 15, 15, 15, 15, 15, -1, -1, 15, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 38, 37, 37, 37, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 38, 40, 41, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 41, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 42, 40, 40, 43, 44, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 44, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 45, 43, 43, 46, 47, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 47, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 48, 46, 46, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 50, -1, -1, -1, 51, -1, -1, -1, -1, 52, -1, -1, 53, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, 10, 10, 10, 10, 10, -1, -1, 10, 10, 10, 10, 10, 10, 10, 10, 54, 10, -1, -1, 10, 10, 10, 10, 10, -1, -1, -1, -1, 10, 10, 10, 10, 10, 10, -1, -1, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, -1, -1, 10, 10, 10, 55, 10, -1, -1, -1, -1, 10, 10, 10, 10, 10, 10, -1, -1, 10, 10, 10, 10, 10, 10, 10, 56, 10, 10, -1, -1, 10, 10, 10, 10, 10, -1, -1, -1, -1, 40, 41, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 57, 40, 40, 40, 40, 40, 40, 40, 40, 43, 44, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 58, 43, 43, 43, 43, 43, 43, 46, 47, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 59, 46, 46, 46, 46, 46, 46, -1, -1, -1, -1, 60, -1, -1, -1, -1, 61, -1, -1, -1, 62, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 63, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 64, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, 10, 10, 10, 65, 10, -1, -1, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, -1, -1, 10, 10, 10, 10, 10, -1, -1, -1, -1, 10, 10, 10, 10, 10, 10, -1, -1, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, -1, -1, 10, 10, 10, 10, 66, -1, -1, -1, -1, 40, 41, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 67, 40, 40, 40, 40, 40, 40, 40, 43, 44, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 68, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 46, 47, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 69, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, -1, -1, -1, -1, -1, 70, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 71, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 72, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 63, 73, 63, 63, 63, 63, 63, 74, 75, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 76, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, 10, 10, 10, 10, 10, -1, -1, 10, 10, 10, 10, 10, 10, 10, 10, 77, 10, -1, -1, 10, 10, 10, 10, 10, -1, -1, -1, -1, 10, 10, 10, 10, 10, 10, -1, -1, 10, 78, 10, 10, 10, 10, 10, 10, 10, 10, -1, -1, 10, 10, 10, 10, 10, -1, -1, -1, -1, 40, 41, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 79, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 43, 44, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 80, 43, 43, 43, 43, 43, 46, 47, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 81, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 70, 70, 70, 70, 70, 70, 82, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 83, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 84, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 63, 73, 85, 63, 63, 63, 63, 74, 75, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 74, 74, 74, 74, 74, 74, 74, 74, 86, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 63, 73, 63, 63, 63, 63, 63, 74, 87, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 88, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, 10, 10, 10, 10, 10, -1, -1, 10, 10, 10, 10, 10, 10, 89, 10, 10, 10, -1, -1, 10, 10, 10, 10, 10, -1, -1, -1, -1, 79, 79, 79, 79, 79, 79, 79, 90, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 43, 44, 43, 43, 91, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 46, 47, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 92, 46, 46, 46, 46, -1, -1, -1, -1, -1, -1, -1, 93, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 94, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 95, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 63, 73, 63, 96, 63, 63, 63, 74, 75, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 74, 74, 74, 74, 74, 74, 74, 74, 97, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 63, 73, 63, 63, 63, 63, 63, 98, 87, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 99, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 43, 44, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 100, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 46, 47, 46, 46, 46, 46, 46, 46, 46, 79, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, -1, -1, -1, -1, -1, 101, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 102, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 63, 73, 63, 63, 63, 63, 63, 74, 75, 103, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 74, 74, 74, 74, 74, 74, 74, 98, 97, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 104, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 43, 44, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 79, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, -1, -1, -1, -1, -1, -1, 105, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 106, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 63, 73, 63, 63, 63, 63, 63, 74, 75, 63, 107, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, -1, -1, -1, -1, -1, -1, -1, -1, -1, 108, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 109, 110, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 106, 106, 106, 106, 106, 106, 111, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 63, 73, 63, 63, 63, 63, 63, 74, 75, 63, 63, 112, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, -1, -1, -1, -1, -1, -1, -1, -1, 113, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 106, 106, 106, 106, 106, 106, 114, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 63, 73, 63, 63, 115, 63, 63, 74, 75, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, -1, -1, -1, -1, -1, -1, -1, 109, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 106, 106, 106, 106, 106, 106, 114, 116, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 63, 73, 63, 63, 63, 117, 63, 74, 75, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 73, 63, 63, 63, 63, 118, 74, 75, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 73, 63, 63, 63, 63, 63, 119, 120, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 73, 63, 63, 63, 63, 63, 74, 121, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 73, 63, 63, 63, 63, 63, 109, 87, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63};
    private static final int ZZ_UNKNOWN_ERROR = 0;
    private static final int ZZ_NO_MATCH = 1;
    private static final int ZZ_PUSHBACK_2BIG = 2;
    private static final String[] ZZ_ERROR_MSG = new String[]{"Unkown internal scanner error", "Error: could not match input", "Error: pushback value was too large"};
    private static final int[] ZZ_ATTRIBUTE = Lexer.zzUnpackAttribute();
    private static final String ZZ_ATTRIBUTE_PACKED_0 = "\u0001\u0000\u0001\u0001\u0006\u0000\u0003\u0001\u0001\t\u0004\u0001\u0002\t\u0002\u0001\u0002\t\u0007\u0001\u0001\t\u0001\u0001\u0001\u0000\u0001\t\u0003\u0001\u0001\t\u0001\u0000\u0001\t\u000b\u0000\u0001\t\u0003\u0000\u0003\u0001\b\u0000\u0002\u0001\n\u0000\u0002\u0001\n\u0000\u0001\u0001\u0001\t\u0002\u0000\u0001\t\u0004\u0000\u0001\t\t\u0000\u0002\t\u0006\u0000\u0001\t\u0002\u0000\u0001\u0001\u0002\u0000";
    private Reader zzReader;
    private int zzState;
    private int zzLexicalState = 0;
    private char[] zzBuffer = new char[8192];
    private int zzMarkedPos;
    private int zzCurrentPos;
    private int zzStartRead;
    private int zzEndRead;
    private int yyline;
    private int yychar;
    private int yycolumn;
    private boolean zzAtBOL = true;
    private boolean zzAtEOF;
    private boolean zzEOFDone;
    int nextTagState;
    boolean parseSpecialTagsAsCdata = true;

    private static int[] zzUnpackAction() {
        int[] result = new int[122];
        int offset = 0;
        offset = Lexer.zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAction(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackRowMap() {
        int[] result = new int[122];
        int offset = 0;
        offset = Lexer.zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackRowMap(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int high = packed.charAt(i++) << 16;
            result[j++] = high | packed.charAt(i++);
        }
        return j;
    }

    private static int[] zzUnpackAttribute() {
        int[] result = new int[122];
        int offset = 0;
        offset = Lexer.zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAttribute(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    public int position() {
        return this.yychar;
    }

    public int length() {
        return this.yylength();
    }

    public int line() {
        return -1;
    }

    public int column() {
        return -1;
    }

    void stateReset() {
        this.yybegin(0);
    }

    void stateTag() {
        this.yybegin(2);
    }

    void stateAttr() {
        this.yybegin(4);
    }

    void stateXmp() {
        this.yybegin(6);
    }

    void stateScript() {
        this.yybegin(8);
    }

    void stateStyle() {
        this.yybegin(10);
    }

    void stateDoctype() {
        this.yybegin(14);
    }

    public final CharSequence xxtext() {
        return CharBuffer.wrap(this.zzBuffer, this.zzStartRead, this.zzMarkedPos - this.zzStartRead);
    }

    public final String yytext(int startIndex) {
        return new String(this.zzBuffer, startIndex += this.zzStartRead, this.zzMarkedPos - startIndex);
    }

    public final String yytext(int startIndex, int endIndexOffset) {
        return new String(this.zzBuffer, startIndex += this.zzStartRead, this.zzMarkedPos - endIndexOffset - startIndex);
    }

    int getNextTagState() {
        return this.nextTagState;
    }

    public void setParseSpecialTagsAsCdata(boolean parseSpecialTagsAsCdata) {
        this.parseSpecialTagsAsCdata = parseSpecialTagsAsCdata;
    }

    Lexer(Reader in) {
        this.zzReader = in;
    }

    Lexer(InputStream in) {
        this(new InputStreamReader(in));
    }

    private static char[] zzUnpackCMap(String packed) {
        char[] map = new char[65536];
        int i = 0;
        int j = 0;
        while (i < 138) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                map[j++] = value;
            } while (--count > 0);
        }
        return map;
    }

    private boolean zzRefill() throws IOException {
        int numRead;
        if (this.zzStartRead > 0) {
            System.arraycopy(this.zzBuffer, this.zzStartRead, this.zzBuffer, 0, this.zzEndRead - this.zzStartRead);
            this.zzEndRead -= this.zzStartRead;
            this.zzCurrentPos -= this.zzStartRead;
            this.zzMarkedPos -= this.zzStartRead;
            this.zzStartRead = 0;
        }
        if (this.zzCurrentPos >= this.zzBuffer.length) {
            char[] newBuffer = new char[this.zzCurrentPos * 2];
            System.arraycopy(this.zzBuffer, 0, newBuffer, 0, this.zzBuffer.length);
            this.zzBuffer = newBuffer;
        }
        if ((numRead = this.zzReader.read(this.zzBuffer, this.zzEndRead, this.zzBuffer.length - this.zzEndRead)) > 0) {
            this.zzEndRead += numRead;
            return false;
        }
        if (numRead == 0) {
            int c = this.zzReader.read();
            if (c == -1) {
                return true;
            }
            this.zzBuffer[this.zzEndRead++] = (char)c;
            return false;
        }
        return true;
    }

    public final void yyclose() throws IOException {
        this.zzAtEOF = true;
        this.zzEndRead = this.zzStartRead;
        if (this.zzReader != null) {
            this.zzReader.close();
        }
    }

    public final void yyreset(Reader reader) {
        this.zzReader = reader;
        this.zzAtBOL = true;
        this.zzAtEOF = false;
        this.zzEOFDone = false;
        this.zzStartRead = 0;
        this.zzEndRead = 0;
        this.zzMarkedPos = 0;
        this.zzCurrentPos = 0;
        this.yycolumn = 0;
        this.yychar = 0;
        this.yyline = 0;
        this.zzLexicalState = 0;
    }

    public final int yystate() {
        return this.zzLexicalState;
    }

    public final void yybegin(int newState) {
        this.zzLexicalState = newState;
    }

    public final String yytext() {
        return new String(this.zzBuffer, this.zzStartRead, this.zzMarkedPos - this.zzStartRead);
    }

    public final char yycharat(int pos) {
        return this.zzBuffer[this.zzStartRead + pos];
    }

    public final int yylength() {
        return this.zzMarkedPos - this.zzStartRead;
    }

    private void zzScanError(int errorCode) {
        String message;
        try {
            message = ZZ_ERROR_MSG[errorCode];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            message = ZZ_ERROR_MSG[0];
        }
        throw new Error(message);
    }

    public void yypushback(int number) {
        if (number > this.yylength()) {
            this.zzScanError(2);
        }
        this.zzMarkedPos -= number;
    }

    private void zzDoEOF() throws IOException {
        if (!this.zzEOFDone) {
            this.zzEOFDone = true;
            this.yyclose();
        }
    }

    public Token nextToken() throws IOException {
        int zzEndReadL = this.zzEndRead;
        char[] zzBufferL = this.zzBuffer;
        char[] zzCMapL = ZZ_CMAP;
        int[] zzTransL = ZZ_TRANS;
        int[] zzRowMapL = ZZ_ROWMAP;
        int[] zzAttrL = ZZ_ATTRIBUTE;
        block48: while (true) {
            int zzInput;
            int zzMarkedPosL = this.zzMarkedPos;
            this.yychar += zzMarkedPosL - this.zzStartRead;
            int zzAction = -1;
            this.zzCurrentPos = this.zzStartRead = zzMarkedPosL;
            int zzCurrentPosL = this.zzStartRead;
            this.zzState = ZZ_LEXSTATE[this.zzLexicalState];
            int zzAttributes = zzAttrL[this.zzState];
            if ((zzAttributes & 1) == 1) {
                zzAction = this.zzState;
            }
            while (true) {
                if (zzCurrentPosL < zzEndReadL) {
                    zzInput = zzBufferL[zzCurrentPosL++];
                } else {
                    if (this.zzAtEOF) {
                        zzInput = -1;
                        break;
                    }
                    this.zzCurrentPos = zzCurrentPosL;
                    this.zzMarkedPos = zzMarkedPosL;
                    boolean eof = this.zzRefill();
                    zzCurrentPosL = this.zzCurrentPos;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    zzEndReadL = this.zzEndRead;
                    if (eof) {
                        zzInput = -1;
                        break;
                    }
                    zzInput = zzBufferL[zzCurrentPosL++];
                }
                int zzNext = zzTransL[zzRowMapL[this.zzState] + zzCMapL[zzInput]];
                if (zzNext == -1) break;
                this.zzState = zzNext;
                zzAttributes = zzAttrL[this.zzState];
                if ((zzAttributes & 1) != 1) continue;
                zzAction = this.zzState;
                zzMarkedPosL = zzCurrentPosL;
                if ((zzAttributes & 8) == 8) break;
            }
            this.zzMarkedPos = zzMarkedPosL;
            switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
                case 8: {
                    this.yybegin(this.nextTagState);
                    return Token.GT;
                }
                case 24: {
                    continue block48;
                }
                case 23: {
                    return Token.CDATA;
                }
                case 25: {
                    continue block48;
                }
                case 13: {
                    this.stateReset();
                    return Token.XML_GT;
                }
                case 26: {
                    continue block48;
                }
                case 4: {
                    this.yypushback(1);
                    this.stateAttr();
                    return Token.WHITESPACE;
                }
                case 27: {
                    continue block48;
                }
                case 16: {
                    if (this.parseSpecialTagsAsCdata) {
                        this.nextTagState = 10;
                    }
                    this.stateAttr();
                    return Token.WORD;
                }
                case 28: {
                    continue block48;
                }
                case 14: {
                    return Token.QUOTE;
                }
                case 29: {
                    continue block48;
                }
                case 17: {
                    if (this.parseSpecialTagsAsCdata) {
                        this.nextTagState = 8;
                    }
                    this.stateAttr();
                    return Token.WORD;
                }
                case 30: {
                    continue block48;
                }
                case 6: {
                    return Token.WORD;
                }
                case 31: {
                    continue block48;
                }
                case 9: {
                    return Token.SLASH;
                }
                case 32: {
                    continue block48;
                }
                case 12: {
                    this.nextTagState = 0;
                    this.stateTag();
                    return Token.XML_LT;
                }
                case 33: {
                    continue block48;
                }
                case 18: {
                    this.stateReset();
                    return Token.TEXT;
                }
                case 34: {
                    continue block48;
                }
                case 10: {
                    return Token.EQUALS;
                }
                case 35: {
                    continue block48;
                }
                case 5: {
                    return Token.WHITESPACE;
                }
                case 36: {
                    continue block48;
                }
                case 15: {
                    if (this.parseSpecialTagsAsCdata) {
                        this.nextTagState = 6;
                    }
                    this.stateAttr();
                    return Token.WORD;
                }
                case 37: {
                    continue block48;
                }
                case 2: {
                    return Token.TEXT;
                }
                case 38: {
                    continue block48;
                }
                case 22: {
                    return Token.CONDITIONAL_COMMENT_END;
                }
                case 39: {
                    continue block48;
                }
                case 21: {
                    this.stateDoctype();
                    return Token.DOCTYPE;
                }
                case 40: {
                    continue block48;
                }
                case 3: {
                    this.nextTagState = 0;
                    this.stateTag();
                    return Token.LT;
                }
                case 41: {
                    continue block48;
                }
                case 11: {
                    this.stateReset();
                    return Token.GT;
                }
                case 42: {
                    continue block48;
                }
                case 7: {
                    throw new LagartoException("Illegal character [" + this.yytext() + ']', this.yystate(), this.line(), this.column());
                }
                case 43: {
                    continue block48;
                }
                case 19: {
                    return Token.CONDITIONAL_COMMENT_START;
                }
                case 44: {
                    continue block48;
                }
                case 20: {
                    return Token.COMMENT;
                }
                case 45: {
                    continue block48;
                }
                case 1: {
                    this.stateAttr();
                    return Token.WORD;
                }
                case 46: {
                    continue block48;
                }
            }
            if (zzInput == -1 && this.zzStartRead == this.zzCurrentPos) {
                this.zzAtEOF = true;
                this.zzDoEOF();
                return Token.EOF;
            }
            this.zzScanError(1);
        }
    }
}

