/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.grs.store.buffer.multiplex;

import gr.uoa.di.madgik.grs.GRS2Exception;
import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.events.BufferEvent;
import gr.uoa.di.madgik.grs.reader.ForwardReader;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.store.buffer.BufferStoreEntry;
import gr.uoa.di.madgik.grs.store.buffer.GRS2BufferStoreAccessException;
import gr.uoa.di.madgik.grs.store.buffer.GRS2BufferStoreException;
import gr.uoa.di.madgik.grs.store.buffer.IBufferStore;
import gr.uoa.di.madgik.grs.store.buffer.multiplex.IMultiplex;
import gr.uoa.di.madgik.grs.store.buffer.multiplex.TimeStruct;
import java.util.ArrayList;

public class FirstAvailableMultiplex
implements IMultiplex {
    private ArrayList<BufferStoreEntry> entries = null;
    private ArrayList<BufferStoreEntry> activeEntries = null;
    private TimeStruct timeout = new TimeStruct(10L, ForwardReader.DefaultIteratorTimeUnit);
    private IBufferStore bufferStore = null;
    private Object modificationNotify = null;

    @Override
    public void setModificationNotify(Object notify) {
        this.modificationNotify = notify;
    }

    @Override
    public void setEntries(ArrayList<BufferStoreEntry> entries) {
        this.entries = entries;
        this.activeEntries = new ArrayList<BufferStoreEntry>(entries);
        for (BufferStoreEntry entry : this.entries) {
            TimeStruct str = new TimeStruct(entry.getReaderTimeout(), entry.getReaderTimeoutTimeUnit());
            if (this.timeout.compareTo(str) <= 0) continue;
            this.timeout = str;
        }
    }

    @Override
    public void setBufferStore(IBufferStore bufferStore) {
        this.bufferStore = bufferStore;
    }

    @Override
    public void dispose() {
        if (this.activeEntries != null) {
            this.activeEntries.clear();
            this.activeEntries = null;
        }
        this.timeout = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void multiplex() throws GRS2BufferStoreException {
        try {
            ArrayList<BufferStoreEntry> inactive = new ArrayList<BufferStoreEntry>();
            while (this.activeEntries.size() != 0) {
                BufferEvent event;
                inactive.clear();
                boolean foundSome = false;
                block15: for (BufferStoreEntry entry : this.activeEntries) {
                    if (entry.getReader().getStatus() == IBuffer.Status.Dispose || entry.getReader().getStatus() == IBuffer.Status.Close && entry.getReader().availableRecords() == 0) {
                        while (entry.getReader().getStatus() != IBuffer.Status.Dispose && (event = entry.getReader().receive()) != null) {
                            entry.getEventManager().persist(event);
                        }
                        inactive.add(entry);
                        continue;
                    }
                    while (true) {
                        BufferEvent event2;
                        this.bufferStore.markActivity();
                        Record rec = entry.getReader().get();
                        if (rec == null) continue block15;
                        foundSome = true;
                        entry.getRecordManager().persist(rec);
                        while ((event2 = entry.getReader().receive()) != null) {
                            entry.getEventManager().persist(event2);
                        }
                        Object object = this.modificationNotify;
                        synchronized (object) {
                            this.modificationNotify.notifyAll();
                        }
                    }
                }
                for (BufferStoreEntry entry : inactive) {
                    while (entry.getReader().getStatus() != IBuffer.Status.Dispose && (event = entry.getReader().receive()) != null) {
                        entry.getEventManager().persist(event);
                    }
                    this.bufferStore.markActivity();
                    this.activeEntries.remove(entry);
                    entry.getReader().close();
                    entry.setStatus(BufferStoreEntry.EntryStatus.Close);
                }
                Object object = this.modificationNotify;
                synchronized (object) {
                    this.modificationNotify.notifyAll();
                }
                if (!foundSome && this.activeEntries.size() > 0) {
                    this.activeEntries.get(0).getReader().waitAvailable(this.timeout.timeout, this.timeout.unit);
                }
                this.bufferStore.markActivity();
                object = this.modificationNotify;
                synchronized (object) {
                    this.modificationNotify.notifyAll();
                }
            }
            this.bufferStore.markActivity();
            Object object = this.modificationNotify;
            synchronized (object) {
                this.modificationNotify.notifyAll();
            }
        }
        catch (GRS2Exception ex) {
            throw new GRS2BufferStoreAccessException("Could not complete multiplexing operation", ex);
        }
    }
}

