/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.notification;

import java.rmi.RemoteException;
import java.util.List;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.util.I18n;
import org.globus.wsrf.NoSuchResourceException;
import org.globus.wsrf.NotificationConsumerCallbackManager;
import org.globus.wsrf.NotifyCallback;
import org.globus.wsrf.Resource;
import org.globus.wsrf.ResourceContext;
import org.globus.wsrf.impl.TopicExpressionEngineImpl;
import org.globus.wsrf.topicexpression.TopicExpressionEngine;
import org.globus.wsrf.utils.AnyHelper;
import org.globus.wsrf.utils.Resources;
import org.oasis.wsn.NotificationMessageHolderType;
import org.oasis.wsn.Notify;
import org.oasis.wsn.ResourceUnknownFaultType;
import org.oasis.wsn.TopicExpressionType;

public class NotificationConsumerProvider {
    static Log logger = LogFactory.getLog(NotificationConsumerProvider.class.getName());
    private static I18n i18n = I18n.getI18n(Resources.class.getName());

    public void notify(Notify request) throws RemoteException {
        NotificationMessageHolderType[] notifications = request.getNotificationMessage();
        Resource resource = null;
        try {
            resource = ResourceContext.getResourceContext().getResource();
        }
        catch (NoSuchResourceException e) {
            throw new ResourceUnknownFaultType();
        }
        catch (Exception e) {
            throw new RemoteException(i18n.getMessage("resourceDisoveryFailed"), e);
        }
        NotificationConsumerCallbackManager manager = (NotificationConsumerCallbackManager)resource;
        TopicExpressionEngine topicExpressionEngine = TopicExpressionEngineImpl.getInstance();
        NotifyCallback defaultCallback = manager.getCallback(null);
        if (logger.isDebugEnabled()) {
            logger.debug("Invoked with " + String.valueOf(notifications.length) + " notification message(s)");
        }
        for (int i = 0; i < notifications.length; ++i) {
            TopicExpressionType topicExpression = notifications[i].getTopic();
            EndpointReferenceType producer = notifications[i].getProducerReference();
            Object message = notifications[i].getMessage();
            try {
                List topicPath;
                NotifyCallback callback;
                if (logger.isDebugEnabled()) {
                    logger.debug("Got notification on topic: " + topicExpression.toString());
                    logger.debug("With dialect " + topicExpression.getDialect().toString());
                    logger.debug("From producer at " + producer.getAddress());
                    if (producer.getProperties() != null && producer.getProperties().get_any() != null) {
                        String value = AnyHelper.toSingleString(producer.getProperties());
                        logger.debug("With resource ids " + value);
                    }
                    logger.debug("Notification message: " + message);
                }
                if ((callback = manager.getCallback(topicPath = topicExpressionEngine.getConcretePath(topicExpression))) == null) {
                    callback = defaultCallback;
                }
                if (callback == null) continue;
                callback.deliver(topicPath, producer, message);
                continue;
            }
            catch (Exception e) {
                logger.warn(i18n.getMessage("notifyCallbackError"), e);
                throw new RemoteException(i18n.getMessage("notifyCallbackError"), e);
            }
        }
    }
}

