/*
 * Decompiled with CFR 0.152.
 */
package javax.wsdl;

import java.io.PrintWriter;
import java.io.StringWriter;

public class WSDLException
extends Exception {
    public static final long serialVersionUID = 1L;
    public static final String INVALID_WSDL = "INVALID_WSDL";
    public static final String PARSER_ERROR = "PARSER_ERROR";
    public static final String OTHER_ERROR = "OTHER_ERROR";
    public static final String CONFIGURATION_ERROR = "CONFIGURATION_ERROR";
    public static final String UNBOUND_PREFIX = "UNBOUND_PREFIX";
    public static final String NO_PREFIX_SPECIFIED = "NO_PREFIX_SPECIFIED";
    private String faultCode = null;
    private Throwable targetThrowable = null;
    private String location = null;

    public WSDLException(String faultCode, String msg) {
        this(faultCode, msg, null);
    }

    public WSDLException(String faultCode, String msg, Throwable t) {
        super(msg);
        this.setFaultCode(faultCode);
        this.setTargetException(t);
    }

    public String getFaultCode() {
        return this.faultCode;
    }

    public String getLocation() {
        return this.location;
    }

    public String getMessage() {
        String targetMsg;
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("WSDLException");
        if (this.location != null) {
            try {
                strBuf.append(" (at " + this.location + ")");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        if (this.faultCode != null) {
            strBuf.append(": faultCode=" + this.faultCode);
        }
        String thisMsg = super.getMessage();
        String string = targetMsg = this.targetThrowable != null ? this.targetThrowable.getMessage() : null;
        if (!(thisMsg == null || targetMsg != null && thisMsg.equals(targetMsg))) {
            strBuf.append(": " + thisMsg);
        }
        if (targetMsg != null) {
            strBuf.append(": " + targetMsg);
        }
        return strBuf.toString();
    }

    public Throwable getTargetException() {
        return this.targetThrowable;
    }

    public void setFaultCode(String faultCode) {
        this.faultCode = faultCode;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setTargetException(Throwable targetThrowable) {
        this.targetThrowable = targetThrowable;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.print(String.valueOf(this.getMessage()) + ": ");
        if (this.targetThrowable != null) {
            this.targetThrowable.printStackTrace(pw);
        }
        return sw.toString();
    }
}

