/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.virtualplatform.image;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.virtualplatform.image.PlatformConfiguration;

public final class Platforms {
    private static GCUBELog logger = new GCUBELog(Platforms.class);

    public static List<PlatformConfiguration> listAvailablePlatforms(File file) {
        if (!file.isDirectory()) {
            return Collections.emptyList();
        }
        ArrayList<PlatformConfiguration> arrayList = new ArrayList<PlatformConfiguration>();
        Platforms.scanFolder(file, arrayList);
        return Collections.unmodifiableList(arrayList);
    }

    private static void scanFolder(File file, List<PlatformConfiguration> list) {
        logger.debug((Object)("Scanning folder " + file.getAbsolutePath()));
        for (File file2 : file.listFiles()) {
            if (file2.isDirectory()) {
                Platforms.scanFolder(file2, list);
                continue;
            }
            if (!file2.getAbsolutePath().endsWith(".properties") && !file2.getAbsolutePath().endsWith(".props")) continue;
            try {
                list.add(Platforms.readConfig(file2));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                logger.warn((Object)("Failed to load a platform config from properties file " + file2.getAbsolutePath()));
            }
        }
    }

    private static PlatformConfiguration readConfig(File file) throws Exception {
        logger.debug((Object)("Trying to load a platform from " + file.getAbsolutePath()));
        PlatformConfiguration platformConfiguration = new PlatformConfiguration();
        FileInputStream fileInputStream = new FileInputStream(file);
        Properties properties = new Properties();
        properties.load(fileInputStream);
        platformConfiguration.setName((String)Platforms.getPropertyValue(properties, "Name"));
        logger.debug((Object)("Found configuration for platform " + platformConfiguration.getName()));
        platformConfiguration.setVersion(Short.valueOf((String)Platforms.getPropertyValue(properties, "Version")));
        platformConfiguration.setPlatformClass((String)Platforms.getPropertyValue(properties, "PlatformClass"));
        String[] stringArray = ((String)Platforms.getPropertyValue(properties, "Resources")).split(",");
        ArrayList<File> arrayList = new ArrayList<File>();
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(new File(file.getParentFile().getAbsolutePath() + File.separator + stringArray[i]));
        }
        platformConfiguration.setFolder(file.getParentFile());
        Platforms.scanFolderForResources(platformConfiguration.getFolder(), arrayList);
        logger.trace((Object)("Resources found: " + ((Object)arrayList).toString()));
        platformConfiguration.setResources(arrayList.toArray(new File[0]));
        platformConfiguration.setRequireDedicatedClassloader(Boolean.valueOf((String)Platforms.getPropertyValue(properties, "DedicatedClassLoader")));
        platformConfiguration.setBaseURL(new URL((String)Platforms.getPropertyValue(properties, "BaseURL")));
        platformConfiguration.setUser((String)Platforms.getPropertyValue(properties, "User"));
        platformConfiguration.setPassword((String)Platforms.getPropertyValue(properties, "Password"));
        ((InputStream)fileInputStream).close();
        return platformConfiguration;
    }

    private static Object getPropertyValue(Properties properties, String string) throws Exception {
        if (properties.get(string) == null) {
            throw new Exception("Configuration property " + string + " not found");
        }
        return properties.get(string);
    }

    private static void scanFolderForResources(File file, List<File> list) {
        logger.trace((Object)("Scanning folder " + file.getAbsolutePath()));
        for (File file2 : file.listFiles()) {
            if (file2.isDirectory()) {
                Platforms.scanFolderForResources(file2, list);
                continue;
            }
            list.add(file2);
        }
    }
}

