/*
 * Decompiled with CFR 0.152.
 */
package org.ietf.jgss;

public class GSSException
extends Exception {
    public static final int BAD_BINDINGS = 1;
    public static final int BAD_MECH = 2;
    public static final int BAD_NAME = 3;
    public static final int BAD_NAMETYPE = 4;
    public static final int BAD_STATUS = 5;
    public static final int BAD_MIC = 6;
    public static final int CONTEXT_EXPIRED = 7;
    public static final int CREDENTIALS_EXPIRED = 8;
    public static final int DEFECTIVE_CREDENTIAL = 9;
    public static final int DEFECTIVE_TOKEN = 10;
    public static final int FAILURE = 11;
    public static final int NO_CONTEXT = 12;
    public static final int NO_CRED = 13;
    public static final int BAD_QOP = 14;
    public static final int UNAUTHORIZED = 15;
    public static final int UNAVAILABLE = 16;
    public static final int DUPLICATE_ELEMENT = 17;
    public static final int NAME_NOT_MN = 18;
    public static final int DUPLICATE_TOKEN = 19;
    public static final int OLD_TOKEN = 20;
    public static final int UNSEQ_TOKEN = 21;
    public static final int GAP_TOKEN = 22;
    private int majorCode = 0;
    private int minorCode = 0;
    private String minorString;

    public GSSException(int n) {
        this.majorCode = n;
    }

    public GSSException(int n, int n2, String string) {
        this.majorCode = n;
        this.minorCode = n2;
        this.minorString = string;
    }

    public int getMajor() {
        return this.majorCode;
    }

    public int getMinor() {
        return this.minorCode;
    }

    public String getMajorString() {
        String string = "";
        switch (this.majorCode) {
            case 1: {
                string = "Channel bindings mismatch error.";
                break;
            }
            case 2: {
                string = "Unsupported mechanism requested error.";
                break;
            }
            case 6: {
                string = "Token had invalid integrity check error.";
                break;
            }
            case 3: {
                string = "Invalid name provided error.";
                break;
            }
            case 4: {
                string = "Name of unsupported type provided error.";
                break;
            }
            case 14: {
                string = "Unsupported QOP value error.";
                break;
            }
            case 5: {
                string = "Invalid status code error.";
                break;
            }
            case 7: {
                string = "Specified security context expired error.";
                break;
            }
            case 8: {
                string = "Expired credentials detected error.";
                break;
            }
            case 9: {
                string = "Defective credential error.";
                break;
            }
            case 10: {
                string = "Defective token detected.";
                break;
            }
            case 17: {
                string = "The token was a duplicate of an earlier token.";
                break;
            }
            case 11: {
                string = "General failure, unspecified at GSS-API level.";
                break;
            }
            case 22: {
                string = "An expected per-message token was not received.";
                break;
            }
            case 18: {
                string = "Name contains multi-mechanism elements error.";
                break;
            }
            case 12: {
                string = "Invalid security context error.";
                break;
            }
            case 13: {
                string = "Invalid credentials error.";
                break;
            }
            case 20: {
                string = "The token's validity period has expired.";
                break;
            }
            case 15: {
                string = "Operation unauthorized error.";
                break;
            }
            case 16: {
                string = "Operation unavailable error.";
                break;
            }
            case 21: {
                string = "A later token has already been processed.";
            }
        }
        return string;
    }

    public String getMinorString() {
        return this.minorString;
    }

    public void setMinor(int n, String string) {
        this.minorCode = n;
        this.minorString = string;
    }

    public String toString() {
        return this.getMessage();
    }

    public String getMessage() {
        if (this.minorCode == 0) {
            return this.getMajorString();
        }
        return this.getMajorString() + " (Mechanism level: " + this.getMinorString() + ")";
    }
}

