/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.informationsystem.publisher.impl.registrations.resources;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.utils.handlers.GCUBEServiceHandler;
import org.gcube.common.informationsystem.publisher.impl.registrations.resources.ISRegistryClient;
import org.gcube.common.informationsystem.publisher.impl.registrations.resources.ISRegistryInstance;
import org.gcube.common.informationsystem.publisher.impl.registrations.resources.ISRegistryInstanceGroup;
import org.gcube.common.informationsystem.publisher.impl.registrations.resources.ISRegistryLookup;

public abstract class ISRegistryServiceHandler
extends GCUBEServiceHandler<ISRegistryClient> {
    protected static final int MAX_ATTEMPTS = 3;
    protected static final int DEFAULT_CALL_TIMEOUT = 60000;
    private String resourceType = null;
    private String resourceID = null;
    private String profile = null;

    public String getProfile() {
        return this.profile;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public String getResourceID() {
        return this.resourceID;
    }

    public void setResourceID(String resourceID) {
        this.resourceID = resourceID;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    protected List<EndpointReferenceType> findInstances() throws Exception {
        Set<ISRegistryInstance> instances = ISRegistryInstanceGroup.getInstanceGroup().getRegistryInstancesForTypeAndScope(this.getResourceType(), ((ISRegistryClient)((Object)this.getHandled())).getScope());
        if (instances == null || instances.size() == 0) {
            this.logger.trace((Object)"Refreshing Registry instances");
            this.refreshRI();
            instances = ISRegistryInstanceGroup.getInstanceGroup().getRegistryInstancesForTypeAndScope(this.getResourceType(), ((ISRegistryClient)((Object)this.getHandled())).getScope());
            if (instances == null || instances.size() == 0) {
                this.logger.error((Object)("Unable to find an instance of the ISRegistry service for " + this.getResourceType()));
                throw new Exception("Unable to find an instance of the ISRegistry service for " + this.getResourceType());
            }
        }
        ArrayList<EndpointReferenceType> returnedEPRList = new ArrayList<EndpointReferenceType>();
        for (ISRegistryInstance instance : instances) {
            this.logger.trace((Object)("Checking instance " + instance.getEndpoint().getAddress().toString()));
            if (!instance.getScopes().contains(((ISRegistryClient)((Object)this.handled)).getScope()) && !instance.getScopes().contains(((ISRegistryClient)((Object)this.handled)).getScope().getEnclosingScope()) || !instance.getManagedResourceTypes().contains(this.getResourceType())) continue;
            this.logger.trace((Object)("Adding instance " + instance.getEndpoint().toString() + " for type=" + this.getResourceType() + ", scope=" + ((ISRegistryClient)((Object)this.handled)).getScope().toString()));
            returnedEPRList.add(instance.getEndpoint());
        }
        return returnedEPRList;
    }

    private void refreshRI() throws Exception {
        ISRegistryLookup lookup = new ISRegistryLookup();
        lookup.setHandled(((ISRegistryClient)((Object)this.getHandled())).getScope());
        lookup.run();
    }

    protected String getCacheKey() {
        return this.getTargetPortTypeName() + this.getResourceType() + ((ISRegistryClient)((Object)this.getHandled())).getScope().toString();
    }

    public String getName() {
        return "ISRegistryServiceHandler";
    }
}

