/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.contexts;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Constructor;
import java.rmi.Remote;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.management.ObjectName;
import org.gcube.common.core.contexts.GCUBEContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.contexts.ghn.Events;
import org.gcube.common.core.contexts.ghn.GHNConsumer;
import org.gcube.common.core.contexts.service.Builder;
import org.gcube.common.core.contexts.service.Consumer;
import org.gcube.common.core.faults.GCUBEException;
import org.gcube.common.core.faults.GCUBERetryEquivalentException;
import org.gcube.common.core.informationsystem.publisher.ISPublisher;
import org.gcube.common.core.instrumentation.RI;
import org.gcube.common.core.persistence.GCUBERINoPersistenceManager;
import org.gcube.common.core.persistence.GCUBERIPersistenceManager;
import org.gcube.common.core.persistence.GCUBERIPersistenceManagerProfile;
import org.gcube.common.core.plugins.GCUBEPluginManager;
import org.gcube.common.core.plugins.GCUBEPluginManagerProfile;
import org.gcube.common.core.resources.GCUBEResource;
import org.gcube.common.core.resources.GCUBERunningInstance;
import org.gcube.common.core.resources.GCUBEService;
import org.gcube.common.core.resources.service.ServiceDependency;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.scope.GCUBEScopeManager;
import org.gcube.common.core.scope.GCUBEScopeManagerImpl;
import org.gcube.common.core.security.GCUBEAuthzPolicy;
import org.gcube.common.core.security.GCUBEDefaultSecurityConfiguration;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.security.GCUBEServiceAuthenticationController;
import org.gcube.common.core.security.GCUBEServiceAuthorizationController;
import org.gcube.common.core.security.GCUBEServiceSecurityController;
import org.gcube.common.core.security.GCUBEServiceSecurityManager;
import org.gcube.common.core.security.SecurityCredentials;
import org.gcube.common.core.security.context.SecurityContextFactory;
import org.gcube.common.core.utils.events.GCUBEEvent;
import org.gcube.common.core.utils.events.GCUBEProducer;
import org.gcube.common.core.utils.events.GCUBETopic;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.core.utils.proxies.AccessControlProxyContext;
import org.gcube.common.core.utils.proxies.ReadOnlyProxyContext;
import org.gcube.common.scope.api.ScopeProvider;
import org.ietf.jgss.GSSCredential;

public abstract class GCUBEServiceContext
extends GCUBEContext
implements GCUBEServiceSecurityManager,
GCUBEScopeManager {
    private ServiceSecurityStatus serviceSecurityStatus;
    public static final String CONFIG_DIR_JNDI_NAME = "configDir";
    public static final String PROFILE_FILE_NAME = "profile.xml";
    public static final String PERSISTENCE_MANAGER_JNDI_NAME = "persistenceManagerProfile";
    public static final String PLUGIN_MANAGER_JNDI_NAME = "pluginManagerProfile";
    public static final String START_SCOPES_JNDI_NAME = "startScopes";
    public static final String PUBLISHED_HOST_JNDI_NAME = "publishedHost";
    public static final String PUBLISHED_PORT_JNDI_NAME = "publishedPort";
    public static final String RIPROFILE_FILENAME = "RIProfile.xml";
    protected static final long LISTENER_UPDATE_INTERVAL = 2L;
    public static final String SECURITY_MANAGER_JNDI_NAME = "securityManagerClass";
    public static final String AUTHENTICATION_MANAGER_JNDI_NAME = "authenticationManagerClass";
    public static final String AUTHORISATION_MANAGER_JNDI_NAME = "authorisationManagerClass";
    public static final String PROPAGATE_CALLER_CREDENTIALS_JNDI_NAME = "propagateCallerCredentials";
    private RI mbean;
    private Consumer[] internalRIListeners = new Consumer[]{new Initialiser(), new Stager(), new Subscriber(), new Updater()};
    private GCUBERIPersistenceManager persistenceManager;
    private GCUBERunningInstance instance;
    private GCUBEService service;
    private volatile Status status = Status.DEPLOYED;
    private volatile GCUBEServiceSecurityManager securityManager;
    private GCUBEServiceAuthenticationController authenticationManager;
    private GCUBEServiceAuthorizationController authorizationManager;
    private GCUBEScopeManager scopeManager = new GCUBEScopeManagerImpl();
    GCUBEPluginManager<?> pluginManager;
    protected GCUBEProducer<RILifetimeTopic, GCUBEServiceContext> LTEventProducer = new GCUBEProducer();
    List<GCUBEServiceContext> codeployed = new ArrayList<GCUBEServiceContext>();

    protected GCUBEServiceContext() {
        try {
            for (Consumer consumer : this.internalRIListeners) {
                consumer.setLogger(this.logger);
                this.subscribeLifetTime(consumer, consumer.getTopics());
            }
            this.setStatus(Status.DEPLOYED);
        }
        catch (Exception e) {
            this.logger.fatal("could not initialise Running Instance", e);
            this.setStatus(Status.FAILED);
        }
    }

    public GCUBELog getLogger() {
        return this.logger;
    }

    protected abstract String getJNDIName();

    @ReadOnlyProxyContext.ReadOnly
    public GCUBEService getService() {
        return this.service;
    }

    @ReadOnlyProxyContext.ReadOnly
    public GCUBERunningInstance getInstance() {
        return this.instance;
    }

    public RI getManagementBean() {
        return this.mbean;
    }

    @Override
    public File getFile(String path, boolean ... writeMode) throws IllegalArgumentException {
        return super.getFile(GHNContext.getContext().getLocation() + File.separator + (String)this.getProperty(CONFIG_DIR_JNDI_NAME, true) + File.separator + path, writeMode);
    }

    public File getPersistentFile(String path, boolean ... writeMode) throws IllegalArgumentException {
        return super.getFile(GHNContext.getContext().getStorageRoot() + File.separatorChar + this.getName() + File.separatorChar + path, writeMode);
    }

    public File getPersistenceRoot() {
        return this.getPersistentFile("", new boolean[0]);
    }

    @Override
    public Object getProperty(String prop, boolean ... required) throws RuntimeException {
        return super.getProperty("java:comp/env//services/" + this.getJNDIName() + "/" + prop, required);
    }

    public String getID() {
        return this.service != null ? this.getService().getID() : null;
    }

    public String getServiceClass() {
        return this.service == null ? null : this.service.getServiceClass();
    }

    @Override
    public String getName() {
        return this.service == null ? super.getName() : this.service.getServiceName();
    }

    @AccessControlProxyContext.Restricted(value={"org.gcube.common"})
    public synchronized void setStatus(Status status) throws IllegalStateTransitionException, StateTransitionException {
        Status currentStatus = this.status;
        try {
            if (!status.previous().contains((Object)currentStatus)) {
                throw new IllegalStateTransitionException();
            }
            if (status.type != Status.Type.PSEUDO) {
                this.status = status;
                if (status.type != Status.Type.START) {
                    this.logger.info("moved to status " + status.toString().toUpperCase());
                }
                if (status.type == Status.Type.PUBLIC) {
                    this.setStatus(Status.UPDATED);
                }
            } else {
                this.logger.trace("RI has been " + status.toString().toUpperCase());
            }
            switch (status) {
                case DEPLOYED: {
                    this.LTEventProducer.notify(RILifetimeTopic.DEPLOYED, new RILifetimeEvent());
                    break;
                }
                case INITIALISED: {
                    this.LTEventProducer.notify(RILifetimeTopic.INITIALISED, new RILifetimeEvent());
                    break;
                }
                case READIED: {
                    this.LTEventProducer.notify(RILifetimeTopic.READY, new RILifetimeEvent());
                    break;
                }
                case UPDATED: {
                    this.LTEventProducer.notify(RILifetimeTopic.UPDATED, new RILifetimeEvent());
                    this.onUpdate();
                    break;
                }
                case STATECHANGED: {
                    this.LTEventProducer.notify(RILifetimeTopic.STATECHANGE, new RILifetimeEvent());
                    this.onStateChange();
                    break;
                }
                case FAILED: {
                    this.LTEventProducer.notify(RILifetimeTopic.FAILED, new RILifetimeEvent());
                    this.onFailure();
                    break;
                }
                case DOWN: {
                    this.LTEventProducer.notify(RILifetimeTopic.DOWN, new RILifetimeEvent());
                    this.onShutdown();
                }
            }
        }
        catch (Exception e) {
            String errMsg = "could not complete transition from " + (Object)((Object)currentStatus) + " to " + (Object)((Object)status);
            if (status.type == Status.Type.PSEUDO) {
                this.logger.warn(errMsg, e);
            }
            this.logger.fatal(errMsg, e);
            this.status = Status.FAILED;
            throw new StateTransitionException(e);
        }
    }

    public ServiceSecurityStatus getServiceSecurityStatus() {
        if (this.serviceSecurityStatus == null) {
            this.logger.debug("Loading service security status");
            Boolean serviceSecurity = (Boolean)this.getProperty("securityenabled", new boolean[0]);
            if (serviceSecurity == null) {
                this.logger.debug("Service security not set");
                this.serviceSecurityStatus = ServiceSecurityStatus.NOT_SET;
            } else if (!serviceSecurity.booleanValue()) {
                this.logger.debug("Service security set to false");
                this.serviceSecurityStatus = ServiceSecurityStatus.DISABLED;
            } else {
                this.logger.debug("Service security set to true");
                this.serviceSecurityStatus = ServiceSecurityStatus.ENABLED;
            }
        }
        return this.serviceSecurityStatus;
    }

    public Status getStatus() {
        return this.status;
    }

    public GCUBEException getDefaultException(String msg, Throwable cause) {
        return new GCUBERetryEquivalentException(msg, cause);
    }

    public GCUBEException getDefaultException(Throwable cause) {
        return new GCUBERetryEquivalentException(cause);
    }

    public GCUBEServiceSecurityManager getSecurityManager() {
        return this.securityManager;
    }

    @Override
    @AccessControlProxyContext.Restricted
    public void setSecurity(Remote s, GCUBESecurityManager.AuthMode e, GCUBESecurityManager.DelegationMode d) throws Exception {
        this.securityManager.setSecurity(s, e, d);
    }

    @Override
    public boolean isSecurityEnabled() {
        return this.securityManager.isSecurityEnabled();
    }

    @Override
    @AccessControlProxyContext.Restricted
    public SecurityCredentials getCredentials() {
        return this.securityManager.getCredentials();
    }

    @Override
    public GCUBEAuthzPolicy getPolicy() {
        return this.securityManager.getPolicy();
    }

    @Override
    public void initialise(GCUBEServiceContext ctxt) throws Exception {
    }

    @Override
    @AccessControlProxyContext.Restricted
    public SecurityCredentials getServiceCredentials() throws Exception {
        return this.securityManager.getServiceCredentials();
    }

    @Override
    @AccessControlProxyContext.Restricted
    public SecurityCredentials getCallerCredentials() throws Exception {
        return this.securityManager.getCallerCredentials();
    }

    @Override
    @AccessControlProxyContext.Restricted
    public void useCredentials(SecurityCredentials credentials) throws Exception {
        this.securityManager.useCredentials(credentials);
    }

    @Override
    @AccessControlProxyContext.Restricted
    public void useCredentials(Thread thread, SecurityCredentials ... credentials) throws Exception {
        this.securityManager.useCredentials(thread, credentials);
    }

    @Override
    @AccessControlProxyContext.Restricted
    public boolean needServiceCredentials() {
        return this.securityManager.needServiceCredentials();
    }

    @Override
    @AccessControlProxyContext.Restricted
    public void propagateCallerCredentials(boolean propagateCallerCredentials) {
        this.securityManager.propagateCallerCredentials(propagateCallerCredentials);
    }

    @Override
    @AccessControlProxyContext.Restricted
    public void setAuthMethod(GCUBESecurityManager.AuthMethod m) {
        this.securityManager.setAuthMethod(m);
    }

    @Override
    @Deprecated
    @AccessControlProxyContext.Restricted
    public void useCredentials(GSSCredential credentials) throws Exception {
        this.securityManager.useCredentials(credentials);
    }

    @Override
    public void subscribe(GCUBEServiceSecurityManager.LifetimeConsumer c, GCUBEServiceSecurityManager.LifetimeTopic ... topics) {
        this.securityManager.subscribe(c, topics);
    }

    @Override
    public void unsubscribe(GCUBEServiceSecurityManager.LifetimeConsumer c, GCUBEServiceSecurityManager.LifetimeTopic ... topics) {
        this.securityManager.unsubscribe(c, topics);
    }

    public GCUBEServiceAuthenticationController getAuthenticationManager() {
        return this.authenticationManager;
    }

    public GCUBEServiceAuthorizationController getAuthorizationManager() {
        return this.authorizationManager;
    }

    @AccessControlProxyContext.Restricted
    public void useCallerCredentials(Thread ... thread) throws Exception {
        if (!this.securityManager.isSecurityEnabled()) {
            return;
        }
        SecurityCredentials callerCredentials = this.securityManager.getCallerCredentials();
        this.logger.debug("Executing on behalf of caller in VRE " + ScopeProvider.instance.get());
        if (thread.length == 0) {
            this.securityManager.useCredentials(callerCredentials);
        } else {
            this.securityManager.useCredentials(thread[0], callerCredentials);
        }
    }

    @AccessControlProxyContext.Restricted
    public void useServiceCredentials(Thread ... thread) throws Exception {
        if (!this.securityManager.isSecurityEnabled()) {
            return;
        }
        SecurityCredentials credentials = this.securityManager.getServiceCredentials();
        this.securityManager.useCredentials(credentials);
        if (thread.length == 0) {
            this.securityManager.useCredentials(credentials);
        } else {
            this.securityManager.useCredentials(thread[0], credentials);
        }
    }

    public GCUBEScope[] getStartScopes() {
        GCUBEScope[] configScopes = null;
        String config = (String)this.getProperty(START_SCOPES_JNDI_NAME, new boolean[0]);
        if (config == null) {
            configScopes = GHNContext.getContext().getGHN().getScopes().values().toArray(new GCUBEScope[0]);
        } else {
            String[] startScopes = config.split(",");
            configScopes = new GCUBEScope[startScopes.length];
            for (int idx = 0; idx < startScopes.length; ++idx) {
                configScopes[idx] = GCUBEScope.getScope(startScopes[idx].trim());
            }
        }
        return configScopes;
    }

    @Deprecated
    @AccessControlProxyContext.Restricted
    public GCUBEScopeManager getScopeManager() {
        return this.scopeManager;
    }

    @Override
    @Deprecated
    @AccessControlProxyContext.Restricted
    public GCUBEScope getScope() {
        String currentScope = ScopeProvider.instance.get();
        return GCUBEScope.getScope(currentScope == null ? null : currentScope);
    }

    @Override
    @Deprecated
    @AccessControlProxyContext.Restricted
    public void prepareCall(Remote remote, String clazz, String name, GCUBEScope ... scope) {
        if (scope != null && scope.length > 0) {
            if (!this.getInstance().inScope(scope[0])) {
                throw new GCUBEScopeManager.IllegalScopeException();
            }
        } else {
            GCUBEScope currentScope = GCUBEScope.getScope(ScopeProvider.instance.get());
            if (!this.getInstance().inScope(currentScope)) {
                throw new GCUBEScopeManager.IllegalScopeException();
            }
        }
        this.scopeManager.prepareCall(remote, clazz, name, scope);
    }

    @Override
    @AccessControlProxyContext.Restricted
    public void setScope(GCUBEScope scope) throws GCUBEScopeManager.IllegalScopeException {
        if (!this.getInstance().inScope(scope)) {
            throw new GCUBEScopeManager.IllegalScopeException(scope.toString());
        }
        ScopeProvider.instance.set(scope == null ? null : scope.toString());
    }

    @AccessControlProxyContext.Restricted
    @Deprecated
    public void setScope(Thread thread, GCUBEScope scope) throws GCUBEScopeManager.IllegalScopeException {
        this.scopeManager.setScope(thread, scope);
    }

    @Override
    @AccessControlProxyContext.Restricted
    @Deprecated
    public void setScope(Thread thread, GCUBEScope ... scope) throws GCUBEScopeManager.IllegalScopeException {
        if (scope != null && scope.length > 0 && !this.getInstance().inScope(scope[0])) {
            throw new GCUBEScopeManager.IllegalScopeException(scope[0].toString());
        }
        this.scopeManager.setScope(thread, scope);
    }

    @AccessControlProxyContext.Restricted
    public synchronized Set<GCUBEScope> addScope(GCUBEScope ... scopes) {
        if (scopes == null || scopes.length == 0) {
            throw new IllegalArgumentException();
        }
        Set<GCUBEScope> acceptedScopes = new HashSet<GCUBEScope>();
        for (GCUBEScope scope : scopes) {
            if (!GHNContext.getContext().getGHN().inScope(scope) || !this.getService().inScope(scope)) continue;
            acceptedScopes.add(scope);
        }
        if (acceptedScopes.size() > 0 && (acceptedScopes = this.getInstance().addScope(acceptedScopes.toArray(new GCUBEScope[0]))).size() > 0) {
            this.setStatus(Status.UPDATED);
        }
        return acceptedScopes;
    }

    @AccessControlProxyContext.Restricted
    public synchronized Set<GCUBEScope> removeScope(GCUBEScope ... scopes) {
        Set<GCUBEScope> accepted = this.getInstance().removeScope(scopes);
        if (accepted.size() > 0) {
            ISPublisher publisher = null;
            try {
                publisher = GHNContext.getImplementation(ISPublisher.class);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (accepted.size() > 0) {
                this.logger.info("unpublishing RI (" + this.getName() + ") profile from scope(s) " + accepted);
            }
            for (GCUBEScope scope : accepted) {
                if (GHNContext.getContext().getMode() == GHNContext.Mode.STANDALONE) continue;
                try {
                    publisher.removeGCUBEResource(this.instance.getID(), "RunningInstance", scope, this.securityManager);
                }
                catch (Exception e) {
                    this.logger.error("unable to unpublish the RI (" + this.getName() + ") profile from scope " + scope, e);
                }
            }
            this.setStatus(Status.UPDATED);
        }
        return accepted;
    }

    public GCUBEPluginManager<?> getPluginManager() {
        return this.pluginManager;
    }

    public void subscribeLifetTime(Consumer consumer, RILifetimeTopic ... topics) throws Exception {
        if (topics.length == 0) {
            topics = RILifetimeTopic.values();
        }
        this.LTEventProducer.subscribe(consumer, topics);
    }

    public void unsubscribeLifetTime(Consumer consumer, RILifetimeTopic ... topics) {
        if (topics.length == 0) {
            topics = RILifetimeTopic.values();
        }
        this.LTEventProducer.unsubscribe(consumer, topics);
    }

    public void notifyStateChange() {
        this.setStatus(Status.STATECHANGED);
    }

    private GCUBEServiceSecurityManager configureServicesecurityManager() throws Exception {
        this.logger.info("Generating security manager...");
        GCUBEServiceSecurityManager securityManager = null;
        String securityManagerClassName = (String)this.getProperty(SECURITY_MANAGER_JNDI_NAME, new boolean[0]);
        if (securityManagerClassName != null) {
            Class<?> securityManagerClass = Class.forName(securityManagerClassName);
            if (!GCUBEServiceSecurityManager.class.isAssignableFrom(securityManagerClass)) {
                throw new Exception(securityManagerClassName + " does not implement " + GCUBEServiceSecurityManager.class.getName());
            }
            securityManager = (GCUBEServiceSecurityManager)securityManagerClass.newInstance();
        } else {
            securityManager = GHNContext.getImplementation(GCUBEServiceSecurityManager.class);
        }
        securityManager.initialise(this);
        GCUBEDefaultSecurityConfiguration defaultSecurityConfiguration = SecurityContextFactory.getInstance().getSecurityContext().getDefaultServiceSecurityConfiguration();
        if (defaultSecurityConfiguration != null && defaultSecurityConfiguration.defaultCredentialPropagationSet() && defaultSecurityConfiguration.propagateCallerCredentialsOverride()) {
            this.logger.debug("Override every propagate configuration with the container configuration");
            securityManager.propagateCallerCredentials(defaultSecurityConfiguration.propagateCallerCredentials());
        } else {
            this.logger.debug("Loading credentials propagation property from jndi service environment");
            Boolean useCallerCredentials = (Boolean)this.getProperty(PROPAGATE_CALLER_CREDENTIALS_JNDI_NAME, new boolean[0]);
            this.logger.debug("Credential propagation property = " + useCallerCredentials);
            if (useCallerCredentials != null) {
                securityManager.propagateCallerCredentials(useCallerCredentials);
            } else if (defaultSecurityConfiguration != null && defaultSecurityConfiguration.defaultCredentialPropagationSet()) {
                this.logger.debug("Loading default configuration");
                securityManager.propagateCallerCredentials(defaultSecurityConfiguration.propagateCallerCredentials());
            } else {
                this.logger.warn("No service propagation property set and no default configuration available");
            }
        }
        this.logger.info("managing security with a " + securityManager.getClass().getSimpleName());
        return securityManager;
    }

    private GCUBEServiceSecurityController configureServiceSecurityControlManager(String securityControlManagerJNDIName, Class<? extends GCUBEServiceSecurityController> securityControlManagerClass, GCUBEServiceSecurityManager securityManager) throws Exception {
        this.logger.info("Generating security control manager " + securityControlManagerClass.getCanonicalName());
        GCUBEServiceSecurityController securityControlManager = null;
        String securityControlManagerClassName = (String)this.getProperty(securityControlManagerJNDIName, new boolean[0]);
        if (securityControlManagerClassName != null) {
            Class<?> securityManagerConcreteClass = Class.forName(securityControlManagerClassName);
            if (!GCUBEServiceSecurityController.class.isAssignableFrom(securityManagerConcreteClass)) {
                throw new Exception(securityControlManagerClassName + " does not implement " + GCUBEServiceSecurityController.class.getName());
            }
            securityControlManager = (GCUBEServiceSecurityController)securityManagerConcreteClass.newInstance();
        } else {
            securityControlManager = GHNContext.getImplementation(securityControlManagerClass);
        }
        securityControlManager.initialise(this, securityManager);
        this.logger.info("managing security control with a " + securityControlManager.getClass().getSimpleName());
        return securityControlManager;
    }

    protected void onInitialisation() throws Exception {
    }

    protected void onReady() throws Exception {
    }

    protected void onShutdown() throws Exception {
    }

    protected void onFailure() throws Exception {
    }

    protected void onUpdate() throws Exception {
    }

    protected void onStateChange() throws Exception {
    }

    class Subscriber
    extends Consumer {
        Subscriber() {
        }

        @Override
        public RILifetimeTopic[] getTopics() {
            return new RILifetimeTopic[]{RILifetimeTopic.INITIALISED};
        }

        @Override
        protected void onRIInitialised(RILifetimeEvent event) throws Exception {
            Thread.currentThread().setName(GCUBEServiceContext.this.service.getServiceName() + "-" + Thread.currentThread().getName());
            GHNConsumer consumer = new GHNConsumer(){

                @Override
                protected void onGHNShutdown(Events.GHNLifeTimeEvent event) {
                    GCUBEServiceContext.this.setStatus(Status.DOWN);
                }
            };
            GCUBEServiceContext.this.logger.info("registering for GHN shutdown events");
            GHNContext.getContext().subscribeGHNEvents(consumer, Events.GHNTopic.SHUTDOWN);
            if (GCUBEServiceContext.this.getClass().getPackage().getName().startsWith("org.gcube.common")) {
                GCUBEServiceContext.this.logger.info("registering for GHN scope events as a local service");
                GHNContext.getContext().getGHN().subscribeResourceEvents(new LocalResourceConsumer(), GCUBEResource.ResourceTopic.ADDSCOPE, GCUBEResource.ResourceTopic.REMOVESCOPE);
            } else {
                GCUBEServiceContext.this.logger.info("registering for GHN scope removal events");
                GHNContext.getContext().getGHN().subscribeResourceEvents(new BaseResourceConsumer(), GCUBEResource.ResourceTopic.REMOVESCOPE);
            }
            GCUBEServiceContext.this.LTEventProducer.unsubscribe(this, this.getTopics());
        }

        public class LocalResourceConsumer
        extends BaseResourceConsumer {
            @Override
            protected void onAddScope(GCUBEResource.AddScopeEvent event) {
                GCUBEServiceContext.this.addScope((GCUBEScope[])event.getPayload());
            }
        }

        public class BaseResourceConsumer
        extends GCUBEResource.ResourceConsumer {
            @Override
            protected void onRemoveScope(GCUBEResource.RemoveScopeEvent event) {
                HashSet<GCUBEScope> scopes = new HashSet<GCUBEScope>();
                for (GCUBEScope GHNScope : (GCUBEScope[])event.getPayload()) {
                    for (GCUBEScope RIScope : GCUBEServiceContext.this.getInstance().getScopes().values()) {
                        if (!RIScope.isEnclosedIn(GHNScope)) continue;
                        scopes.add(RIScope);
                    }
                }
                GCUBEServiceContext.this.removeScope(scopes.toArray(new GCUBEScope[0]));
            }
        }
    }

    class Updater
    extends Consumer {
        Updater() {
        }

        @Override
        public RILifetimeTopic[] getTopics() {
            return new RILifetimeTopic[]{RILifetimeTopic.UPDATED};
        }

        @Override
        protected void onRIUpdated(RILifetimeEvent event) throws Exception {
            try {
                GCUBEServiceContext.this.getInstance().getDeploymentData().setState(GCUBEServiceContext.this.getStatus().toString());
                File file = GCUBEServiceContext.this.getPersistentFile(GCUBEServiceContext.RIPROFILE_FILENAME, true);
                FileWriter writer = new FileWriter(file);
                try {
                    GCUBEServiceContext.this.getInstance().store(writer);
                }
                catch (Exception e) {
                    GCUBEServiceContext.this.logger.warn("could not serialise profile (" + GCUBEServiceContext.this.getName() + ")", e);
                }
                ISPublisher publisher = GHNContext.getImplementation(ISPublisher.class);
                if (GCUBEServiceContext.this.instance.getScopes().values().size() > 0) {
                    GCUBEServiceContext.this.logger.trace("publishing RI profile in scope(s) " + GCUBEServiceContext.this.instance.getScopes().values());
                }
                for (GCUBEScope scope : GCUBEServiceContext.this.instance.getScopes().values()) {
                    if (GHNContext.getContext().getMode() == GHNContext.Mode.STANDALONE) continue;
                    try {
                        publisher.updateGCUBEResource(GCUBEServiceContext.this.getInstance(), scope, GCUBEServiceContext.this.getSecurityManager());
                    }
                    catch (Exception e) {
                        GCUBEServiceContext.this.logger.error("unable to publish the RI profile in scope " + scope, e);
                    }
                }
            }
            catch (Exception e) {
                GCUBEServiceContext.this.logger.warn("could not update RI", e);
            }
        }
    }

    protected class Stager
    extends Consumer {
        byte toDo;
        Exception failure;

        protected Stager() {
        }

        synchronized void addTask() {
            this.toDo = (byte)(this.toDo + 1);
        }

        synchronized void doneTask() {
            this.toDo = (byte)(this.toDo - 1);
            this.notify();
        }

        synchronized boolean finished() {
            return this.toDo == 0;
        }

        synchronized void failedTask(Exception e) {
            if (this.failure == null) {
                this.failure = e;
                this.notify();
            }
        }

        synchronized boolean hasFailed() {
            return this.failure != null;
        }

        @Override
        public RILifetimeTopic[] getTopics() {
            return new RILifetimeTopic[]{RILifetimeTopic.INITIALISED};
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onRIInitialised(RILifetimeEvent event) throws Exception {
            Thread.currentThread().setName(GCUBEServiceContext.this.service.getServiceName() + "-" + Thread.currentThread().getName());
            Thread first = new Thread("SecurityMonitor"){
                private int count;
                private GCUBEServiceSecurityManager.LifetimeConsumer consumer;
                {
                    this.count = 2;
                    this.consumer = new GCUBEServiceSecurityManager.LifetimeConsumer(){

                        @Override
                        protected void onPolicyUpdate() {
                            this.done();
                        }

                        @Override
                        protected void onCredentialUpdate() {
                            this.done();
                        }
                    };
                }

                private synchronized void done() {
                    --this.count;
                    if (this.count == 0) {
                        Stager.this.doneTask();
                        GCUBEServiceContext.this.securityManager.unsubscribe(this.consumer, new GCUBEServiceSecurityManager.LifetimeTopic[0]);
                    }
                }

                @Override
                public void run() {
                    GCUBEServiceContext.this.securityManager.subscribe(this.consumer, new GCUBEServiceSecurityManager.LifetimeTopic[0]);
                }
            };
            Thread second = new Thread("StateStager"){

                @Override
                public void run() {
                    try {
                        GCUBEServiceContext.this.persistenceManager.recover();
                        Stager.this.doneTask();
                    }
                    catch (Exception e) {
                        Stager.this.failedTask(e);
                    }
                }
            };
            Thread third = new Thread("DependencyMonitor"){

                @Override
                public void run() {
                    final ArrayList codependencies = new ArrayList();
                    try {
                        GHNConsumer consumer = new GHNConsumer(){

                            boolean waitForDependency(GCUBEServiceContext context, ServiceDependency dependency, List<String> services, String chain) {
                                GCUBEServiceContext.this.logger.debug("checking if the service is waiting for dependencies");
                                String nextChain = chain + "->" + dependency.getName();
                                if (services.contains(dependency.getClazz() + dependency.getName())) {
                                    GCUBEServiceContext.this.logger.debug("waiting...");
                                    return true;
                                }
                                GCUBEServiceContext dependencyContext = null;
                                try {
                                    dependencyContext = GHNContext.getContext().getServiceContext(dependency.getClazz(), dependency.getName());
                                }
                                catch (Exception e) {
                                    GCUBEServiceContext.this.logger.debug("not waiting");
                                    return false;
                                }
                                if (dependencyContext.getStatus() == Status.READIED || dependencyContext.getStatus() == Status.FAILED) {
                                    GCUBEServiceContext.this.logger.debug("not waiting");
                                    return false;
                                }
                                if (dependency.getClazz().equals(GCUBEServiceContext.this.getServiceClass()) && dependency.getName().equals(GCUBEServiceContext.this.getName())) {
                                    GCUBEServiceContext.this.logger.warn("detected cyclic co-dependency chain:" + nextChain);
                                    throw new CyclicDependencyException();
                                }
                                ArrayList<String> newContexts = new ArrayList<String>(services);
                                newContexts.add(dependency.getClazz() + dependency.getName());
                                for (ServiceDependency dep : dependencyContext.getService().getDependencies()) {
                                    this.waitForDependency(dependencyContext, dep, newContexts, nextChain);
                                }
                                GCUBEServiceContext.this.logger.debug("waiting...");
                                return true;
                            }

                            void checkIfDone() {
                                if (codependencies.size() == 0) {
                                    Stager.this.doneTask();
                                }
                            }

                            @Override
                            protected void onGHNReady(Events.GHNLifeTimeEvent event) {
                                super.onGHNReady(event);
                                Consumer sconsumer = new Consumer(){

                                    @Override
                                    protected void onRIReady(RILifetimeEvent event) throws Exception {
                                        codependencies.remove(((GCUBEServiceContext)event.getPayload()).getServiceClass() + ((GCUBEServiceContext)event.getPayload()).getName());
                                        this.checkIfDone();
                                        ((GCUBEServiceContext)event.getPayload()).unsubscribeLifetTime(this, RILifetimeTopic.READY, RILifetimeTopic.FAILED);
                                    }

                                    @Override
                                    protected void onRIFailed(RILifetimeEvent event) throws Exception {
                                        this.onRIReady(event);
                                    }
                                };
                                for (ServiceDependency dep : GCUBEServiceContext.this.getService().getDependencies()) {
                                    try {
                                        if (!this.waitForDependency(GCUBEServiceContext.this, dep, new ArrayList<String>(), GCUBEServiceContext.this.getName())) continue;
                                        GCUBEServiceContext.this.logger.trace("waiting on " + dep.getClazz() + ":" + dep.getName());
                                        GHNContext.getContext().getServiceContext(dep.getClazz(), dep.getName()).subscribeLifetTime(sconsumer, RILifetimeTopic.READY, RILifetimeTopic.FAILED);
                                        codependencies.add(dep.getClazz() + dep.getName());
                                    }
                                    catch (CyclicDependencyException cyclicDependencyException) {
                                    }
                                    catch (Exception e) {
                                        GCUBEServiceContext.this.logger.warn("could not synchronise with codependency " + dep.getClazz() + ":" + dep.getName(), e);
                                    }
                                }
                                this.checkIfDone();
                                GHNContext.getContext().unsubscribeGHNEvents(this, Events.GHNTopic.READY);
                            }
                        };
                        GHNContext.getContext().subscribeGHNEvents(consumer, Events.GHNTopic.READY);
                    }
                    catch (Exception e) {
                        Stager.this.failedTask(e);
                    }
                }

                class CyclicDependencyException
                extends RuntimeException {
                    private static final long serialVersionUID = 1L;

                    CyclicDependencyException() {
                    }
                }
            };
            first.setName(Thread.currentThread().getName());
            second.setName(Thread.currentThread().getName());
            third.setName(Thread.currentThread().getName());
            this.addTask();
            first.start();
            this.addTask();
            second.start();
            this.addTask();
            third.start();
            Stager stager = this;
            synchronized (stager) {
                while (!this.finished()) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                    if (!this.hasFailed()) continue;
                    GCUBEServiceContext.this.logger.debug("staging error", this.failure);
                    GCUBEServiceContext.this.setStatus(Status.FAILED);
                    return;
                }
            }
            if (Status.READIED.previous().contains((Object)GCUBEServiceContext.this.getStatus())) {
                GCUBEServiceContext.this.onReady();
                GCUBEServiceContext.this.setStatus(Status.READIED);
            }
            GCUBEServiceContext.this.LTEventProducer.unsubscribe(this, this.getTopics());
        }
    }

    class Initialiser
    extends Consumer {
        Initialiser() {
        }

        @Override
        public RILifetimeTopic[] getTopics() {
            return new RILifetimeTopic[]{RILifetimeTopic.DEPLOYED};
        }

        @Override
        protected void onRIDeployed(RILifetimeEvent event) throws Exception {
            GCUBEServiceContext.this.service = GHNContext.getImplementation(GCUBEService.class);
            GCUBEServiceContext.this.service.load(new FileReader(GCUBEServiceContext.this.getFile(GCUBEServiceContext.PROFILE_FILE_NAME, new boolean[0])));
            GCUBEServiceContext.this.logger.setContext(GCUBEServiceContext.this);
            GCUBEServiceContext.this.service.setLogger(GCUBEServiceContext.this.logger);
            Thread.currentThread().setName(GCUBEServiceContext.this.service.getServiceName() + "-" + Thread.currentThread().getName());
            GCUBEServiceContext.this.service.addScope(GHNContext.getContext().getStartScopes()[0].getInfrastructure());
            GCUBEServiceContext.this.logger.info("INITIALISING RUNNING INSTANCE");
            GCUBEServiceContext.this.mbean = new RI(GCUBEServiceContext.this);
            ManagementFactory.getPlatformMBeanServer().registerMBean(GCUBEServiceContext.this.mbean, new ObjectName("org.gcube:type=RI,value=" + GCUBEServiceContext.this.getName() + "." + GCUBEServiceContext.this.getServiceClass()));
            GCUBEServiceContext.this.instance = GHNContext.getImplementation(GCUBERunningInstance.class);
            GCUBEServiceContext.this.instance.setLogger(GCUBEServiceContext.this.logger);
            File profile = GCUBEServiceContext.this.getPersistentFile(GCUBEServiceContext.RIPROFILE_FILENAME, new boolean[0]);
            Builder builder = new Builder(GCUBEServiceContext.this);
            builder.setLogger(GCUBEServiceContext.this.logger);
            if (profile.exists()) {
                try {
                    GCUBEServiceContext.this.logger.trace("loading RI profile");
                    GCUBEServiceContext.this.instance.load(new FileReader(profile));
                    builder.updateRIResource();
                }
                catch (Exception e) {
                    GCUBEServiceContext.this.logger.warn("could not load RI profile from profile..regenerating it", e);
                    builder.createRIResource();
                }
            } else {
                builder.createRIResource();
            }
            GCUBEServiceContext.this.securityManager = GCUBEServiceContext.this.configureServicesecurityManager();
            GCUBEServiceContext.this.authenticationManager = (GCUBEServiceAuthenticationController)GCUBEServiceContext.this.configureServiceSecurityControlManager(GCUBEServiceContext.AUTHENTICATION_MANAGER_JNDI_NAME, GCUBEServiceAuthenticationController.class, GCUBEServiceContext.this.securityManager);
            GCUBEServiceContext.this.authorizationManager = (GCUBEServiceAuthorizationController)GCUBEServiceContext.this.configureServiceSecurityControlManager(GCUBEServiceContext.AUTHORISATION_MANAGER_JNDI_NAME, GCUBEServiceAuthorizationController.class, GCUBEServiceContext.this.securityManager);
            GCUBERIPersistenceManagerProfile persistenceManagerProfile = (GCUBERIPersistenceManagerProfile)GCUBEServiceContext.this.getProperty(GCUBEServiceContext.PERSISTENCE_MANAGER_JNDI_NAME, new boolean[0]);
            if (persistenceManagerProfile != null) {
                Class<?> persistenceManagerClass = this.getClass().getClassLoader().loadClass(persistenceManagerProfile.getClassName());
                if (!GCUBERIPersistenceManager.class.isAssignableFrom(persistenceManagerClass)) {
                    throw new Exception(persistenceManagerProfile.getClassName() + " does not implement " + GCUBERIPersistenceManager.class.getName());
                }
                GCUBEServiceContext.this.persistenceManager = (GCUBERIPersistenceManager)persistenceManagerClass.newInstance();
            } else {
                GCUBEServiceContext.this.persistenceManager = new GCUBERINoPersistenceManager(GCUBEServiceContext.this, new GCUBERIPersistenceManagerProfile());
            }
            GCUBEServiceContext.this.persistenceManager.exclude("RIProfile.xml.*");
            GCUBEServiceContext.this.persistenceManager.setLogger(GCUBEServiceContext.this.logger);
            GCUBEServiceContext.this.logger.info("managing remote persistence with a " + GCUBEServiceContext.this.persistenceManager.getClass().getSimpleName());
            GCUBEPluginManagerProfile pluginManagerProfile = (GCUBEPluginManagerProfile)GCUBEServiceContext.this.getProperty(GCUBEServiceContext.PLUGIN_MANAGER_JNDI_NAME, new boolean[0]);
            if (pluginManagerProfile != null) {
                Class<?> pluginManagerClass = this.getClass().getClassLoader().loadClass(pluginManagerProfile.getClassName());
                if (!GCUBEPluginManager.class.isAssignableFrom(pluginManagerClass)) {
                    throw new Exception(pluginManagerProfile.getClassName() + " does not implement " + GCUBEPluginManager.class.getName());
                }
                Constructor<?> constructor = pluginManagerClass.getConstructor(new Class[0]);
                GCUBEServiceContext.this.pluginManager = (GCUBEPluginManager)constructor.newInstance(new Object[0]);
                GCUBEServiceContext.this.pluginManager.initialise(GCUBEServiceContext.this, pluginManagerProfile);
                GCUBEServiceContext.this.pluginManager.setLogger(GCUBEServiceContext.this.logger);
                GCUBEServiceContext.this.persistenceManager.exclude("plugins");
                GCUBEServiceContext.this.logger.info("managing plugins with a " + GCUBEServiceContext.this.pluginManager.getClass().getSimpleName());
            }
            GHNContext.getContext().registerService(GCUBEServiceContext.this);
            GCUBEServiceContext.this.onInitialisation();
            GCUBEServiceContext.this.setStatus(Status.INITIALISED);
            GCUBEServiceContext.this.LTEventProducer.unsubscribe(this, this.getTopics());
        }
    }

    public class RILifetimeEvent
    extends GCUBEEvent<RILifetimeTopic, GCUBEServiceContext> {
        public RILifetimeEvent() {
            this.payload = GCUBEServiceContext.this;
            this.producer = GCUBEServiceContext.this.LTEventProducer;
        }
    }

    public static enum RILifetimeTopic implements GCUBETopic
    {
        DEPLOYED,
        INITIALISED,
        READY,
        FAILED,
        UPDATED,
        STATECHANGE,
        DOWN;

    }

    public static class StateTransitionException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        StateTransitionException(Exception e) {
            super(e);
        }
    }

    public static class IllegalStateTransitionException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 1L;
    }

    public static enum Status {
        DEPLOYED(Type.START){

            @Override
            List<Status> previous() {
                return Arrays.asList(DEPLOYED, UNREACHABLE);
            }

            public String toString() {
                return "started";
            }
        }
        ,
        INITIALISED(Type.PRIVATE){

            @Override
            List<Status> previous() {
                return Arrays.asList(DEPLOYED, UNREACHABLE);
            }

            public String toString() {
                return "initialised";
            }
        }
        ,
        READIED(Type.PUBLIC){

            @Override
            List<Status> previous() {
                return Arrays.asList(INITIALISED, UNREACHABLE);
            }

            public String toString() {
                return "ready";
            }
        }
        ,
        UPDATED(Type.PSEUDO){

            @Override
            List<Status> previous() {
                return Arrays.asList(DEPLOYED, INITIALISED, READIED, FAILED, DOWN, UNREACHABLE);
            }

            public String toString() {
                return "updated";
            }
        }
        ,
        STATECHANGED(Type.PSEUDO){

            @Override
            List<Status> previous() {
                return Arrays.asList(INITIALISED, READIED, UNREACHABLE);
            }

            public String toString() {
                return "state changed";
            }
        }
        ,
        FAILED(Type.PUBLIC){

            @Override
            List<Status> previous() {
                return Arrays.asList(DEPLOYED, INITIALISED, READIED, STATECHANGED, FAILED, UNREACHABLE);
            }

            public String toString() {
                return "failed";
            }
        }
        ,
        DOWN(Type.PUBLIC){

            @Override
            List<Status> previous() {
                return Arrays.asList(DEPLOYED, INITIALISED, READIED, STATECHANGED, FAILED, UNREACHABLE, DOWN);
            }

            public String toString() {
                return "down";
            }
        }
        ,
        UNREACHABLE(Type.PUBLIC){

            @Override
            List<Status> previous() {
                return Arrays.asList(READIED, STATECHANGED, UNREACHABLE);
            }

            public String toString() {
                return "unreachable";
            }
        };

        protected final Type type;

        private Status(Type type) {
            this.type = type;
        }

        abstract List<Status> previous();

        public static enum Type {
            START,
            PSEUDO,
            PRIVATE,
            PUBLIC;

        }
    }

    public static enum ServiceSecurityStatus {
        ENABLED,
        DISABLED,
        NOT_SET;

    }
}

