/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ant;

import java.io.File;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;

public class AntTaskLauncher {
    public static final int DEBUG_MODE = 4;
    public static final int VERBOSE_MODE = 3;
    public static final int INFO_MODE = 2;
    private Project project = new Project();
    private AntLogger logger = new AntLogger();

    public AntTaskLauncher() {
        this.project.addBuildListener(this.logger);
    }

    public void setProperty(String key, String value) {
        this.project.setProperty(key, value);
    }

    public void setFinishSuccessMessage(String msg) {
        this.logger.setFinishSuccessMessage(msg);
    }

    public void setFinishFailMessage(String msg) {
        this.logger.setFinishFailMessage(msg);
    }

    public void setStartMessage(String msg) {
        this.logger.setStartMessage(msg);
    }

    public void setOutputLevel(int mode) {
        this.logger.setOutputLevel(mode);
    }

    public void executeTarget(File buildFile, String taskName) {
        ProjectHelper helper = ProjectHelper.getProjectHelper();
        this.project.addReference("ant.projectHelper", helper);
        try {
            this.project.setUserProperty("ant.file", buildFile.getAbsolutePath());
            this.project.init();
            helper.parse(this.project, buildFile);
            this.project.fireBuildStarted();
            this.project.executeTarget(taskName);
            this.project.fireBuildFinished(null);
        }
        catch (Exception e) {
            this.project.fireBuildFinished(e);
            System.exit(1);
        }
    }

    private static class AntLogger
    implements BuildListener {
        private String startMessage;
        private String successMessage;
        private String failMessage;
        private int outputLevel = 2;

        public void setOutputLevel(int mode) {
            this.outputLevel = mode;
        }

        public void setStartMessage(String msg) {
            this.startMessage = msg;
        }

        public void setFinishSuccessMessage(String msg) {
            this.successMessage = msg;
        }

        public void setFinishFailMessage(String msg) {
            this.failMessage = msg;
        }

        public void buildStarted(BuildEvent event) {
            if (this.startMessage != null) {
                System.out.println(this.startMessage);
            }
            System.out.println();
        }

        public void buildFinished(BuildEvent event) {
            Throwable error = event.getException();
            System.out.println();
            if (error == null) {
                System.out.println(this.successMessage);
            } else if (3 <= this.outputLevel) {
                System.err.println(this.failMessage);
                error.printStackTrace(System.err);
            } else {
                System.err.println(this.failMessage + ": " + error.getMessage());
            }
        }

        public void targetStarted(BuildEvent event) {
        }

        public void targetFinished(BuildEvent event) {
        }

        public void taskStarted(BuildEvent event) {
        }

        public void taskFinished(BuildEvent event) {
        }

        public void messageLogged(BuildEvent event) {
            int priority = event.getPriority();
            if (priority <= this.outputLevel) {
                if (priority == 0) {
                    System.err.println("  " + event.getMessage());
                } else {
                    System.err.println("  " + event.getMessage());
                }
            }
        }
    }
}

