/*
 * Decompiled with CFR 0.152.
 */
package ise.antelope.tasks;

import ise.antelope.tasks.AssertException;
import ise.antelope.tasks.TestStatisticAccumulator;
import ise.library.ascii.MessageBox;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;

public class TestCase
extends Task
implements TestStatisticAccumulator {
    private boolean enabled = true;
    private boolean assertEnabled = true;
    private Target setUp = null;
    private Target tearDown = null;
    private Vector testTargets = new Vector();
    private Vector failures = new Vector();
    private boolean failOnError = false;
    private boolean showSummary = true;
    private boolean showOutput = true;
    private File testFile = null;
    private String test_name = "";
    private int tests_passed = 0;
    private int tests_failed = 0;
    private int tests_warning = 0;

    public void init() {
        super.init();
        this.setTaskName("testcase");
    }

    public int getTestCaseCount() {
        return this.testTargets.size();
    }

    public int getRanCount() {
        return this.tests_passed + this.tests_warning + this.tests_failed;
    }

    public int getFailedCount() {
        return this.tests_failed;
    }

    public int getWarningCount() {
        return this.tests_warning;
    }

    public int getPassedCount() {
        return this.tests_passed;
    }

    public Enumeration getFailures() {
        return this.failures.elements();
    }

    public void setShowoutput(boolean b) {
        this.showOutput = b;
    }

    public void setShowsummary(boolean b) {
        this.showSummary = b;
    }

    public void setFile(File f) {
        this.testFile = f;
    }

    public void setAssertsenabled(boolean b) {
        this.assertEnabled = b;
    }

    public void setFailonerror(boolean b) {
        this.failOnError = b;
    }

    public String getName() {
        return this.test_name;
    }

    public void setName(String n) {
        this.test_name = n;
    }

    public void setEnabled(boolean b) {
        this.enabled = b;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() {
        String ae;
        if (!this.enabled) {
            return;
        }
        if (this.testFile == null) {
            throw ProjectHelper.addLocationToBuildException((BuildException)new BuildException("missing file for testcase"), (Location)this.getLocation());
        }
        if (!this.testFile.exists()) {
            throw ProjectHelper.addLocationToBuildException((BuildException)new BuildException("file not found for testcase: " + this.testFile), (Location)this.getLocation());
        }
        String string = ae = this.assertEnabled ? "true" : "false";
        if (this.assertEnabled) {
            this.getProject().setProperty("ant.enable.asserts", ae);
        }
        Project myProject = new Project();
        this.initializeProject(myProject);
        try {
            ProjectHelper.configureProject((Project)myProject, (File)this.testFile);
        }
        catch (BuildException be) {
            throw ProjectHelper.addLocationToBuildException((BuildException)be, (Location)this.getLocation());
        }
        if (this.test_name == null || this.test_name.equals("")) {
            this.test_name = myProject.getName();
        }
        if (this.test_name == null || this.test_name.equals("")) {
            this.test_name = this.testFile.getName();
        }
        if (this.showOutput) {
            this.log(MessageBox.box("Starting test: " + this.test_name));
        }
        Hashtable targets = myProject.getTargets();
        Enumeration<Object> en = targets.keys();
        while (en.hasMoreElements()) {
            String target = (String)en.nextElement();
            if (target.equals("setUp")) {
                this.setUp = (Target)targets.get(target);
                continue;
            }
            if (target.equals("tearDown")) {
                this.tearDown = (Target)targets.get(target);
                continue;
            }
            if (target.startsWith("test")) {
                this.testTargets.addElement(targets.get(target));
                continue;
            }
            if (target.lastIndexOf(".") <= 0 || !target.substring(target.lastIndexOf(".") + 1).startsWith("test")) continue;
            this.testTargets.addElement(targets.get(target));
        }
        if (this.setUp != null) {
            this.setUp.execute();
        }
        StringBuffer messages = new StringBuffer();
        en = this.testTargets.elements();
        while (en.hasMoreElements()) {
            Target target = (Target)en.nextElement();
            try {
                myProject.executeTarget(target.getName());
                if (this.showOutput) {
                    this.log(target.getName() + " passed.");
                }
                ++this.tests_passed;
            }
            catch (Exception e) {
                String error;
                block25: {
                    block26: {
                        error = "ERROR: ";
                        if (!(e instanceof AssertException)) break block26;
                        int level = ((AssertException)((Object)e)).getLevel();
                        if (level == 0) {
                            ++this.tests_failed;
                            break block25;
                        } else if (level == 1) {
                            ++this.tests_warning;
                            error = "WARNING: ";
                            break block25;
                        } else {
                            if (!this.showOutput) continue;
                            this.log(target.getName() + ": " + e.getMessage());
                            continue;
                        }
                    }
                    ++this.tests_failed;
                }
                if (this.showOutput) {
                    this.log(error + target.getName() + " failed: " + e.getMessage());
                }
                this.failures.addElement(error + this.test_name + ": " + target.getName() + " failed: " + e.getMessage());
                if (!this.failOnError) continue;
                throw new BuildException(e.getMessage());
            }
        }
        if (this.tearDown != null) {
            this.tearDown.execute();
        }
        this.addAlmostAll(this.getProject(), myProject.getProperties());
        if (this.showSummary) {
            this.log(this.getSummary());
        }
    }

    public String getSummary() {
        String title = (this.test_name == null ? "Test" : this.test_name) + " Results";
        StringBuffer msg = new StringBuffer();
        String ls = System.getProperty("line.separator");
        if (this.failures.size() > 0) {
            String error_title = "Errors";
            StringBuffer error_msg = new StringBuffer();
            Enumeration en = this.failures.elements();
            while (en.hasMoreElements()) {
                error_msg.append((String)en.nextElement()).append(ls);
            }
            int box_width = MessageBox.getMaxWidth();
            MessageBox.setMaxWidth(box_width - 8);
            msg.append(MessageBox.box(error_title, error_msg));
            MessageBox.setMaxWidth(box_width);
            msg.append(ls);
        }
        msg.append("Ran:     ").append(this.getRanCount()).append(" out of ").append(this.getTestCaseCount()).append(" tests.").append(ls);
        msg.append("Passed:  ").append(this.getPassedCount()).append(ls);
        msg.append("Warning: ").append(this.getWarningCount()).append(ls);
        msg.append("Failed:  ").append(this.getFailedCount()).append(ls);
        return MessageBox.box(title, msg);
    }

    private void initializeProject(Project newProject) {
        newProject.setBaseDir(this.getProject().getBaseDir());
        newProject.setInputHandler(this.getProject().getInputHandler());
        Iterator iter = this.getProject().getBuildListeners().iterator();
        while (iter.hasNext()) {
            newProject.addBuildListener((BuildListener)iter.next());
        }
        this.getProject().initSubProject(newProject);
        this.getProject().copyInheritedProperties(newProject);
        this.getProject().copyUserProperties(newProject);
        this.addAlmostAll(newProject, this.getProject().getProperties());
    }

    private void addAlmostAll(Project project, Hashtable props) {
        Enumeration e = props.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement().toString();
            if ("basedir".equals(key) || "ant.file".equals(key)) continue;
            String value = props.get(key).toString();
            if (project.getProperty(key) != null) continue;
            project.setNewProperty(key, value);
        }
    }
}

