/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.security.descriptor;

import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import org.apache.axis.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.gsi.jaas.JaasGssUtil;
import org.globus.security.gridmap.GridMap;
import org.globus.util.I18n;
import org.globus.wsrf.config.ConfigException;
import org.globus.wsrf.config.ContainerConfig;
import org.globus.wsrf.impl.security.authorization.ServiceAuthorizationChain;
import org.globus.wsrf.impl.security.descriptor.ContainerSecurityDescriptor;
import org.globus.wsrf.impl.security.descriptor.SecurityConfig;
import org.globus.wsrf.impl.security.descriptor.SecurityDescriptor;
import org.globus.wsrf.impl.security.descriptor.util.ElementParserException;
import org.globus.wsrf.impl.security.util.PDPUtils;
import org.gridforum.jgss.ExtendedGSSManager;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSManager;
import org.w3c.dom.Document;

public class ContainerSecurityConfig
extends SecurityConfig {
    private static Log logger = LogFactory.getLog(ContainerSecurityConfig.class.getName());
    private static I18n i18n = I18n.getI18n("org.globus.wsrf.impl.security.descriptor.errors", SecurityConfig.class.getClassLoader());
    protected static ContainerSecurityConfig securityConfig;
    GSSCredential defaultCredential = null;
    boolean defaultCredUsed = false;
    private Map properties = new HashMap();

    ContainerSecurityConfig(String descFile) {
        this.descriptorFile = descFile;
    }

    public static synchronized ContainerSecurityConfig getConfig() throws ConfigException {
        return ContainerSecurityConfig.getConfig(ContainerSecurityConfig.getSecurityDescFile());
    }

    public static synchronized ContainerSecurityConfig getConfig(String secDescFilename) throws ConfigException {
        logger.debug("initialize called");
        if (securityConfig == null) {
            logger.debug("The file is " + secDescFilename);
            securityConfig = new ContainerSecurityConfig(secDescFilename);
            securityConfig.initialize();
        }
        return securityConfig;
    }

    protected void storeSecurityDescriptor() throws ConfigException {
        this.properties.put("securityDescriptor", this.desc);
    }

    protected void initialize() throws ConfigException {
        logger.debug(i18n.getMessage("containerDescInit"));
        try {
            super.initialize();
        }
        catch (ConfigException e) {
            throw new ConfigException(i18n.getMessage("containerInitFail"), e);
        }
    }

    protected boolean isInitialized() throws ConfigException {
        Boolean value = (Boolean)this.properties.get("securityInitialied");
        return value == null ? false : value;
    }

    protected void setInitialized(boolean init) throws ConfigException {
        this.properties.put("securityInitialied", new Boolean(init));
    }

    protected void initSecurityDescriptor(Document doc) throws ConfigException {
        this.desc = new ContainerSecurityDescriptor();
        if (doc != null) {
            try {
                this.desc.parse(doc.getDocumentElement());
            }
            catch (ElementParserException e) {
                throw new ConfigException(e);
            }
        }
    }

    protected void loadAuthorization() throws ConfigException {
        if (this.desc == null) {
            return;
        }
        String authzType = this.desc.getAuthz();
        if (authzType != null) {
            ServiceAuthorizationChain authzChain = PDPUtils.getContainerAuthzChain(authzType, this.jndiPathName);
            this.desc.setAuthzChain(authzChain);
        }
    }

    protected void initCredentials() throws ConfigException {
        logger.debug("Init creds called");
        Subject subject = null;
        boolean loaded = false;
        if (this.desc != null) {
            logger.debug("Not null, calling load creds");
            try {
                loaded = this.loadCredentials();
                subject = this.desc.getSubject();
            }
            catch (Exception exp) {
                throw new ConfigException(exp);
            }
        }
        if (!loaded) {
            this.defaultCredUsed = true;
            logger.debug("No configured subject, credential is not null");
            subject = this.getDefaultSubject();
            if (subject != null) {
                this.desc.setSubject(subject);
            }
        } else {
            logger.debug("Configured subject, credential is null");
            this.defaultCredential = null;
        }
    }

    private Subject getDefaultSubject() throws ConfigException {
        Subject subject = null;
        try {
            GSSManager manager = ExtendedGSSManager.getInstance();
            this.defaultCredential = manager.createCredential(0);
            subject = JaasGssUtil.createSubject(this.defaultCredential);
            subject.setReadOnly();
        }
        catch (Exception exp) {
            if (this.descriptorFile != null) {
                throw new ConfigException(exp);
            }
            logger.debug("insecure container, error is " + exp);
        }
        return subject;
    }

    private static String getSecurityDescFile() throws ConfigException {
        MessageContext ctx = MessageContext.getCurrentContext();
        if (ctx != null) {
            return ContainerConfig.getConfig(ctx.getAxisEngine()).getOption("containerSecDesc");
        }
        return ContainerConfig.getConfig().getOption("containerSecDesc");
    }

    public synchronized void refresh() throws ConfigException {
        boolean refreshReq = false;
        if (this.defaultCredUsed) {
            logger.debug("Default credentials used");
            refreshReq = true;
        } else {
            SecurityDescriptor desc = (SecurityDescriptor)this.properties.get("securityDescriptor");
            boolean bl = refreshReq = desc == null ? false : desc.isRefreshRequired();
        }
        if (refreshReq) {
            logger.debug(i18n.getMessage("containerDescRefresh"));
            this.initCredentials();
            this.storeSecurityDescriptor();
        } else {
            logger.debug("Refresh not required");
        }
    }

    public Subject getSubject() throws ConfigException {
        SecurityDescriptor desc = (SecurityDescriptor)this.properties.get("securityDescriptor");
        return desc == null ? null : desc.getSubject();
    }

    public GridMap getGridMap() throws ConfigException {
        SecurityDescriptor desc = (SecurityDescriptor)this.properties.get("securityDescriptor");
        return desc == null ? null : desc.getGridMap();
    }

    public ServiceAuthorizationChain getAuthzChain() throws ConfigException {
        SecurityDescriptor desc = (SecurityDescriptor)this.properties.get("securityDescriptor");
        return desc == null ? null : desc.getAuthzChain();
    }

    public ContainerSecurityDescriptor getSecurityDescriptor() throws ConfigException {
        return (ContainerSecurityDescriptor)this.properties.get("securityDescriptor");
    }

    public void setSubject(Subject subject) throws ConfigException {
        this.defaultCredential = null;
        this.desc.setSubject(subject);
        this.storeSecurityDescriptor();
    }

    public void setGridMap(GridMap gridMap) throws ConfigException {
        this.desc.setGridMap(gridMap);
        this.storeSecurityDescriptor();
    }

    public void setAuthzChain(ServiceAuthorizationChain authzChain) throws ConfigException {
        this.desc.setAuthzChain(authzChain);
        this.storeSecurityDescriptor();
    }

    public void setSecurityDescriptor(ContainerSecurityDescriptor desc) throws ConfigException {
        this.desc = desc;
        this.properties.put("securityDescriptor", desc);
    }

    public String getSecurityDescriptorFile() {
        return this.descriptorFile;
    }
}

