/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.client;

import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.rpc.Stub;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;
import org.globus.wsrf.client.BaseClient;
import org.globus.wsrf.utils.AnyHelper;
import org.globus.wsrf.utils.FaultHelper;
import org.oasis.wsrf.properties.GetMultipleResourcePropertiesResponse;
import org.oasis.wsrf.properties.GetMultipleResourceProperties_Element;
import org.oasis.wsrf.properties.GetMultipleResourceProperties_PortType;
import org.oasis.wsrf.properties.WSResourcePropertiesServiceAddressingLocator;

public class GetProperties
extends BaseClient {
    private static final String FOOTER = "Where:\n  propertyN is of form '{namespaceURI}localPart'\n";

    public static void main(String[] args) {
        GetProperties client = new GetProperties();
        client.setCustomUsage("property1 property2 ...");
        client.setHelpFooter(FOOTER);
        QName[] rps = null;
        try {
            CommandLine line = client.parse(args);
            List options = line.getArgList();
            if (options == null || options.isEmpty()) {
                throw new ParseException("Expected resource property name");
            }
            rps = new QName[options.size()];
            for (int i = 0; i < options.size(); ++i) {
                rps[i] = QName.valueOf((String)options.get(i));
            }
        }
        catch (ParseException e) {
            System.err.println("Error: " + e.getMessage());
            System.exit(1);
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
            System.exit(1);
        }
        WSResourcePropertiesServiceAddressingLocator locator = new WSResourcePropertiesServiceAddressingLocator();
        try {
            GetMultipleResourceProperties_PortType port = locator.getGetMultipleResourcePropertiesPort(client.getEPR());
            client.setOptions((Stub)((Object)port));
            GetMultipleResourceProperties_Element request = new GetMultipleResourceProperties_Element();
            request.setResourceProperty(rps);
            GetMultipleResourcePropertiesResponse response = port.getMultipleResourceProperties(request);
            System.out.println(AnyHelper.toSingleString(response));
        }
        catch (Exception e) {
            if (client.isDebugMode()) {
                FaultHelper.printStackTrace(e);
            } else {
                System.err.println("Error: " + FaultHelper.getMessage(e));
            }
            System.exit(2);
        }
    }
}

