/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.informationsystem.publisher.impl.registrations.resources;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.informationsystem.publisher.impl.registrations.resources.ISRegistryInstance;
import org.gcube.common.informationsystem.publisher.impl.registrations.resources.ISRegistryLookup;

public class ISRegistryInstanceGroup {
    private Set<ISRegistryInstance> registries = Collections.synchronizedSet(new HashSet());
    private static ISRegistryInstanceGroup list = new ISRegistryInstanceGroup();

    private ISRegistryInstanceGroup() {
    }

    public static ISRegistryInstanceGroup getInstanceGroup() {
        return list;
    }

    public Set<ISRegistryInstance> getRegistryInstancesForTypeAndScope(String type, GCUBEScope scope) throws ISRegistryLookup.NoRegistryAvailableException {
        HashSet<ISRegistryInstance> localSet = new HashSet<ISRegistryInstance>();
        for (ISRegistryInstance instance : this.registries) {
            if (!instance.getManagedResourceTypes().contains(type) || !instance.getScopes().contains(scope) && !instance.getScopes().contains(scope.getEnclosingScope())) continue;
            localSet.add(instance);
        }
        return localSet;
    }

    public void addRegistry(ISRegistryInstance instance) {
        if (!this.registries.contains(instance)) {
            this.registries.remove(instance);
        }
        this.registries.add(instance);
    }
}

