/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.security.authentication;

import org.apache.axis.AxisFault;
import org.apache.axis.MessageContext;
import org.apache.axis.handlers.BasicHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.wsrf.Resource;
import org.globus.wsrf.ResourceContext;
import org.globus.wsrf.ResourceContextException;
import org.globus.wsrf.ResourceException;
import org.globus.wsrf.config.ConfigException;
import org.globus.wsrf.impl.security.descriptor.ResourceSecurityDescriptor;
import org.globus.wsrf.impl.security.descriptor.SecureResourcePropertiesHelper;
import org.globus.wsrf.impl.security.descriptor.ServiceSecurityConfig;
import org.globus.wsrf.impl.security.descriptor.ServiceSecurityDescriptor;
import org.globus.wsrf.utils.ContextUtils;

public abstract class DescriptorHandler
extends BasicHandler {
    private static Log logger = LogFactory.getLog(DescriptorHandler.class.getName());

    public void invoke(MessageContext msgCtx) throws AxisFault {
        String servicePath = ContextUtils.getTargetServicePath(msgCtx);
        if (servicePath == null) {
            return;
        }
        logger.debug("Service path " + servicePath);
        Resource resource = null;
        try {
            ResourceContext context = ResourceContext.getResourceContext(msgCtx);
            resource = context.getResource();
        }
        catch (ResourceContextException exp) {
            logger.debug("Resource does not exist ", exp);
            resource = null;
        }
        catch (ResourceException exp) {
            logger.debug("Resource does not exist ", exp);
            resource = null;
        }
        ResourceSecurityDescriptor resDesc = null;
        if (resource != null) {
            resDesc = SecureResourcePropertiesHelper.getResourceSecDescriptor(resource);
        }
        ServiceSecurityDescriptor desc = null;
        try {
            desc = ServiceSecurityConfig.getSecurityDescriptor(servicePath);
        }
        catch (ConfigException e) {
            throw AxisFault.makeFault(e);
        }
        if (resDesc == null && desc == null) {
            msgCtx.setProperty("org.globus.security.authz.required", Boolean.FALSE);
        }
        this.handle(msgCtx, resDesc, desc, servicePath);
    }

    public abstract void handle(MessageContext var1, ResourceSecurityDescriptor var2, ServiceSecurityDescriptor var3, String var4) throws AxisFault;
}

