/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.InputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.TimeZone;
import org.opensaml.MalformedException;
import org.opensaml.QName;
import org.opensaml.SAMLAuthorityBinding;
import org.opensaml.SAMLException;
import org.opensaml.SAMLSubject;
import org.opensaml.SAMLSubjectStatement;
import org.opensaml.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAMLAuthenticationStatement
extends SAMLSubjectStatement
implements Cloneable {
    protected String subjectIP = null;
    protected String subjectDNS = null;
    protected String authMethod = null;
    protected Date authInstant = null;
    protected ArrayList bindings = new ArrayList();
    public static final String AuthenticationMethod_Password = "urn:oasis:names:tc:SAML:1.0:am:password";
    public static final String AuthenticationMethod_Kerberos = "urn:ietf:rfc:1510";
    public static final String AuthenticationMethod_SRP = "urn:ietf:rfc:2945";
    public static final String AuthenticationMethod_HardwareToken = "urn:oasis:names:tc:SAML:1.0:am:HardwareToken";
    public static final String AuthenticationMethod_SSL_TLS_Client = "urn:ietf:rfc:2246";
    public static final String AuthenticationMethod_X509_PublicKey = "urn:oasis:names:tc:SAML:1.0:am:X509-PKI";
    public static final String AuthenticationMethod_PGP_PublicKey = "urn:oasis:names:tc:SAML:1.0:am:PGP";
    public static final String AuthenticationMethod_SPKI_PublicKey = "urn:oasis:names:tc:SAML:1.0:am:SPKI";
    public static final String AuthenticationMethod_XKMS_PublicKey = "urn:oasis:names:tc:SAML:1.0:am:XKMS";
    public static final String AuthenticationMethod_XML_DSig = "urn:ietf:rfc:3075";
    public static final String AuthenticationMethod_Unspecified = "urn:oasis:names:tc:SAML:1.0:am:unspecified";

    public SAMLAuthenticationStatement() {
    }

    public SAMLAuthenticationStatement(SAMLSubject sAMLSubject, String string, Date date, String string2, String string3, Collection collection) throws SAMLException {
        super(sAMLSubject);
        this.subjectIP = string2;
        this.subjectDNS = string3;
        this.authMethod = string;
        this.authInstant = date;
        if (collection != null) {
            this.bindings.addAll(collection);
        }
    }

    public SAMLAuthenticationStatement(SAMLSubject sAMLSubject, Date date, String string, String string2, Collection collection) throws SAMLException {
        this(sAMLSubject, AuthenticationMethod_Unspecified, date, string, string2, collection);
    }

    public SAMLAuthenticationStatement(Element element) throws SAMLException {
        this.fromDOM(element);
    }

    public SAMLAuthenticationStatement(InputStream inputStream) throws SAMLException {
        this.fromDOM(SAMLAuthenticationStatement.fromStream(inputStream));
    }

    public void fromDOM(Element element) throws SAMLException {
        Object object;
        super.fromDOM(element);
        if (this.config.getBooleanProperty("org.opensaml.strict-dom-checking") && !XML.isElementNamed(element, "urn:oasis:names:tc:SAML:1.0:assertion", "AuthenticationStatement")) {
            object = QName.getQNameAttribute(element, "http://www.w3.org/2001/XMLSchema-instance", "type");
            if (!(XML.isElementNamed(element, "urn:oasis:names:tc:SAML:1.0:assertion", "Statement") && object != null && "urn:oasis:names:tc:SAML:1.0:assertion".equals(((QName)object).getNamespaceURI()) && "AuthenticationStatementType".equals(((QName)object).getLocalName()))) {
                throw new MalformedException(SAMLException.RESPONDER, "SAMLAuthenticationStatement() requires saml:AuthenticationStatement at root");
            }
        }
        this.authMethod = element.getAttributeNS(null, "AuthenticationMethod");
        try {
            object = null;
            String string = element.getAttributeNS(null, "AuthenticationInstant");
            int n = string.indexOf(46);
            object = n > 0 ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'") : new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            ((DateFormat)object).setTimeZone(TimeZone.getTimeZone("GMT"));
            this.authInstant = ((DateFormat)object).parse(string);
        }
        catch (ParseException parseException) {
            throw new MalformedException(SAMLException.RESPONDER, "SAMLAuthenticationStatement() detected an invalid datetime while parsing statement", (Exception)parseException);
        }
        object = XML.getFirstChildElement(this.root, "urn:oasis:names:tc:SAML:1.0:assertion", "SubjectLocality");
        if (object != null) {
            this.subjectIP = object.getAttributeNS(null, "IPAddress");
            this.subjectDNS = object.getAttributeNS(null, "DNSAddress");
            object = XML.getNextSiblingElement((Node)object);
        }
        object = XML.getFirstChildElement(this.root, "urn:oasis:names:tc:SAML:1.0:assertion", "AuthorityBinding");
        while (object != null) {
            this.bindings.add(new SAMLAuthorityBinding((Element)object));
            object = XML.getNextSiblingElement((Node)object, "urn:oasis:names:tc:SAML:1.0:assertion", "AuthorityBinding");
        }
        this.checkValidity();
    }

    public String getSubjectIP() {
        return this.subjectIP;
    }

    public void setSubjectIP(String string) {
        this.subjectIP = string;
        if (this.root != null) {
            Element element = XML.getFirstChildElement(this.root, "urn:oasis:names:tc:SAML:1.0:assertion", "SubjectLocality");
            if (element != null) {
                element.removeAttributeNS(null, "IPAddress");
                if (!XML.isEmpty(string)) {
                    element.setAttributeNS(null, "IPAddress", string);
                } else if (!element.hasAttributes()) {
                    this.root.removeChild(element);
                }
            } else if (!XML.isEmpty(string)) {
                element = this.root.getOwnerDocument().createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "SubjectLocality");
                element.setAttributeNS(null, "IPAddress", string);
                this.root.insertBefore(element, this.subject.root.getNextSibling());
            }
        }
    }

    public String getSubjectDNS() {
        return this.subjectDNS;
    }

    public void setSubjectDNS(String string) {
        this.subjectDNS = string;
        if (this.root != null) {
            Element element = XML.getFirstChildElement(this.root, "urn:oasis:names:tc:SAML:1.0:assertion", "SubjectLocality");
            if (element != null) {
                element.removeAttributeNS(null, "DNSAddress");
                if (!XML.isEmpty(string)) {
                    element.setAttributeNS(null, "DNSAddress", string);
                } else if (!element.hasAttributes()) {
                    this.root.removeChild(element);
                }
            } else if (!XML.isEmpty(string)) {
                element = this.root.getOwnerDocument().createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "SubjectLocality");
                element.setAttributeNS(null, "DNSAddress", string);
                this.root.insertBefore(element, this.subject.root.getNextSibling());
            }
        }
    }

    public String getAuthMethod() {
        return this.authMethod;
    }

    public void setAuthMethod(String string) {
        if (XML.isEmpty(string)) {
            throw new IllegalArgumentException("authMethod cannot be null");
        }
        this.authMethod = string;
        if (this.root != null) {
            ((Element)this.root).getAttributeNodeNS(null, "AuthenticationMethod").setNodeValue(string);
        }
    }

    public Date getAuthInstant() {
        return this.authInstant;
    }

    public void setAuthInstant(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("authInstant cannot be null");
        }
        if (this.root != null) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            ((Element)this.root).getAttributeNodeNS(null, "AuthenticationInstant").setNodeValue(simpleDateFormat.format(date));
        }
        this.authInstant = date;
    }

    public Iterator getBindings() {
        return this.bindings.iterator();
    }

    public void setBindings(Collection collection) throws SAMLException {
        while (this.bindings.size() > 0) {
            this.removeBinding(0);
        }
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.addBinding((SAMLAuthorityBinding)iterator.next());
            }
        }
    }

    public void addBinding(SAMLAuthorityBinding sAMLAuthorityBinding) throws SAMLException {
        if (sAMLAuthorityBinding != null) {
            if (this.root != null) {
                Node node = sAMLAuthorityBinding.toDOM(this.root.getOwnerDocument());
                Element element = XML.getLastChildElement(this.root, "urn:oasis:names:tc:SAML:1.0:assertion", "AuthorityBinding");
                if (element == null) {
                    Element element2 = XML.getFirstChildElement(this.root, "urn:oasis:names:tc:SAML:1.0:assertion", "SubjectLocality");
                    if (element2 == null) {
                        this.root.insertBefore(node, this.subject.root.getNextSibling());
                    } else {
                        this.root.insertBefore(node, element2.getNextSibling());
                    }
                } else {
                    this.root.insertBefore(node, element.getNextSibling());
                }
            }
        } else {
            throw new IllegalArgumentException("binding cannot be null");
        }
        this.bindings.add(sAMLAuthorityBinding);
    }

    public void removeBinding(int n) {
        this.bindings.remove(n);
        if (this.root != null) {
            Element element = XML.getFirstChildElement(this.root, "urn:oasis:names:tc:SAML:1.0:assertion", "AuthorityBinding");
            while (element != null && n > 0) {
                element = XML.getNextSiblingElement(element);
                --n;
            }
            if (element != null) {
                this.root.removeChild(element);
            } else {
                throw new IndexOutOfBoundsException();
            }
        }
    }

    public Node toDOM(Document document, boolean bl) throws SAMLException {
        Object object;
        this.root = super.toDOM(document, bl);
        if (this.root != null) {
            if (bl) {
                ((Element)this.root).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:assertion");
            }
            return this.root;
        }
        Element element = document.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "AuthenticationStatement");
        if (bl) {
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:assertion");
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        element.setAttributeNS(null, "AuthenticationInstant", simpleDateFormat.format(this.authInstant));
        element.setAttributeNS(null, "AuthenticationMethod", this.authMethod);
        element.appendChild(this.subject.toDOM(document, false));
        if (!XML.isEmpty(this.subjectIP) || !XML.isEmpty(this.subjectDNS)) {
            object = document.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "SubjectLocality");
            if (!XML.isEmpty(this.subjectIP)) {
                object.setAttributeNS(null, "IPAddress", this.subjectIP);
            }
            if (!XML.isEmpty(this.subjectDNS)) {
                object.setAttributeNS(null, "DNSAddress", this.subjectDNS);
            }
            element.appendChild((Node)object);
        }
        object = this.bindings.iterator();
        while (object.hasNext()) {
            element.appendChild(((SAMLAuthorityBinding)object.next()).toDOM(document, false));
        }
        this.root = element;
        return this.root;
    }

    public void checkValidity() throws SAMLException {
        if (XML.isEmpty(this.authMethod) || this.authInstant == null) {
            throw new MalformedException(SAMLException.RESPONDER, "AuthenticationStatement is invalid, requires AuthenticationMethod and AuthenticationInstant");
        }
    }

    public Object clone() throws CloneNotSupportedException {
        SAMLAuthenticationStatement sAMLAuthenticationStatement = (SAMLAuthenticationStatement)super.clone();
        Iterator iterator = this.bindings.iterator();
        while (iterator.hasNext()) {
            sAMLAuthenticationStatement.bindings.add(((SAMLAuthorityBinding)iterator.next()).clone());
        }
        return sAMLAuthenticationStatement;
    }
}

