/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.security.authentication.transport;

import java.security.Principal;
import java.security.cert.X509Certificate;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import org.apache.axis.AxisFault;
import org.apache.axis.MessageContext;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.transport.http.HTTPConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.gsi.gssapi.GSSConstants;
import org.globus.gsi.jaas.GlobusPrincipal;
import org.globus.util.I18n;
import org.globus.wsrf.impl.security.authentication.Constants;
import org.globus.wsrf.utils.Resources;
import org.gridforum.jgss.ExtendedGSSContext;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;

public class TomcatTransportSecurityHandler
extends BasicHandler {
    private static final I18n i18n = I18n.getI18n((String)Resources.class.getName());
    private static Log logger = LogFactory.getLog((String)TomcatTransportSecurityHandler.class.getName());

    public void invoke(MessageContext msgContext) throws AxisFault {
        GSSContext context;
        logger.debug((Object)"Enter: invoke");
        Object tmp = msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        if (tmp == null || !(tmp instanceof HttpServletRequest)) {
            return;
        }
        HttpServletRequest req = (HttpServletRequest)tmp;
        String url = req.getRequestURL().toString();
        tmp = msgContext.getProperty("transport.url");
        if (tmp == null && url != null) {
            msgContext.setProperty("transport.url", (Object)url);
        }
        Subject subject = this.getSubject(msgContext);
        tmp = req.getAttribute("org.globus.gsi.authorized.user.dn");
        if (tmp != null) {
            subject.getPrincipals().add((Principal)new GlobusPrincipal((String)tmp));
        }
        if ((context = (GSSContext)req.getAttribute("org.globus.gsi.context")) != null) {
            msgContext.setProperty("org.globus.security.transport.context", (Object)context);
            if (context.getConfState()) {
                msgContext.setProperty("org.globus.security.transport.type", (Object)Constants.ENCRYPTION);
            } else if (context.getIntegState()) {
                msgContext.setProperty("org.globus.security.transport.type", (Object)Constants.SIGNATURE);
            } else {
                msgContext.setProperty("org.globus.security.transport.type", (Object)Constants.NONE);
            }
            if (context instanceof ExtendedGSSContext) {
                ExtendedGSSContext extGss = (ExtendedGSSContext)context;
                X509Certificate[] certs = null;
                try {
                    certs = (X509Certificate[])extGss.inquireByOid(GSSConstants.X509_CERT_CHAIN);
                }
                catch (GSSException e) {
                    logger.error((Object)i18n.getMessage("general"), (Throwable)e);
                }
                if (certs != null) {
                    subject.getPublicCredentials().add(certs);
                }
            }
        }
        logger.debug((Object)"Exit: invoke");
    }

    private Subject getSubject(MessageContext msgContext) {
        Subject subject = (Subject)msgContext.getProperty("callerSubject");
        if (subject == null) {
            subject = new Subject();
            msgContext.setProperty("callerSubject", (Object)subject);
        }
        return subject;
    }
}

