/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.security.authentication.wssec;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import org.apache.axis.MessageContext;
import org.apache.axis.message.addressing.MessageID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.SOAPConstants;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.message.EnvelopeIdResolver;
import org.apache.ws.security.message.token.Timestamp;
import org.apache.ws.security.message.token.UsernameToken;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.content.X509Data;
import org.apache.xml.security.keys.content.x509.XMLX509Certificate;
import org.apache.xml.security.signature.Reference;
import org.apache.xml.security.signature.SignedInfo;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.utils.IdResolver;
import org.globus.gsi.CertUtil;
import org.globus.gsi.CertificateRevocationLists;
import org.globus.gsi.TrustedCertificates;
import org.globus.gsi.gssapi.GSSConstants;
import org.globus.gsi.jaas.GlobusPrincipal;
import org.globus.gsi.jaas.PasswordCredential;
import org.globus.gsi.jaas.UserNamePrincipal;
import org.globus.gsi.proxy.ProxyPathValidator;
import org.globus.util.I18n;
import org.globus.wsrf.NoResourceHomeException;
import org.globus.wsrf.Resource;
import org.globus.wsrf.ResourceContext;
import org.globus.wsrf.ResourceContextException;
import org.globus.wsrf.ResourceException;
import org.globus.wsrf.impl.security.authentication.Constants;
import org.globus.wsrf.impl.security.authentication.ContextCrypto;
import org.globus.wsrf.impl.security.authentication.secureconv.service.SecurityContext;
import org.globus.wsrf.impl.security.authentication.wssec.GSSConfig;
import org.globus.wsrf.impl.security.authentication.wssec.GSSSecurityEngine;
import org.globus.wsrf.impl.security.authentication.wssec.ReplayAttackFilter;
import org.globus.wsrf.impl.security.authentication.wssec.WSConstants;
import org.globus.wsrf.impl.security.authentication.wssec.WSSecurityCallbackHandler;
import org.globus.wsrf.impl.security.authentication.wssec.WSSecurityException;
import org.globus.wsrf.impl.security.descriptor.SecurityPropertiesHelper;
import org.globus.wsrf.impl.security.util.EnvelopeConverter;
import org.globus.wsrf.utils.ContextUtils;
import org.globus.wsrf.utils.XmlUtils;
import org.gridforum.jgss.ExtendedGSSContext;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSName;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class WSSecurityEngine {
    protected static I18n i18n = I18n.getI18n((String)"org.globus.wsrf.impl.security.authentication.wssec.errors");
    private static Log log = LogFactory.getLog((String)WSSecurityEngine.class.getName());
    public static final String SIG_LN = "Signature";
    private org.apache.ws.security.WSSecurityEngine wssEngine;
    private static ContextCrypto crypto = ContextCrypto.getInstance();

    public boolean handleSignatureElement(Element element, javax.xml.rpc.handler.MessageContext msgCtx, boolean request) throws Exception {
        WSSecurityEngine.normalize(element);
        XMLSignature sig = new XMLSignature(element, null);
        sig.addResourceResolver(EnvelopeIdResolver.getInstance((WSSConfig)WSSConfig.getDefaultWSConfig()));
        SignedInfo info = sig.getSignedInfo();
        boolean sigValid = false;
        if (info.getSignatureMethodURI().equalsIgnoreCase("http://www.globus.org/2002/04/xmlenc#gssapi-sign")) {
            log.debug((Object)"Found GSS XML signature");
            sigValid = this.verifyGssXMLSignature(sig, msgCtx);
        } else {
            log.debug((Object)"Found XML signature");
            sigValid = this.verifyXMLSignature(sig, msgCtx);
        }
        if (sigValid) {
            this.enforceSecureDispatchHeaders(info, msgCtx, request);
        }
        return sigValid;
    }

    protected void enforceSecureDispatchHeaders(SignedInfo info, javax.xml.rpc.handler.MessageContext msgCtx, boolean request) throws Exception {
        int referenceLength = info.getLength();
        HashMap<QName, String> signedQName = new HashMap<QName, String>();
        for (int i = 0; i < referenceLength; ++i) {
            Reference ref = info.item(i);
            log.debug((Object)("Reference URI " + ref.getURI()));
            XMLSignatureInput input = ref.getContentsBeforeTransformation();
            Set nodeSet = input.getNodeSet();
            Iterator iter = nodeSet.iterator();
            while (iter.hasNext()) {
                Node node = (Node)iter.next();
                if (node.getNodeType() != 1) continue;
                QName qName = new QName(node.getNamespaceURI(), node.getLocalName());
                log.debug((Object)("Adding Qname " + qName));
                signedQName.put(qName, "");
            }
        }
        if (request) {
            HashMap<QName, String> enforceQName = (HashMap<QName, String>)msgCtx.getProperty("org.globus.security.secure.headers.enforced");
            QName keyName = this.getResourceKeyHeaderQName(msgCtx);
            log.debug((Object)("Key name " + keyName));
            if (keyName != null) {
                if (enforceQName == null) {
                    enforceQName = new HashMap<QName, String>();
                }
                enforceQName.put(keyName, "");
            }
            if (enforceQName != null) {
                Iterator keysIterator = enforceQName.keySet().iterator();
                while (keysIterator.hasNext()) {
                    QName headerQName = (QName)keysIterator.next();
                    if (signedQName.containsKey(headerQName)) continue;
                    throw new WSSecurityException(0, "insecureHeader", new Object[]{headerQName});
                }
            }
        }
    }

    protected QName getResourceKeyHeaderQName(javax.xml.rpc.handler.MessageContext msgCtx) throws Exception {
        QName keyName = null;
        ResourceContext resCtx = ResourceContext.getResourceContext((SOAPMessageContext)((MessageContext)msgCtx));
        SOAPHeaderElement keyHeader = null;
        try {
            keyHeader = resCtx.getResourceKeyHeader();
        }
        catch (NoResourceHomeException exp) {
            log.debug((Object)exp);
        }
        if (keyHeader != null) {
            Name name = keyHeader.getElementName();
            keyName = new QName(name.getURI(), name.getLocalName());
        }
        return keyName;
    }

    public abstract boolean verifyGssXMLSignature(XMLSignature var1, javax.xml.rpc.handler.MessageContext var2) throws Exception;

    protected X509Certificate[] getCertificatesX509Data(KeyInfo info) throws Exception {
        int len = info.lengthX509Data();
        if (len != 1) {
            throw new WSSecurityException(0, "invalidX509Data", new Object[]{new Integer(len)});
        }
        X509Data data = info.itemX509Data(0);
        int certLen = data.lengthCertificate();
        if (certLen <= 0) {
            throw new WSSecurityException(0, "invalidCertData", new Object[]{new Integer(certLen)});
        }
        X509Certificate[] certs = new X509Certificate[certLen];
        for (int i = 0; i < certLen; ++i) {
            XMLX509Certificate xmlCert = data.itemCertificate(i);
            ByteArrayInputStream input = new ByteArrayInputStream(xmlCert.getCertificateBytes());
            certs[i] = CertUtil.loadCertificate((InputStream)input);
        }
        return certs;
    }

    public abstract boolean verifyXMLSignature(XMLSignature var1, javax.xml.rpc.handler.MessageContext var2) throws Exception;

    protected boolean verifyXMLSignature(XMLSignature sig, javax.xml.rpc.handler.MessageContext msgCtx, ProxyPathValidator validator) throws Exception {
        log.debug((Object)"Verify XML Signature");
        X509Certificate[] certs = null;
        KeyInfo info = sig.getKeyInfo();
        if (info.containsX509Data()) {
            certs = this.getCertificatesX509Data(info);
        } else {
            Node node = WSSecurityUtil.getDirectChild((Node)info.getElement(), (String)"SecurityTokenReference", (String)WSSConfig.getDefaultWSConfig().getWsseNS());
            if (node == null) {
                throw new WSSecurityException(3, "unsupportedKeyInfo", null);
            }
            String uri = ((Element)node.getFirstChild()).getAttribute("URI");
            Element tokElement = WSSecurityUtil.getElementByWsuId((WSSConfig)WSSConfig.getDefaultWSConfig(), (Document)node.getOwnerDocument(), (String)uri);
            certs = org.apache.ws.security.WSSecurityEngine.getInstance().getCertificatesTokenReference(tokElement, (Crypto)crypto);
        }
        if (!sig.checkSignatureValue(certs[0])) {
            throw new WSSecurityException(6);
        }
        X509Certificate[] trustedCerts = null;
        TrustedCertificates crts = TrustedCertificates.getDefaultTrustedCertificates();
        if (crts != null) {
            trustedCerts = crts.getCertificates();
        }
        CertificateRevocationLists defaultCrls = CertificateRevocationLists.getDefaultCertificateRevocationLists();
        if (log.isDebugEnabled()) {
            for (int i = 0; i < certs.length; ++i) {
                log.debug((Object)("Cert " + certs[i].getSubjectDN().getName()));
            }
        }
        validator.validate(certs, trustedCerts, defaultCrls);
        String identity = validator.getIdentity();
        msgCtx.setProperty("org.globus.security.secMsg.msg.type", (Object)Constants.SIGNATURE);
        Subject subject = this.getSubject(msgCtx);
        subject.getPublicCredentials().add(certs);
        subject.getPrincipals().add((Principal)new GlobusPrincipal(identity));
        return true;
    }

    protected Subject getSubject(javax.xml.rpc.handler.MessageContext msgCtx) {
        Subject subject = (Subject)msgCtx.getProperty("callerSubject");
        if (subject == null) {
            subject = new Subject();
            msgCtx.setProperty("callerSubject", (Object)subject);
        }
        return subject;
    }

    public boolean handleEncryptionElement(Element element, javax.xml.rpc.handler.MessageContext msgCtx) throws Exception {
        if (element.getLocalName().equals("EncryptedKey")) {
            log.debug((Object)"Found XML Encryption");
            return this.decryptXMLEncryption(element, msgCtx);
        }
        Element tmpE = (Element)WSSecurityUtil.findElement((Node)element.getOwnerDocument(), (String)"EncryptionMethod", (String)"http://www.w3.org/2001/04/xmlenc#");
        tmpE = (Element)WSSecurityUtil.findElement((Node)element, (String)"DataReference", (String)"http://www.w3.org/2001/04/xmlenc#");
        String uri = tmpE.getAttribute("URI");
        Element encryptedDataElem = IdResolver.getElementById((Document)element.getOwnerDocument(), (String)uri.substring(1));
        if (encryptedDataElem == null) {
            throw new WSSecurityException(0, "noEncryptedData", new Object[]{tmpE.getAttribute("URI")});
        }
        this.wssEngine.decryptDataRefEmbedded(encryptedDataElem.getOwnerDocument(), uri, (CallbackHandler)new WSSecurityCallbackHandler((MessageContext)msgCtx));
        this.setContextProperties(msgCtx, (SecurityContext)msgCtx.getProperty("org.globus.security.secureconv.context"), Constants.ENCRYPTION);
        return true;
    }

    public abstract boolean decryptXMLEncryption(Element var1, javax.xml.rpc.handler.MessageContext var2) throws Exception;

    public boolean decryptXMLEncryption(Element element, PrivateKey privateKey) throws Exception {
        this.wssEngine.handleEncryptedKey(element, privateKey);
        Document doc = element.getOwnerDocument();
        Element soapBodyElement = WSSecurityUtil.findBodyElement((Document)doc, (SOAPConstants)WSSecurityUtil.getSOAPConstants((Element)doc.getDocumentElement()));
        Element bodyElement = XmlUtils.getFirstChildElement(soapBodyElement);
        bodyElement.removeAttributeNS("http://www.w3.org/2000/xmlns/", "xenc");
        log.debug((Object)"Exit: decryptXMLEncryption");
        return true;
    }

    public abstract Document processSecurityHeader(SOAPEnvelope var1, javax.xml.rpc.handler.MessageContext var2) throws Exception;

    public Document processSecurityHeader(SOAPEnvelope env, javax.xml.rpc.handler.MessageContext msgCtx, boolean request) throws Exception {
        return this.processSecurityHeader(env, (String)msgCtx.getProperty("actor"), msgCtx, request);
    }

    public Document processSecurityHeader(SOAPEnvelope env, String actor, javax.xml.rpc.handler.MessageContext msgCtx, boolean request) throws Exception {
        if (actor == null) {
            actor = "";
        }
        SOAPHeaderElement securityHeader = null;
        SOAPHeaderElement messageIDHeader = null;
        SOAPHeader header = env.getHeader();
        if (header == null) {
            return null;
        }
        Iterator headerElements = header.examineHeaderElements(actor);
        int headerCnt = 0;
        while (headerElements.hasNext()) {
            SOAPHeaderElement he = (SOAPHeaderElement)headerElements.next();
            Name nm = he.getElementName();
            if (nm.getLocalName().equalsIgnoreCase("Security") && nm.getURI().equalsIgnoreCase(WSConstants.WSSE_NS)) {
                securityHeader = he;
                ++headerCnt;
            } else if (nm.getLocalName().equalsIgnoreCase("MessageID") && nm.getURI().equalsIgnoreCase("http://schemas.xmlsoap.org/ws/2004/03/addressing")) {
                messageIDHeader = he;
                ++headerCnt;
            }
            if (headerCnt != 2) continue;
            break;
        }
        if (securityHeader == null) {
            return null;
        }
        GSSConfig.init();
        if (this.wssEngine == null) {
            this.wssEngine = GSSSecurityEngine.getInstance();
        }
        Document doc = EnvelopeConverter.getInstance().toDocument(env);
        NodeList list = doc.getElementsByTagNameNS(org.apache.ws.security.WSConstants.WSSE_NS, "Security");
        int len = list.getLength();
        String headerActor = null;
        for (int i = 0; i < len; ++i) {
            Element elem = (Element)list.item(i);
            Attr attr = elem.getAttributeNodeNS("http://schemas.xmlsoap.org/soap/envelope/", "actor");
            if (attr != null) {
                headerActor = attr.getValue();
            }
            if (headerActor != null && headerActor.length() != 0 && !headerActor.equalsIgnoreCase(actor) && !headerActor.equals("http://schemas.xmlsoap.org/soap/actor/next")) continue;
            this.processSecurityHeader(elem, msgCtx, headerActor, messageIDHeader, request);
        }
        return doc;
    }

    public void processSecurityHeader(Element securityHeader, javax.xml.rpc.handler.MessageContext msgCtx, String actor, SOAPHeaderElement messageIdHeader, boolean request) throws Exception {
        boolean route;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Processing WS-Security header for '" + actor + "' actor." + " request (so process timestamp) " + request));
        }
        Element timestampElem = null;
        NodeList list = securityHeader.getChildNodes();
        int len = list.getLength();
        String ns = null;
        String ln = null;
        for (int i = 0; i < len; ++i) {
            Node elem = list.item(i);
            ns = elem.getNamespaceURI();
            ln = elem.getLocalName();
            if ("http://www.w3.org/2000/09/xmldsig#".equalsIgnoreCase(ns) && SIG_LN.equalsIgnoreCase(ln)) {
                log.debug((Object)"Found signature element");
                if (this.handleSignatureElement((Element)elem, msgCtx, request)) continue;
                throw new WSSecurityException(6);
            }
            if ("http://www.w3.org/2001/04/xmlenc#".equalsIgnoreCase(ns)) {
                log.debug((Object)"Found encryption element");
                this.handleEncryptionElement((Element)elem, msgCtx);
                continue;
            }
            if ("UsernameToken".equalsIgnoreCase(ln)) {
                log.debug((Object)"Found user name token");
                this.handleUsernameElement((Element)elem, msgCtx);
                continue;
            }
            if (WSConstants.WSU_NS.equalsIgnoreCase(ns) && "Timestamp".equalsIgnoreCase(ln)) {
                log.debug((Object)"Found timestamp element");
                timestampElem = (Element)elem;
                WSSecurityEngine.normalize(timestampElem);
                continue;
            }
            if (elem.getNodeType() != 1) continue;
            log.debug((Object)(elem.getLocalName() + " " + elem.getNamespaceURI()));
        }
        if (request) {
            log.debug((Object)"Secure message, timestamp might be required");
            if (this.constantSet(msgCtx.getProperty("org.globus.security.secMsg.msg.type"), Constants.SIGNATURE) || this.constantSet(msgCtx.getProperty("org.globus.security.secMsg.msg.type"), Constants.ENCRYPTION)) {
                this.processTimestampHeader(timestampElem, msgCtx, messageIdHeader);
            }
        }
        boolean bl = route = "".equals(actor) && Boolean.TRUE.equals(msgCtx.getProperty("org.globus.ogsa.router"));
        if (!route) {
            securityHeader.getParentNode().removeChild(securityHeader);
        } else {
            log.debug((Object)"Header not removed");
        }
    }

    public boolean handleUsernameElement(Element element, javax.xml.rpc.handler.MessageContext msgCtx) throws Exception {
        log.debug((Object)"User name processing");
        UsernameToken userNameTok = new UsernameToken(WSSConfig.getDefaultWSConfig(), element);
        String userName = userNameTok.getName();
        String password = userNameTok.getPassword();
        Subject subject = this.getSubject(msgCtx);
        subject.getPrincipals().add((Principal)new UserNamePrincipal(userName));
        if (password != null) {
            subject.getPrivateCredentials().add(new PasswordCredential(password));
        }
        msgCtx.setProperty("userNameAuthz", (Object)Boolean.TRUE);
        return false;
    }

    protected void processTimestampHeader(Element timestampElem, javax.xml.rpc.handler.MessageContext msgCtx, SOAPHeaderElement messageIDHeader) throws Exception {
        String propertyValue;
        String servicePath = ContextUtils.getTargetServicePath((MessageContext)msgCtx);
        if (servicePath == null) {
            throw new Exception(i18n.getMessage("serviceNull"));
        }
        Resource resource = null;
        try {
            ResourceContext resCtx = ResourceContext.getResourceContext((SOAPMessageContext)((MessageContext)msgCtx));
            resource = resCtx.getResource();
        }
        catch (ResourceContextException exp) {
            log.debug((Object)"Resource does not exist ", (Throwable)exp);
        }
        catch (ResourceException exp) {
            log.debug((Object)"Resource does not exist ", (Throwable)exp);
        }
        if (timestampElem != null) {
            propertyValue = SecurityPropertiesHelper.getReplayAttackWindow(servicePath, resource);
            ReplayAttackFilter replayFilter = ReplayAttackFilter.getInstance(propertyValue);
            if (messageIDHeader == null) {
                Timestamp timestamp = new Timestamp(WSSConfig.getDefaultWSConfig(), timestampElem);
                boolean stampOk = this.verifyTimestamp(timestamp, replayFilter.getMessageWindow());
                if (!stampOk) {
                    throw new WSSecurityException(0, "timestampNotOk");
                }
            } else {
                this.checkMessageValidity(replayFilter, timestampElem, messageIDHeader);
            }
        } else {
            propertyValue = SecurityPropertiesHelper.getReplayAttackFilter(servicePath, resource);
            if (this.rejectMsgSansTimestampHeader(msgCtx, propertyValue)) {
                log.debug((Object)"Required time stamp header was not added.");
                throw new WSSecurityException(0, "timestampRequired");
            }
        }
        log.debug((Object)"Done processing timestamp header.");
    }

    protected boolean verifyTimestamp(Timestamp timestamp, int TTL) {
        return this.verifyTimestamp(timestamp.getCreated(), TTL);
    }

    protected boolean verifyTimestamp(Calendar created, int TTL) {
        Calendar validCreation = Calendar.getInstance();
        long currentTime = validCreation.getTime().getTime();
        validCreation.setTime(new Date(currentTime -= (long)(TTL * 1000)));
        return created.after(validCreation);
    }

    protected void checkMessageValidity(ReplayAttackFilter replayFilter, Element timestampElem, SOAPHeaderElement messageIDHeader) throws Exception {
        Timestamp timeStamp = new Timestamp(WSSConfig.getDefaultWSConfig(), timestampElem);
        MessageID messageId = new MessageID(messageIDHeader);
        replayFilter.checkMessageValidity(messageId.toString(), timeStamp.getCreated());
    }

    protected boolean rejectMsgSansTimestampHeader(javax.xml.rpc.handler.MessageContext msgCtx, String propertyValue) throws Exception {
        return propertyValue == null || !propertyValue.equals("false");
    }

    public static void normalize(Node node) {
        String data;
        if (node.getNodeType() == 3 && (data = ((Text)node).getData()).length() > 1 && data.charAt(0) == '\n' && (data.charAt(1) == '\n' || data.charAt(1) == ' ')) {
            ((Text)node).setData("\n");
        }
        for (Node currentChild = node.getFirstChild(); currentChild != null; currentChild = currentChild.getNextSibling()) {
            WSSecurityEngine.normalize(currentChild);
        }
    }

    protected void ensureSignature(javax.xml.rpc.handler.MessageContext msgCtx) throws Exception {
        Object obj = msgCtx.getProperty("org.globus.security.secMsg.msg.type");
        if (obj == null || !obj.equals(Constants.SIGNATURE)) {
            throw new WSSecurityException(0, "encRequiresSig");
        }
    }

    private boolean constantSet(Object msgVal, Object propValue) {
        return msgVal != null && msgVal.equals(propValue);
    }

    protected void setContextProperties(javax.xml.rpc.handler.MessageContext msgContext, SecurityContext secContext, Integer msgType) throws Exception {
        msgContext.setProperty("org.globus.security.secureconv.context", (Object)secContext);
        msgContext.setProperty("org.globus.security.secConv.msg.type", (Object)msgType);
        Subject subject = this.getSubject(msgContext);
        GSSContext ctx = secContext.getContext();
        GSSName caller = ctx.getSrcName();
        if (!caller.isAnonymous()) {
            ExtendedGSSContext extGss;
            X509Certificate[] certs;
            String callerIdentity = ((Object)caller).toString();
            GSSCredential cred = ctx.getDelegCred();
            if (ctx instanceof ExtendedGSSContext && (certs = (X509Certificate[])(extGss = (ExtendedGSSContext)ctx).inquireByOid(GSSConstants.X509_CERT_CHAIN)) != null) {
                subject.getPublicCredentials().add(certs);
            }
            subject.getPrincipals().add((Principal)new GlobusPrincipal(callerIdentity));
            if (cred != null) {
                subject.getPrivateCredentials().add(cred);
            }
        }
    }
}

