/*
 * Decompiled with CFR 0.152.
 */
package ise.antelope.tasks;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class Find
extends Task {
    private String findIn = null;
    private String regex = null;
    private String property = null;
    private int group = 0;
    private boolean dotall = false;
    private boolean caseInsensitive = false;
    private boolean multiLine = false;
    private boolean unicodeCase = false;
    private boolean canonEq = false;
    private boolean comments = false;
    private boolean unixLines = false;
    private boolean allMatches = false;
    private String separator = System.getProperty("line.separator");

    public void setIn(String string) {
        this.findIn = string;
    }

    public void setRegex(String regex) {
        this.regex = regex;
    }

    public void setProperty(String name) {
        this.property = name;
    }

    public void setGroup(int g) {
        this.group = g;
    }

    public void setDotall(boolean b) {
        this.dotall = b;
    }

    public void setCaseinsensitive(boolean b) {
        this.caseInsensitive = b;
    }

    public void setMultiline(boolean b) {
        this.multiLine = b;
    }

    public void setUnicodecase(boolean b) {
        this.unicodeCase = b;
    }

    public void setCanoneq(boolean b) {
        this.canonEq = b;
    }

    public void setComments(boolean b) {
        this.comments = b;
    }

    public void setUnixlines(boolean b) {
        this.unixLines = b;
    }

    public void setAllmatches(boolean b) {
        this.allMatches = b;
    }

    public void setSeparator(String s) {
        this.separator = s;
    }

    public void execute() {
        if (this.findIn == null) {
            throw new BuildException("'in' is required");
        }
        if (this.regex == null) {
            throw new BuildException("'regex' is required");
        }
        if (this.property == null) {
            throw new BuildException("'property' is required");
        }
        int flags = 0;
        if (this.dotall) {
            flags += 32;
        }
        if (this.caseInsensitive) {
            flags += 2;
        }
        if (this.multiLine) {
            flags += 8;
        }
        if (this.unicodeCase) {
            flags += 64;
        }
        if (this.canonEq) {
            flags += 128;
        }
        if (this.comments) {
            flags += 4;
        }
        if (this.unixLines) {
            ++flags;
        }
        try {
            String match;
            Pattern p = Pattern.compile(this.regex, flags);
            Matcher m = p.matcher(this.findIn);
            StringBuffer result = new StringBuffer();
            int count = 0;
            if (this.allMatches) {
                while (m.find()) {
                    String match2 = m.group(this.group);
                    if (match2 == null) continue;
                    result.append(match2).append(this.separator);
                    ++count;
                }
            } else if (m.find() && (match = m.group(this.group)) != null) {
                result.append(match);
            }
            if (result.length() > 0) {
                this.getProject().setUserProperty(this.property, result.toString());
                if (this.allMatches) {
                    this.getProject().setUserProperty(this.property + "_count", String.valueOf(count));
                }
            } else {
                this.log("No match.");
            }
        }
        catch (Exception e) {
            throw new BuildException(e.getMessage());
        }
    }
}

