/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.lang;

import com.ibm.icu.lang.UScript;
import com.ibm.icu.text.UCharacterIterator;

public final class UScriptRun {
    private static final String copyrightNotice = "Copyright \u00a91999-2002 IBM Corp.  All rights reserved.";
    private char[] emptyCharArray = new char[0];
    private UCharacterIterator text;
    private int textStart;
    private int textLimit;
    private int scriptStart;
    private int scriptLimit;
    private int scriptCode;
    private static int PAREN_STACK_DEPTH = 128;
    private static ParenStackEntry[] parenStack = new ParenStackEntry[PAREN_STACK_DEPTH];
    private int parenSP;
    private static int[] pairedChars = new int[]{40, 41, 60, 62, 91, 93, 123, 125, 171, 187, 8216, 8217, 8220, 8221, 8249, 8250, 12296, 12297, 12298, 12299, 12300, 12301, 12302, 12303, 12304, 12305, 12308, 12309, 12310, 12311, 12312, 12313, 12314, 12315};
    private static int pairedCharPower = 1 << UScriptRun.highBit(pairedChars.length);
    private static int pairedCharExtra = pairedChars.length - pairedCharPower;

    public UScriptRun() {
        char[] nullChars = null;
        this.reset(nullChars, 0, 0);
    }

    public UScriptRun(String text) {
        this.reset(text);
    }

    public UScriptRun(String text, int start, int count) {
        this.reset(text, start, count);
    }

    public UScriptRun(char[] chars) {
        this.reset(chars);
    }

    public UScriptRun(char[] chars, int start, int count) {
        this.reset(chars, start, count);
    }

    public final void reset() {
        this.scriptStart = this.textStart;
        this.scriptLimit = this.textStart;
        this.scriptCode = -1;
        this.parenSP = -1;
        this.text.setToStart();
    }

    public final void reset(int start, int count) throws IllegalArgumentException {
        int len = 0;
        if (this.text != null) {
            len = this.text.getLength();
        }
        if (start < 0 || count < 0 || start > len - count) {
            throw new IllegalArgumentException();
        }
        this.textStart = start;
        this.textLimit = start + count;
        this.reset();
    }

    public final void reset(char[] chars, int start, int count) {
        if (chars == null) {
            chars = this.emptyCharArray;
        }
        this.text = UCharacterIterator.getInstance(chars, start, start + count);
        this.reset(start, count);
    }

    public final void reset(char[] chars) {
        int length = 0;
        if (chars != null) {
            length = chars.length;
        }
        this.reset(chars, 0, length);
    }

    public final void reset(String text, int start, int count) {
        char[] chars = null;
        if (text != null) {
            chars = text.toCharArray();
        }
        this.reset(chars, start, count);
    }

    public final void reset(String text) {
        int length = 0;
        if (text != null) {
            length = text.length();
        }
        this.reset(text, 0, length);
    }

    public final int getScriptStart() {
        return this.scriptStart;
    }

    public final int getScriptLimit() {
        return this.scriptLimit;
    }

    public final int getScriptCode() {
        return this.scriptCode;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean next() {
        int ch;
        int startSP = this.parenSP;
        if (this.scriptLimit >= this.textLimit) {
            return false;
        }
        this.scriptCode = 0;
        this.scriptStart = this.scriptLimit;
        while ((ch = this.text.nextCodePoint()) != -1) {
            void var2_2;
            int sc = UScript.getScript((int)var2_2);
            int pairIndex = UScriptRun.getPairIndex((int)var2_2);
            if (pairIndex >= 0) {
                if ((pairIndex & 1) == 0) {
                    if (++this.parenSP >= PAREN_STACK_DEPTH) {
                        this.parenSP = 0;
                    }
                    UScriptRun.parenStack[this.parenSP] = new ParenStackEntry(pairIndex, this.scriptCode);
                } else if (this.parenSP >= 0) {
                    int pi = pairIndex & 0xFFFFFFFE;
                    while (this.parenSP >= 0 && UScriptRun.parenStack[this.parenSP].pairIndex != pi) {
                        --this.parenSP;
                    }
                    if (this.parenSP < startSP) {
                        startSP = this.parenSP;
                    }
                    if (this.parenSP >= 0) {
                        sc = UScriptRun.parenStack[this.parenSP].scriptCode;
                    }
                }
            }
            if (UScriptRun.sameScript(this.scriptCode, sc)) {
                if (this.scriptCode <= 1 && sc > 1) {
                    this.scriptCode = sc;
                    while (startSP < this.parenSP) {
                        UScriptRun.parenStack[++startSP].scriptCode = this.scriptCode;
                    }
                }
                if (pairIndex < 0 || (pairIndex & 1) == 0 || this.parenSP < 0) continue;
                --this.parenSP;
                --startSP;
                continue;
            }
            this.text.previousCodePoint();
            break;
        }
        this.scriptLimit = this.textStart + this.text.getIndex();
        return true;
    }

    private static boolean sameScript(int scriptOne, int scriptTwo) {
        return scriptOne <= 1 || scriptTwo <= 1 || scriptOne == scriptTwo;
    }

    private static final byte highBit(int n) {
        if (n <= 0) {
            return -32;
        }
        byte bit = 0;
        if (n >= 65536) {
            n >>= 16;
            bit = (byte)(bit + 16);
        }
        if (n >= 256) {
            n >>= 8;
            bit = (byte)(bit + 8);
        }
        if (n >= 16) {
            n >>= 4;
            bit = (byte)(bit + 4);
        }
        if (n >= 4) {
            n >>= 2;
            bit = (byte)(bit + 2);
        }
        if (n >= 2) {
            n >>= 1;
            bit = (byte)(bit + 1);
        }
        return bit;
    }

    private static int getPairIndex(int ch) {
        int probe = pairedCharPower;
        int index = 0;
        if (ch >= pairedChars[pairedCharExtra]) {
            index = pairedCharExtra;
        }
        while (probe > 1) {
            if (ch < pairedChars[index + (probe >>= 1)]) continue;
            index += probe;
        }
        if (pairedChars[index] != ch) {
            index = -1;
        }
        return index;
    }

    private static final class ParenStackEntry {
        int pairIndex;
        int scriptCode;

        public ParenStackEntry(int thePairIndex, int theScriptCode) {
            this.pairIndex = thePairIndex;
            this.scriptCode = theScriptCode;
        }
    }
}

