/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.resources;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import org.apache.naming.NameParserImpl;
import org.apache.naming.StringManager;

public abstract class BaseDirContext
implements DirContext {
    protected String docBase = null;
    protected Hashtable env;
    protected StringManager sm = StringManager.getManager("org.apache.naming.resources");
    protected final NameParser nameParser = new NameParserImpl();
    protected boolean cached = true;
    protected int cacheTTL = 5000;
    protected int cacheMaxSize = 10240;

    public BaseDirContext() {
        this.env = new Hashtable();
    }

    public BaseDirContext(Hashtable hashtable) {
        this.env = hashtable;
    }

    public String getDocBase() {
        return this.docBase;
    }

    public void setDocBase(String string) {
        if (string == null) {
            throw new IllegalArgumentException(this.sm.getString("resources.null"));
        }
        this.docBase = string;
    }

    public void setCached(boolean bl) {
        this.cached = bl;
    }

    public boolean isCached() {
        return this.cached;
    }

    public void setCacheTTL(int n) {
        this.cacheTTL = n;
    }

    public int getCacheTTL() {
        return this.cacheTTL;
    }

    public int getCacheMaxSize() {
        return this.cacheMaxSize;
    }

    public void setCacheMaxSize(int n) {
        this.cacheMaxSize = n;
    }

    public void allocate() {
    }

    public void release() {
    }

    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    public abstract Object lookup(String var1) throws NamingException;

    public void bind(Name name, Object object) throws NamingException {
        this.bind(name.toString(), object);
    }

    public void bind(String string, Object object) throws NamingException {
        this.bind(string, object, null);
    }

    public void rebind(Name name, Object object) throws NamingException {
        this.rebind(name.toString(), object);
    }

    public void rebind(String string, Object object) throws NamingException {
        this.rebind(string, object, null);
    }

    public void unbind(Name name) throws NamingException {
        this.unbind(name.toString());
    }

    public abstract void unbind(String var1) throws NamingException;

    public void rename(Name name, Name name2) throws NamingException {
        this.rename(name.toString(), name2.toString());
    }

    public abstract void rename(String var1, String var2) throws NamingException;

    public NamingEnumeration list(Name name) throws NamingException {
        return this.list(name.toString());
    }

    public abstract NamingEnumeration list(String var1) throws NamingException;

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.listBindings(name.toString());
    }

    public abstract NamingEnumeration listBindings(String var1) throws NamingException;

    public void destroySubcontext(Name name) throws NamingException {
        this.destroySubcontext(name.toString());
    }

    public abstract void destroySubcontext(String var1) throws NamingException;

    public Context createSubcontext(Name name) throws NamingException {
        return this.createSubcontext(name.toString());
    }

    public Context createSubcontext(String string) throws NamingException {
        return this.createSubcontext(string, null);
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.lookupLink(name.toString());
    }

    public abstract Object lookupLink(String var1) throws NamingException;

    public NameParser getNameParser(Name name) throws NamingException {
        return new NameParserImpl();
    }

    public NameParser getNameParser(String string) throws NamingException {
        return new NameParserImpl();
    }

    public Name composeName(Name name, Name name2) throws NamingException {
        name2 = (Name)name.clone();
        return name2.addAll(name);
    }

    public String composeName(String string, String string2) throws NamingException {
        return string2 + "/" + string;
    }

    public Object addToEnvironment(String string, Object object) throws NamingException {
        return this.env.put(string, object);
    }

    public Object removeFromEnvironment(String string) throws NamingException {
        return this.env.remove(string);
    }

    public Hashtable getEnvironment() throws NamingException {
        return this.env;
    }

    public void close() throws NamingException {
        this.env.clear();
    }

    public abstract String getNameInNamespace() throws NamingException;

    public Attributes getAttributes(Name name) throws NamingException {
        return this.getAttributes(name.toString());
    }

    public Attributes getAttributes(String string) throws NamingException {
        return this.getAttributes(string, null);
    }

    public Attributes getAttributes(Name name, String[] stringArray) throws NamingException {
        return this.getAttributes(name.toString(), stringArray);
    }

    public abstract Attributes getAttributes(String var1, String[] var2) throws NamingException;

    public void modifyAttributes(Name name, int n, Attributes attributes) throws NamingException {
        this.modifyAttributes(name.toString(), n, attributes);
    }

    public abstract void modifyAttributes(String var1, int var2, Attributes var3) throws NamingException;

    public void modifyAttributes(Name name, ModificationItem[] modificationItemArray) throws NamingException {
        this.modifyAttributes(name.toString(), modificationItemArray);
    }

    public abstract void modifyAttributes(String var1, ModificationItem[] var2) throws NamingException;

    public void bind(Name name, Object object, Attributes attributes) throws NamingException {
        this.bind(name.toString(), object, attributes);
    }

    public abstract void bind(String var1, Object var2, Attributes var3) throws NamingException;

    public void rebind(Name name, Object object, Attributes attributes) throws NamingException {
        this.rebind(name.toString(), object, attributes);
    }

    public abstract void rebind(String var1, Object var2, Attributes var3) throws NamingException;

    public DirContext createSubcontext(Name name, Attributes attributes) throws NamingException {
        return this.createSubcontext(name.toString(), attributes);
    }

    public abstract DirContext createSubcontext(String var1, Attributes var2) throws NamingException;

    public DirContext getSchema(Name name) throws NamingException {
        return this.getSchema(name.toString());
    }

    public abstract DirContext getSchema(String var1) throws NamingException;

    public DirContext getSchemaClassDefinition(Name name) throws NamingException {
        return this.getSchemaClassDefinition(name.toString());
    }

    public abstract DirContext getSchemaClassDefinition(String var1) throws NamingException;

    public NamingEnumeration search(Name name, Attributes attributes, String[] stringArray) throws NamingException {
        return this.search(name.toString(), attributes, stringArray);
    }

    public abstract NamingEnumeration search(String var1, Attributes var2, String[] var3) throws NamingException;

    public NamingEnumeration search(Name name, Attributes attributes) throws NamingException {
        return this.search(name.toString(), attributes);
    }

    public abstract NamingEnumeration search(String var1, Attributes var2) throws NamingException;

    public NamingEnumeration search(Name name, String string, SearchControls searchControls) throws NamingException {
        return this.search(name.toString(), string, searchControls);
    }

    public abstract NamingEnumeration search(String var1, String var2, SearchControls var3) throws NamingException;

    public NamingEnumeration search(Name name, String string, Object[] objectArray, SearchControls searchControls) throws NamingException {
        return this.search(name.toString(), string, objectArray, searchControls);
    }

    public abstract NamingEnumeration search(String var1, String var2, Object[] var3, SearchControls var4) throws NamingException;
}

