/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.trust2;

import java.util.ArrayList;
import org.apache.ws.security.trust2.SecurityTokenMessage;
import org.apache.ws.security.trust2.SecurityTokenOrReference;
import org.apache.ws.security.trust2.exception.ElementParsingException;
import org.apache.ws.security.trust2.exception.NoTokenInResponse;
import org.apache.ws.security.trust2.exception.TrustException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RequestSecurityTokenResponse
extends SecurityTokenMessage {
    protected SecurityTokenOrReference requestedSecurityToken = null;
    protected SecurityTokenOrReference requestedProofToken = null;

    public RequestSecurityTokenResponse(Document doc) {
        super(doc);
    }

    public RequestSecurityTokenResponse(Document doc, SecurityTokenOrReference requestedSecurityToken) {
        super(doc);
        this.requestedSecurityToken = requestedSecurityToken;
    }

    public RequestSecurityTokenResponse(Element element) throws ElementParsingException {
        super(element);
        this.initialize();
    }

    public RequestSecurityTokenResponse(Element element, Document document) throws ElementParsingException {
        super(element, document);
        this.initialize();
    }

    private void initialize() throws ElementParsingException {
        ArrayList elements = (ArrayList)this.customElements.clone();
        this.customElements.clear();
        for (int i = 0; i < elements.size(); ++i) {
            Element elem;
            Element currentNode = (Element)elements.get(i);
            if (!"http://schemas.xmlsoap.org/ws/2004/04/trust".equals(currentNode.getNamespaceURI())) {
                this.addCustomElement(currentNode);
                continue;
            }
            if (currentNode.getLocalName().equals("RequestedSecurityToken")) {
                elem = this.getFirstNonBlankChildAsElement(currentNode);
                if (elem == null) continue;
                this.setRequestedSecurityToken(new SecurityTokenOrReference(elem, this.doc));
                continue;
            }
            if (currentNode.getLocalName().equals("RequestedProofToken")) {
                elem = this.getFirstNonBlankChildAsElement(currentNode);
                if (elem == null) continue;
                this.setRequestedProofToken(new SecurityTokenOrReference(elem, this.doc));
                continue;
            }
            this.addCustomElement(currentNode);
        }
    }

    public SecurityTokenOrReference getRequestedSecurityToken() {
        return this.requestedSecurityToken;
    }

    public void setRequestedSecurityToken(SecurityTokenOrReference requestedToken) {
        this.requestedSecurityToken = requestedToken;
    }

    public SecurityTokenOrReference getRequestedProofToken() {
        return this.requestedProofToken;
    }

    public void setRequestedProofToken(SecurityTokenOrReference requestedProofToken) {
        this.requestedProofToken = requestedProofToken;
    }

    public Element getElement() throws TrustException {
        Element wstElement = this.getElement("wst:RequestSecurityTokenResponse");
        if (this.requestedSecurityToken == null && this.requestedProofToken == null) {
            throw new NoTokenInResponse("Either a RequestedSecurityToken or a RequestedProofToken is required. Both cannot be null.");
        }
        if (this.requestedSecurityToken != null) {
            wstElement.appendChild(this.createTokenOrReferenceElement("wst:RequestedSecurityToken", this.requestedSecurityToken));
        } else if (this.requestedProofToken != null) {
            wstElement.appendChild(this.createTokenOrReferenceElement("wst:RequestedProofToken", this.requestedSecurityToken));
        }
        return wstElement;
    }
}

