/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.security.utils;

import java.io.File;
import java.io.StringReader;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.gcube.common.core.security.GCUBEDefaultSecurityConfiguration;
import org.gcube.common.core.security.utils.CredentialPropagationStatus;
import org.gcube.common.core.security.utils.DefaultSecurityConfigurationBean;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.globus.wsrf.impl.security.descriptor.ServiceSecurityDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class DefaultSecurityDescriptorBuilder {
    private GCUBELog logger = new GCUBELog(this);
    private final String SERVICE_SEC_DESC_MODEL = "<securityConfig xmlns=\"%NAMESPACE%\"><auth-method>%AUTH_METHOD%<protection-level>%PROT_LEVELS%</protection-level>%_AUTH_METHOD%</auth-method></securityConfig>";
    private final String SD_NAMESPACE = "http://www.globus.org";
    private final String DS_IN_ELEMENT = "in";
    private final String DS_OUT_ELEMENT = "out";
    private final String DS_AUTH_METHOD_ELEMENT = "auth_method";
    private final String DS_PROTECTION_LEVEL_ELEMENT = "protection_level";
    private final String DS_ENABLED_ATTRIBUTE = "enabled";
    private final String DS_OVERRIDE_ATTRIBUTE = "override";
    private final String DS_CRED_PROP_ELEMENT = "propagateCallerCredentials";
    private final String DS_CRED_VALUE_ATTRIBUTE = "value";
    private ServiceSecurityDescriptor incomingSecurityDescriptor;
    private ServiceSecurityDescriptor outgoingSecurityDescriptor;
    private DefaultSecurityConfigurationBean defaultIncomingConfiguration;
    private DefaultSecurityConfigurationBean defaultOutgoinfConfiguration;
    private CredentialPropagationStatus credentialPropagationStatus;

    public DefaultSecurityDescriptorBuilder(String defaultSecConfPath) throws Exception {
        if (defaultSecConfPath == null) {
            throw new Exception("Null default path");
        }
        Document defaultServiceSecConfDocument = this.loadDefaultSecConfigurationDocument(defaultSecConfPath);
        Element rootElement = defaultServiceSecConfDocument.getDocumentElement();
        this.logger.debug("loading default ingoing security configuration");
        this.defaultIncomingConfiguration = this.generateDefaultSecurityConfiguration(rootElement, "in");
        this.logger.debug("default ingoing security configuration loaded");
        this.logger.debug("loading default outgoing security configuration");
        this.defaultOutgoinfConfiguration = this.generateDefaultSecurityConfiguration(rootElement, "out");
        this.logger.debug("default outgoing security configuration loaded");
        this.logger.debug("Trying to build default ingoing service security descriptor...");
        this.incomingSecurityDescriptor = this.buildServiceSecurityDescriptor(this.defaultIncomingConfiguration);
        this.logger.debug("Default ingoing service security descriptor generated");
        this.logger.debug("Trying to build default outgoing service security descriptor...");
        this.outgoingSecurityDescriptor = this.buildServiceSecurityDescriptor(this.defaultOutgoinfConfiguration);
        this.logger.debug("Default outgoing service security descriptor generated");
        this.logger.debug("Trying to get the credential propagation configuration");
        this.credentialPropagationStatus = this.buildCredentialPropagationConfiguration(rootElement);
        this.logger.debug("Credential propagation configuration gotten");
    }

    private ServiceSecurityDescriptor buildServiceSecurityDescriptor(DefaultSecurityConfigurationBean defaultConfiguration) throws Exception {
        this.logger.debug("Trying to build default service security descriptor...");
        ServiceSecurityDescriptor response = null;
        if (defaultConfiguration.isEnabled()) {
            this.logger.debug("Default ingoing service security descriptor is enabled");
            response = this.generateServiceSecurityDescriptor(defaultConfiguration);
        } else {
            this.logger.debug("Default service security configuration disabled");
        }
        return response;
    }

    private ServiceSecurityDescriptor generateServiceSecurityDescriptor(DefaultSecurityConfigurationBean defaultConfiguration) throws Exception {
        this.logger.debug("Generating service security descriptor...");
        ServiceSecurityDescriptor response = null;
        String authMethod = defaultConfiguration.getIn_auth_method();
        Set<String> protectionLevels = defaultConfiguration.getIn_protection_levels();
        String secDescDocument = this.generateServiceSecurityDescriptorDom(authMethod, protectionLevels);
        this.logger.debug(secDescDocument);
        Element input = this.stringToElement(secDescDocument);
        this.logger.debug("Element generated");
        response = new ServiceSecurityDescriptor();
        response.parse(input);
        this.logger.debug("Sec descriptor generated");
        return response;
    }

    private CredentialPropagationStatus buildCredentialPropagationConfiguration(Element rootElement) {
        this.logger.debug("Getting credential propagation configuration");
        CredentialPropagationStatus response = new CredentialPropagationStatus();
        NodeList credPropNodes = rootElement.getElementsByTagName("propagateCallerCredentials");
        if (credPropNodes != null && credPropNodes.getLength() > 0) {
            this.logger.debug("Credential propagation configuration found");
            Element credPropElement = (Element)credPropNodes.item(0);
            String value = credPropElement.getAttribute("value");
            if (value != null) {
                this.logger.debug("Credential propagation value = " + value);
                if (value.equalsIgnoreCase("false")) {
                    response.setPropagate(false);
                    response.setOverride(this.getCredentialPropagationOverrideAttribute(credPropElement));
                } else if (value.equalsIgnoreCase("true")) {
                    response.setPropagate(true);
                    response.setOverride(this.getCredentialPropagationOverrideAttribute(credPropElement));
                } else {
                    this.logger.warn("Unable to find a correct credential propagation value attribute: default credential propagation behaviour disabled");
                }
            } else {
                this.logger.warn("Unable to find a correct credential propagation value attribute: default credential propagation behaviour disabled");
            }
        }
        return response;
    }

    private boolean getCredentialPropagationOverrideAttribute(Element credPropElement) {
        this.logger.debug("getting cred propagation override attribute");
        String override = credPropElement.getAttribute("override");
        this.logger.debug("override value = " + override);
        if (override == null) {
            this.logger.debug("Override value not set, returning false");
            return false;
        }
        if (override.equalsIgnoreCase("true")) {
            this.logger.debug("Override value true");
            return true;
        }
        if (override.equalsIgnoreCase("false")) {
            this.logger.debug("Override value false");
            return false;
        }
        this.logger.warn("Invalid override value " + override + " returning the default value false");
        return false;
    }

    public ServiceSecurityDescriptor getIncomingMessagesSecurityDescriptor() {
        return this.incomingSecurityDescriptor;
    }

    public ServiceSecurityDescriptor getOutgoingMessagesSecurityDescriptor() {
        return this.outgoingSecurityDescriptor;
    }

    public GCUBEDefaultSecurityConfiguration getGCUBEDefaultSecurityConfiguration() {
        GCUBEDefaultSecurityConfiguration response = new GCUBEDefaultSecurityConfiguration();
        response.setDefaultCredentialPropagationSet(this.credentialPropagationStatus.isSet());
        response.setPropagateCallerCredentials(this.credentialPropagationStatus.isPropagate());
        response.setPropagateCallerCredentialsOverride(this.credentialPropagationStatus.isOverride());
        response.setInEnabled(this.defaultIncomingConfiguration.isEnabled());
        response.setOutEnabled(this.defaultOutgoinfConfiguration.isEnabled());
        response.setInOverride(this.defaultIncomingConfiguration.isOverride());
        response.setOutOverride(this.defaultOutgoinfConfiguration.isOverride());
        return response;
    }

    private Document loadDefaultSecConfigurationDocument(String path) throws Exception {
        this.logger.debug("Building dom...");
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = builder.parse(new File(path));
        this.logger.debug("document loaded");
        return document;
    }

    private DefaultSecurityConfigurationBean generateDefaultSecurityConfiguration(Element root, String baseElementTagName) throws Exception {
        this.logger.debug("Parsing default sec configuration...");
        DefaultSecurityConfigurationBean defaultConfiguration = new DefaultSecurityConfigurationBean();
        this.logger.debug("Default Security document root " + root.getNamespaceURI() + " " + root.getNodeName());
        NodeList baseElements = root.getElementsByTagName(baseElementTagName);
        if (baseElements != null && baseElements.getLength() != 0) {
            this.logger.debug("security configuration");
            Element baseElement = (Element)baseElements.item(0);
            String enabledString = baseElement.getAttribute("enabled");
            if (enabledString == null || enabledString.equalsIgnoreCase("true")) {
                String[] protectionLevel;
                defaultConfiguration.setEnabled(true);
                String override = baseElement.getAttribute("override");
                this.logger.debug("override = " + override);
                defaultConfiguration.setOverride(override);
                this.logger.debug("loading auth method element...");
                String authMethod = this.getText("auth_method", baseElement, true);
                defaultConfiguration.setAuth_method(authMethod);
                this.logger.debug("auth method element loaded");
                this.logger.debug("loading protection level element...");
                String protectionLevelList = this.getText("protection_level", baseElement, true);
                for (String p : protectionLevel = protectionLevelList.split(",")) {
                    defaultConfiguration.addProtection_level(p);
                }
                this.logger.debug("protetion level loaded");
            } else {
                this.logger.debug("default security configuration disabled");
            }
        }
        return defaultConfiguration;
    }

    private String findInternalText(Element element, boolean required) throws Exception {
        this.logger.debug("Adding text");
        String data = null;
        Text text = (Text)element.getFirstChild();
        if (text != null) {
            data = text.getData();
            this.logger.debug("data " + data);
            return data;
        }
        if (required) {
            this.logger.error("No text found");
            throw new Exception("No text found");
        }
        this.logger.debug("Text element not found");
        return data;
    }

    private String getText(String elementName, Element parent, boolean required) throws Exception {
        this.logger.debug("Founding text element " + elementName);
        String data = null;
        NodeList elementList = parent.getElementsByTagName(elementName);
        if (elementList != null && elementList.getLength() > 0) {
            Element element = (Element)elementList.item(0);
            data = this.findInternalText(element, required);
        } else {
            if (required) {
                this.logger.error("Root Element not found");
                throw new Exception("Invalid auth configuration: required element not found");
            }
            this.logger.debug("Delegation element not found");
        }
        return data;
    }

    private String generateServiceSecurityDescriptorDom(String authMethod, Set<String> protectionLevels) throws ParserConfigurationException {
        this.logger.debug("Building dom...");
        String builder = new String("<securityConfig xmlns=\"%NAMESPACE%\"><auth-method>%AUTH_METHOD%<protection-level>%PROT_LEVELS%</protection-level>%_AUTH_METHOD%</auth-method></securityConfig>");
        builder = builder.replace("%NAMESPACE%", "http://www.globus.org");
        String authMethodElement = "<" + authMethod + ">";
        String authCloseMethodElement = "</" + authMethod + ">";
        builder = builder.replace("%AUTH_METHOD%", authMethodElement);
        builder = builder.replace("%_AUTH_METHOD%", authCloseMethodElement);
        StringBuilder protLevel = new StringBuilder();
        for (String protectionLevel : protectionLevels) {
            protLevel.append("<").append(protectionLevel).append("/>");
        }
        builder = builder.replace("%PROT_LEVELS%", protLevel.toString());
        return builder;
    }

    private Element stringToElement(String nodeAsString) throws Exception {
        Document xml = this.string2Document(nodeAsString);
        Element element = xml.getDocumentElement();
        return element;
    }

    private Document string2Document(String xmlString) {
        Document doc = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.parse(new InputSource(new StringReader(xmlString)));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return doc;
    }
}

