/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport;

import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportFilter;
import org.apache.activemq.transport.tcp.TcpBufferedOutputStream;

public class WriteTimeoutFilter
extends TransportFilter {
    protected static ConcurrentLinkedQueue<WriteTimeoutFilter> writers = new ConcurrentLinkedQueue();
    protected static AtomicInteger messageCounter = new AtomicInteger(0);
    protected static TimeoutThread timeoutThread = new TimeoutThread();
    protected long writeTimeout = -1L;

    public WriteTimeoutFilter(Transport next) {
        super(next);
    }

    public void oneway(Object command) throws IOException {
        try {
            WriteTimeoutFilter.registerWrite(this);
            super.oneway(command);
        }
        catch (IOException x) {
            WriteTimeoutFilter.deRegisterWrite(this, true, x);
            throw x;
        }
        finally {
            WriteTimeoutFilter.deRegisterWrite(this, false, null);
        }
    }

    public long getWriteTimeout() {
        return this.writeTimeout;
    }

    public void setWriteTimeout(long writeTimeout) {
        this.writeTimeout = writeTimeout;
    }

    protected TcpBufferedOutputStream getWriter() {
        return this.next.narrow(TcpBufferedOutputStream.class);
    }

    protected static void registerWrite(WriteTimeoutFilter filter) {
        writers.add(filter);
    }

    protected static boolean deRegisterWrite(WriteTimeoutFilter filter, boolean fail, IOException iox) {
        boolean result = writers.remove(filter);
        if (result && fail) {
            IOException ex = iox != null ? iox : new IOException("Forced write timeout for:" + filter.getNext().getRemoteAddress());
            filter.getTransportListener().onException(ex);
        }
        return result;
    }

    public void start() throws Exception {
        super.start();
    }

    public void stop() throws Exception {
        super.stop();
    }

    protected static class TimeoutThread
    extends Thread {
        static AtomicInteger instance = new AtomicInteger(0);
        boolean run = true;

        public TimeoutThread() {
            this.setName("WriteTimeoutFilter-Timeout-" + instance.incrementAndGet());
            this.setDaemon(true);
            this.setPriority(1);
            this.start();
        }

        public void run() {
            while (this.run) {
                if (!TimeoutThread.interrupted()) {
                    Iterator<WriteTimeoutFilter> filters = writers.iterator();
                    while (this.run && filters.hasNext()) {
                        WriteTimeoutFilter filter = filters.next();
                        if (filter.getWriteTimeout() <= 0L) continue;
                        long writeStart = filter.getWriter().getWriteTimestamp();
                        long delta = filter.getWriter().isWriting() && writeStart > 0L ? System.currentTimeMillis() - writeStart : -1L;
                        if (delta <= filter.getWriteTimeout()) continue;
                        WriteTimeoutFilter.deRegisterWrite(filter, true, null);
                    }
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

